/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import com.avaya.ingensg.ce.wa.imrest.common.model.Resource;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.EnumValue;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidProficiencyRange;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidService;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource;
import com.avaya.ingensg.wa.common.im.TaskType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ValidSpecifiedResource
public abstract class MatchRequest {
    @ApiModelProperty(value="Strategy to use when matching", required=true, allowableValues="RSSMostIdle, RSSOccupancy", position=1)
    @NotNull(message="The strategy cannot be null")
    @Pattern(regexp="RSSMostIdle|RSSOccupancy", message="The provided strategy must be one of RSSMostIdle or RSSOccupancy")
    private String strategy;
    @ApiModelProperty(value="Used to return a single resource for Q2M or Muliple resource for TeamBuilder", required=true, allowableValues="SINGLE_RESOURCE, MULTI_RESOURCE, GROUP_RESOURCE, MULTI_RESOURCE_QUERY", position=2, dataType="com.avaya.ingensg.wa.common.im.TaskType")
    @EnumValue(enumClass=TaskType.class)
    private String taskType;
    @ApiModelProperty(value="workRequestId is used as a session identifier to track overarching contact across the solution", required=true, position=3)
    @NotNull(message="The workRequestId cannot be null")
    private String workRequestId;
    @ApiModelProperty(value="Ordered Map of Resources we want to match against", required=true, notes="min = 0, max = 3", position=4)
    @Size(min=0, max=3, message="A maximum of {max} resources are permitted within the resource map")
    @Valid
    private Map<Integer, Resource> resourceMap;
    @ApiModelProperty(value="Ordered Map of Services we want to match against", required=true, notes="max = 6", position=5)
    @Size(max=6, message="A maximum of {max} services are permitted within the service map")
    @Valid
    @ValidService
    @ValidProficiencyRange
    private Map<Integer, Service> serviceMap;

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public void setWorkRequestId(String workRequestId) {
        this.workRequestId = workRequestId;
    }

    public Map<Integer, Resource> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<Integer, Resource> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public Map<Integer, Service> getServiceMap() {
        return this.serviceMap;
    }

    public void setServiceMap(Map<Integer, Service> serviceMap) {
        this.serviceMap = serviceMap;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

