/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.EnumValue;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumValueValidator
implements ConstraintValidator<EnumValue, String> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(EnumValueValidator.class);
    private EnumValue constraintAnnotation;

    public void initialize(EnumValue constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        String methodName = "isValid";
        boolean valid = false;
        Class<Enum<?>> enumClass = this.constraintAnnotation.enumClass();
        Object[] enumValues = enumClass.getEnumConstants();
        if (null != enumValues && null != value) {
            for (Enum<?> enum_ : enumValues) {
                if (!value.equals(enum_.toString()) && (!this.constraintAnnotation.ignoreCase() || !value.equalsIgnoreCase(enum_.toString()))) continue;
                valid = true;
                break;
            }
        }
        if (!valid) {
            String msgDefault = context.getDefaultConstraintMessageTemplate();
            String msgFormatada = String.format(msgDefault, enumClass.getSimpleName(), Arrays.toString(enumValues));
            LOG.error("isValid", "", msgFormatada, new Object[0]);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(msgFormatada).addConstraintViolation();
        }
        return valid;
    }
}

