/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.QueryResourceRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidQueryResourceValidator
implements ConstraintValidator<ValidQueryResource, QueryResourceRequest> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidQueryResourceValidator.class);
    public static final int SERVICE_MAP_START_INDEX = 1;

    public void initialize(ValidQueryResource constraintAnnotation) {
    }

    public boolean isValid(QueryResourceRequest queryResourceRequest, ConstraintValidatorContext context) {
        Integer rank;
        Integer resourceCount;
        Integer priority;
        Service service;
        String methodName = "isValid";
        if (null == queryResourceRequest) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        Map<Integer, Service> serviceMap = queryResourceRequest.getServiceMap();
        if (serviceMap == null) {
            return valid;
        }
        if (serviceMap.size() != 1) {
            valid = false;
            LOG.error("isValid", "", "Number of services in a Query resource request should be 1 : {}", new Object[]{queryResourceRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource.maxServices}").addConstraintViolation();
        } else if (serviceMap.containsKey(1) && (service = serviceMap.get(1)) != null && !this.isValidService(priority = service.getPriority(), resourceCount = service.getResourceCount(), rank = service.getRank(), queryResourceRequest, context)) {
            valid = false;
        }
        return valid;
    }

    private boolean isValidService(Integer priority, Integer resourceCount, Integer rank, QueryResourceRequest queryResourceRequest, ConstraintValidatorContext context) {
        String methodName = "isValidService";
        boolean valid = true;
        if (null == resourceCount) {
            valid = false;
            LOG.error("isValidService", "", "The resourceCount for a Query resource request cannot be null. {}", new Object[]{queryResourceRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource.resourceCount}").addConstraintViolation();
        } else if (resourceCount > 50) {
            valid = false;
            LOG.error("isValidService", "", "The resourceCount for the Query resource request exceeds the max 50. {}", new Object[]{queryResourceRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource.maxResourceCount}").addConstraintViolation();
        }
        if (null != priority) {
            valid = false;
            LOG.error("isValidService", "", "A priority for a Query resource request must not be specified. {}", new Object[]{queryResourceRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource.priority}").addConstraintViolation();
        }
        if (null != rank) {
            valid = false;
            LOG.error("isValidService", "", "A rank for a Query resource request must not be specified. {}", new Object[]{queryResourceRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidQueryResource.rank}").addConstraintViolation();
        }
        return valid;
    }
}

