/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidService;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidServiceValidator
implements ConstraintValidator<ValidService, Map<Integer, Service>> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidServiceValidator.class);
    private static final Integer SERVICE_ID_MINIMUM = 1;
    private static final Integer SERVICE_ID_MAXIMUM = 6;
    private static final Integer ATTRIBUTES_MINIMUM = 1;
    private static final Integer ATTRIBUTES_MAXIMUM = 10;

    public void initialize(ValidService constraintAnnotation) {
    }

    public boolean isValid(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean validKeys = this.isKeysValid(serviceMap, context);
        boolean validCategories = this.isCategoriesValid(serviceMap, context);
        boolean validAttributes = this.isValidAttributes(serviceMap, context);
        boolean hasNoDuplicateServices = this.containsDuplicateServices(serviceMap, context);
        return validKeys && validCategories && validAttributes && hasNoDuplicateServices;
    }

    public boolean isKeysValid(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        String methodName = "isKeysValid";
        if (serviceMap != null && serviceMap.size() <= SERVICE_ID_MAXIMUM) {
            for (Integer key : serviceMap.keySet()) {
                if (key >= SERVICE_ID_MINIMUM && key <= SERVICE_ID_MAXIMUM) continue;
                LOG.error("isKeysValid", "", "Invalid ServiceId : {} in the serviceMap. Allowable service IDs are in the range 1 to 6 ", new Object[]{key});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidService.serviceId}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    public boolean isCategoriesValid(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        String methodName = "isCategoriesValid";
        if (serviceMap != null) {
            for (Service service : serviceMap.values()) {
                if (service == null || service.getAttributes() == null) continue;
                for (String categoryName : service.getAttributes().keySet()) {
                    if (categoryName != null && !categoryName.trim().isEmpty()) continue;
                    String errorMessage = String.format("keys can not be null or empty in a attributes Map.%s", service.getAttributes());
                    LOG.error("isCategoriesValid", "", errorMessage, new Object[0]);
                    context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isValidAttributes(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        String methodName = "isAttrbutesAvailable";
        if (serviceMap != null) {
            for (Service service : serviceMap.values()) {
                Map<String, List<String>> attributes;
                if (service == null || (attributes = service.getAttributes()) == null) continue;
                int totalNumberOfAttributes = this.getTotalNumberOfAttributes(attributes);
                int numberOfChannelAttributes = this.getNumberOfChannelAttributes(attributes);
                if (totalNumberOfAttributes < ATTRIBUTES_MINIMUM || totalNumberOfAttributes > ATTRIBUTES_MAXIMUM) {
                    LOG.error("isAttrbutesAvailable", "", "There must be at least {} and at most {} attributes in the map", new Object[]{ATTRIBUTES_MINIMUM, ATTRIBUTES_MAXIMUM});
                    context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.validation.constraints.ValidService.attributes.totalCount}").addConstraintViolation();
                    return false;
                }
                if (numberOfChannelAttributes > 1) {
                    LOG.error("isAttrbutesAvailable", "", "Channel attribute can not be duplicated in attributes map : {}", new Object[]{service});
                    context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.validation.constraints.ValidService.attributes.duplicateChannels}").addConstraintViolation();
                    return false;
                }
                for (Map.Entry<String, List<String>> attributeEntry : attributes.entrySet()) {
                    String attributeName = attributeEntry.getKey();
                    List<String> attributesList = attributeEntry.getValue();
                    for (String attributeValue : attributesList) {
                        if (attributeValue != null && !attributeValue.trim().isEmpty()) continue;
                        String errorMessage = String.format("attribute list for the attribute %s has an empty/null value. %s", attributeName, attributesList);
                        LOG.error("isAttrbutesAvailable", "", errorMessage, new Object[0]);
                        context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private int getNumberOfChannelAttributes(Map<String, List<String>> attributes) {
        int numberOfChannelAttributes = 0;
        for (Map.Entry<String, List<String>> category : attributes.entrySet()) {
            if (!category.getKey().equalsIgnoreCase("channel")) continue;
            numberOfChannelAttributes = category.getValue().size();
        }
        return numberOfChannelAttributes;
    }

    private int getTotalNumberOfAttributes(Map<String, List<String>> attributes) {
        int totalNumberOfAttributes = 0;
        for (Map.Entry<String, List<String>> category : attributes.entrySet()) {
            totalNumberOfAttributes += category.getValue().size();
        }
        return totalNumberOfAttributes;
    }

    private void processServiceElements(List<Integer> duplicateServices, Service service1, Integer serviceId1, Service service2, Integer serviceId2) {
        boolean sameServices;
        String methodName = "processServiceElements";
        boolean bl = sameServices = this.isSameAttributes(service1, service2) && this.isSameResourceCount(service1, service2);
        if (sameServices) {
            LOG.warn("processServiceElements", "", "services {} and {} are duplicates.", new Object[]{serviceId1, serviceId2});
            if (!duplicateServices.contains(serviceId1)) {
                duplicateServices.add(serviceId1);
            }
            if (!duplicateServices.contains(serviceId2)) {
                duplicateServices.add(serviceId2);
            }
        } else {
            LOG.debug("processServiceElements", "", "services {} and {} are not duplicates.", new Object[]{serviceId1, serviceId2});
        }
    }

    private List<Integer> compareServices(Map<Integer, Service> serviceMap) {
        String methodName = "compareServices";
        ArrayList<Integer> duplicateServices = new ArrayList<Integer>();
        if (serviceMap != null) {
            for (Map.Entry<Integer, Service> serviceEntry : serviceMap.entrySet()) {
                Integer serviceId1 = serviceEntry.getKey();
                Service service1 = serviceEntry.getValue();
                for (Map.Entry<Integer, Service> serviceToCheck : serviceMap.entrySet()) {
                    Integer serviceId2 = serviceToCheck.getKey();
                    Service service2 = serviceToCheck.getValue();
                    LOG.debug("compareServices", "", "comparing two services: {} and {}", new Object[]{serviceId1, serviceId2});
                    if (service1 == null || service2 == null || serviceId1.equals(serviceToCheck.getKey())) {
                        LOG.debug("compareServices", "", "same service or a service in comparission is null. need not check. {}, {}", new Object[]{serviceId1, serviceId2});
                        continue;
                    }
                    this.processServiceElements(duplicateServices, service1, serviceId1, service2, serviceId2);
                }
            }
        }
        return duplicateServices;
    }

    public boolean containsDuplicateServices(Map<Integer, Service> serviceMap, ConstraintValidatorContext context) {
        String methodName = "containsDuplicateServices";
        List<Integer> duplicateServices = this.compareServices(serviceMap);
        if (duplicateServices.size() > 0) {
            String errorMessage = ValidServiceValidator.createDuplicateErrorMessage(duplicateServices);
            LOG.error("containsDuplicateServices", "", errorMessage + " : {}", new Object[]{serviceMap});
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isSameAttributes(Service service1, Service service2) {
        boolean isSameAttributes = false;
        Map<String, List<String>> attributes1 = service1.getAttributes();
        Map<String, List<String>> attributes2 = service2.getAttributes();
        if (attributes1 != null && attributes2 != null) {
            for (List<String> val : attributes1.values()) {
                Collections.sort(val);
            }
            for (List<String> val : attributes2.values()) {
                Collections.sort(val);
            }
            isSameAttributes = attributes1.equals(attributes2);
        }
        return isSameAttributes;
    }

    private boolean isSameResourceCount(Service service1, Service service2) {
        boolean isSameResourceCount = false;
        if (service1.getResourceCount() == null && service2.getResourceCount() == null) {
            isSameResourceCount = true;
        } else if (service1.getResourceCount() != null && service2.getResourceCount() != null) {
            isSameResourceCount = service1.getResourceCount().equals(service2.getResourceCount());
        }
        return isSameResourceCount;
    }

    public static String createDuplicateErrorMessage(List<Integer> duplicateServices) {
        StringBuilder errorMessageBuilder = new StringBuilder("ServiceMap contains duplicate services. services with Ids ");
        int index = 0;
        for (Integer serviceId : duplicateServices) {
            if (index > 0) {
                if (index < duplicateServices.size() - 1) {
                    errorMessageBuilder.append(" , ");
                } else if (index == duplicateServices.size() - 1) {
                    errorMessageBuilder.append(" and ");
                }
            }
            errorMessageBuilder.append(serviceId);
            ++index;
        }
        errorMessageBuilder.append(" are duplicates");
        return errorMessageBuilder.toString();
    }
}

