/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Service {
    @ApiModelProperty(value="List of service attributes used to match against", required=true, notes="min = 1, max = 10")
    @NotNull(message="The attribute list cannot be null")
    private Map<String, List<String>> attributes;
    @ApiModelProperty(value="The priority of this Service request", required=true, notes="any valid value from 1-10, 1 meaning a high priority 10 meaning a low priority")
    @Min(value=1L, message="The minimum value for priority is {value}")
    @Max(value=10L, message="The maximum value for priority is {value}")
    private Integer priority;
    @ApiModelProperty(value="For a SINGLE_RESOURCE request rank must be null or a value between 1 - 2^31-1", required=true)
    private Integer rank;
    @ApiModelProperty(value="An Integer representing the number of resources returned by this Service request", required=true, notes="If a SINGLE_RESOURCE request type then resourceCount must equal 1. If a MULTI_RESOURCE request type then the total for all resourceCount(s) must not exceed the max permitted 10.")
    @Min(value=1L, message="The minimum value for resourceCount is {value}")
    private Integer resourceCount;
    @ApiModelProperty(value="Agents who have a proficiency equal or greater than this for the required service will be preferred. Default is 16")
    private Integer minProficiency;
    @ApiModelProperty(value="Agents who have a proficiency equal or less than this for the required service will be preferred. Default is 1")
    private Integer maxProficiency;

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getResourceCount() {
        return this.resourceCount;
    }

    public void setResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getMinProficiency() {
        return this.minProficiency;
    }

    public void setMinProficiency(Integer minProficiency) {
        this.minProficiency = minProficiency;
    }

    public Integer getMaxProficiency() {
        return this.maxProficiency;
    }

    public void setMaxProficiency(Integer maxProficiency) {
        this.maxProficiency = maxProficiency;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static final class ValuesBuilder {
        private final Builder builder;
        private String category;

        private ValuesBuilder(Builder builder) {
            this.builder = builder;
        }

        void setCategory(String category) {
            this.category = category;
        }

        public Builder withValues(String ... values) {
            List<String> vals = this.builder.service.getAttributes().get(this.category);
            vals.addAll(Arrays.asList(values));
            this.builder.service.getAttributes().put(this.category, vals);
            return this.builder;
        }
    }

    public static class Builder {
        private final ValuesBuilder vBuilder = new ValuesBuilder(this);
        private final Service service = new Service();

        public Builder priority(Integer priority) {
            this.service.setPriority(priority);
            return this;
        }

        public Builder rank(Integer rank) {
            this.service.setRank(rank);
            return this;
        }

        public Builder resourceCount(Integer resourceCount) {
            this.service.setResourceCount(resourceCount);
            return this;
        }

        public Builder minProficiency(Integer minProficiency) {
            this.service.setMinProficiency(minProficiency);
            return this;
        }

        public Builder maxProficiency(Integer maxProficiency) {
            this.service.setMaxProficiency(maxProficiency);
            return this;
        }

        public ValuesBuilder addAttributeCategory(String category) {
            List<String> vals;
            Map<String, List<String>> atts = this.service.getAttributes();
            if (atts == null) {
                atts = new HashMap<String, List<String>>();
            }
            if ((vals = atts.get(category)) == null) {
                vals = new ArrayList<String>();
            }
            atts.put(category, vals);
            this.service.setAttributes(atts);
            this.vBuilder.setCategory(category);
            return this.vBuilder;
        }

        public Service build() {
            return this.service;
        }
    }
}

