/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.DataUtility;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import org.json.JSONObject;

public class UpdateContextWithSchema
extends Debugging
implements IPluggableExecutable {
    private String contextStoreIpVar;
    private String contextStoreIpField;
    private boolean csIpIsConstant;
    private String contextIdVar;
    private String contextIdField;
    private String scVar;
    private String scField;
    private String groupIdVar;
    private String groupIdField;
    private boolean groupIdIsConstant;
    private String topicVar;
    private String topicField;
    private boolean topicIsConstant;
    private String journeyElementVar;
    private String journeyElementField;
    private boolean journeyElementIsConstant;
    private static final String OP = "Update Context with Schema";

    public UpdateContextWithSchema(String contextStoreIpVar, String contextStoreIpField, boolean csIpIsConstant, String contextIdVar, String contextIdField, String scVar, String scField, String groupIdVar, String groupIdField, boolean groupIdIsConstant, String topicVar, String topicField, boolean topicIsConstant, String journeyElementVar, String journeyElementField, boolean journeyElementIsConstant) {
        this.contextStoreIpVar = contextStoreIpVar;
        this.contextStoreIpField = contextStoreIpField;
        this.csIpIsConstant = csIpIsConstant;
        this.contextIdVar = contextIdVar;
        this.contextIdField = contextIdField;
        this.scVar = scVar;
        this.scField = scField;
        this.groupIdVar = groupIdVar;
        this.groupIdField = groupIdField;
        this.groupIdIsConstant = groupIdIsConstant;
        this.topicVar = topicVar;
        this.topicField = topicField;
        this.topicIsConstant = topicIsConstant;
        this.journeyElementVar = journeyElementVar;
        this.journeyElementField = journeyElementField;
        this.journeyElementIsConstant = journeyElementIsConstant;
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Update Context with Schema ->" + this.scVar + ":" + this.scField;
    }

    public void execute(IRuntimeSession rtSession) {
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        Exception ex = null;
        try {
            OperationsHelper.setFieldsToNull(this.scField);
            OperationsHelper.setFieldsToNull(this.groupIdField);
            OperationsHelper.setFieldsToNull(this.topicField);
            OperationsHelper.setFieldsToNull(this.contextStoreIpField);
            IVariableField data = mySession.getVariableField(new VariableName(this.scVar, this.scField));
            JSONObject dataJSON = new JSONObject(data.getStringValue());
            String groupId = Utils.getValueFromParameter(this.groupIdVar, this.groupIdField, this.groupIdIsConstant, mySession);
            String topic = Utils.getValueFromParameter(this.topicVar, this.topicField, this.topicIsConstant, mySession);
            String contextStoreIp = Utils.getValueFromParameter(this.contextStoreIpVar, this.contextStoreIpField, this.csIpIsConstant, mySession);
            String journeyElement = Utils.getValueFromParameter(this.journeyElementVar, this.journeyElementField, this.journeyElementIsConstant, mySession);
            OceanaServices oceanaservices = new OceanaServices();
            oceanaservices.setMapToNullIfEmpty(dataJSON);
            String dataEmptyObjectToNull = dataJSON.toString();
            String contextId = mySession.getVariableField(new VariableName(this.contextIdVar, this.contextIdField)).getStringValue();
            OperationsHelper.traceContextId(mySession, contextId);
            IOceanaServices oas = OperationsHelper.getOceanaServices(mySession, dataEmptyObjectToNull, OP);
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(2, "Context Store cluster IP/FQDN: " + contextStoreIp + ", ContextId: " + contextId + ", JSON Data: " + DataUtility.maskSensitiveDataJsonString(dataEmptyObjectToNull, tr) + ", Group Id: " + groupId + ", Topic: " + topic + ", Journey Element: " + journeyElement);
            }
            oas.updateContextWithSchema(contextId, dataEmptyObjectToNull, groupId, topic, contextStoreIp, journeyElement, mySession);
            OperationsHelper.traceOperationSuccess(mySession, OP, contextId);
            return;
        }
        catch (OceanaServicesException e) {
            resultMessage = resultMessage + "Fail Update Context with Schema : " + e;
            ex = e;
        }
        catch (Exception e) {
            resultMessage = resultMessage + "Could not Update Context with Schema : " + e;
            ex = e;
        }
        mySession.throwRTException(resultMessage, ex);
    }
}

