package connectivity.ws.operations;

import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;

import flow.IProjectVariables;
import flow.constants.SSAConstants;
import flow.utils.Utils;

/**
 * This class is generated automatically.  Manual edits must be outside of the tagged
 * areas (for example, "START:CLASS:..." and "END:CLASS:...").  Changes within the
 * tag areas will be overwritten when the web service operation is regenerated.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class CreateWork extends com.avaya.sce.runtime.connectivity.restws.CallService {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

    /**
    * Constructor for CreateWork.
    */
    public CreateWork( com.avaya.sce.runtimecommon.IRuntimeSession mySession ) {
		//{{START:CLASS:CONSTRUCTOR
        super(mySession);

        //Web Service
        setServiceName("CreateWork");
		setHttpMethod("POST");
		setOutputFormat("JSON");
		setUseQuery("false");
		setUseJavaObject("false");
		setUseBody("true");
        setTimeoutSecondsFromParameter("ServiceMetrics_1466688012381TimeoutSeconds");
        setEndpointFromParameter("ServiceMetrics_1466688012381EndpointUrl");
        setAuthenticationFromParameter("ServiceMetrics_1466688012381Authentication");
        setPasswordFromParameter("ServiceMetrics_1466688012381Password");
        setUsernameFromParameter("ServiceMetrics_1466688012381Username");
        setPreemptiveFromParameter("ServiceMetrics_1466688012381Preemptive");
        setSecurityFromParameter("ServiceMetrics_1466688012381Security");
        setPortFromParameter("ServiceMetrics_1466688012381Port");

        //Operation
        setOperation(new javax.xml.namespace.QName("", "ServiceMetrics_OP"));

        //Input parameters

        //Output parameters
        {
            com.avaya.sce.runtime.connectivity.restws.WsParam param1 = new com.avaya.sce.runtime.connectivity.restws.WsParam(new javax.xml.namespace.QName("(ALL)"));
            param1.setWrapped(false);
            param1.setParamType(0);
            param1.setDDVariableName("CreateContactResponse");
            addOutParameter(param1);
        }
		setMessageBody("SlNPTg0KX3tDcmVhdGVDb250YWN0fV8NCg==");
        //}}END:CLASS:CONSTRUCTOR








		//NNB! This section must be placed *outside* the //}}***:CLASS:CONSTRUCTOR section
		//Retrieve the UCM Cluster IP, and set it in the REST URL
		String ucmClusterIP = null;
		String ucmInitContactURL = null;
		String contextAndWorkRequestID = null;
		String contactID = null;
		String appName = null;
		String providerName = null;
		
		IVariable var = mySession.getVariable(IProjectVariables.SELECTED_DATA_CENTER);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			ucmClusterIP = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_UCMCLUSTER_IP).getStringValue();
		}
		var = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			ucmInitContactURL = cx.getField(IProjectVariables.PROPERTIES_FIELD_UCMCREATE_CONTACT_URL).getStringValue();
		}	
		var = mySession.getVariable(IProjectVariables.CONTEXT);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			contextAndWorkRequestID = cx.getField(IProjectVariables.CONTEXT_FIELD_CONTEXT_ID).getStringValue();
		}
		var = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			contactID = cx.getField(IProjectVariables.PROPERTIES_FIELD_CALL_ID).getStringValue();
		}
	
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			contactID = cx.getField(IProjectVariables.PROPERTIES_FIELD_CALL_ID).getStringValue();
		}		

		var = mySession.getVariable(IProjectVariables.___VPAPPNAME);
		appName = var.getSimpleVariable().getStringValue();						
		providerName = String.format("%s-%s", SSAConstants.EP_PROVIDER, appName);
		
		String initEndpoint = String.format(ucmInitContactURL, ucmClusterIP, providerName, contextAndWorkRequestID, contactID);
		Utils.logInfo("Setting Init Contact Endpoint: " + initEndpoint, (SCESession) mySession);	
		
		setEndPoint(initEndpoint);

    }

}

