package connectivity.ws.operations;

import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;

import flow.IProjectVariables;
import flow.constants.SSAConstants;
import flow.utils.Utils;

/**
 * This class is generated automatically.  Manual edits must be outside of the tagged
 * areas (for example, "START:CLASS:..." and "END:CLASS:...").  Changes within the
 * tag areas will be overwritten when the web service operation is regenerated.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class CompleteWork extends com.avaya.sce.runtime.connectivity.restws.CallService {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

    /**
    * Constructor for CompleteWork.
    */
    public CompleteWork( com.avaya.sce.runtimecommon.IRuntimeSession mySession ) {
		//{{START:CLASS:CONSTRUCTOR
        super(mySession);

        //Web Service
        setServiceName("CompleteWork");
		setHttpMethod("POST");
		setOutputFormat("JSON");
		setUseQuery("true");
		setUseJavaObject("false");
		setUseBody("true");
        setTimeoutSecondsFromParameter("CreateWork_1467022854453TimeoutSeconds");
        setEndpointFromParameter("CreateWork_1467022854453EndpointUrl");
        setAuthenticationFromParameter("CreateWork_1467022854453Authentication");
        setPasswordFromParameter("CreateWork_1467022854453Password");
        setUsernameFromParameter("CreateWork_1467022854453Username");
        setPreemptiveFromParameter("CreateWork_1467022854453Preemptive");
        setSecurityFromParameter("CreateWork_1467022854453Security");
        setPortFromParameter("CreateWork_1467022854453Port");

        //Operation
        setOperation(new javax.xml.namespace.QName("", "ServiceMetrics_OP"));

        //Input parameters

        //Output parameters
        {
            com.avaya.sce.runtime.connectivity.restws.WsParam param1 = new com.avaya.sce.runtime.connectivity.restws.WsParam(new javax.xml.namespace.QName("(ALL)"));
            param1.setWrapped(false);
            param1.setParamType(0);
            param1.setDDVariableName("CompleteContactResponse");
            addOutParameter(param1);
        }
		setMessageBody("SlNPTg0KX3tDb21wbGV0ZUNvbnRhY3R9Xw0K");
        //}}END:CLASS:CONSTRUCTOR








		//NNB! This section must be placed *outside* the //}}***:CLASS:CONSTRUCTOR section
		//Retrieve the UCM Cluster IP, and set it in the REST URL
		String ucmClusterIP = null;
		String ucmCreateContactURL = null;
		String contextAndWorkRequestID = null;
		String contactID = null;
		String appName = null;
		String providerName = null;		
		
		IVariable var = mySession.getVariable(IProjectVariables.SELECTED_DATA_CENTER);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			ucmClusterIP = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_UCMCLUSTER_IP).getStringValue();
		}
		var = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			ucmCreateContactURL = cx.getField(IProjectVariables.PROPERTIES_FIELD_UCMCOMPLETE_CONTACT_URL).getStringValue();
		}	
		var = mySession.getVariable(IProjectVariables.CONTEXT);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			contextAndWorkRequestID = cx.getField(IProjectVariables.CONTEXT_FIELD_CONTEXT_ID).getStringValue();
		}
		var = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			contactID = cx.getField(IProjectVariables.PROPERTIES_FIELD_CALL_ID).getStringValue();
		}
		
		var = mySession.getVariable(IProjectVariables.___VPAPPNAME);
		appName = var.getSimpleVariable().getStringValue();						
		providerName = String.format("%s-%s", SSAConstants.EP_PROVIDER, appName);
		
		String completeEndpoint = String.format(ucmCreateContactURL, ucmClusterIP, providerName, contextAndWorkRequestID, contactID);
		Utils.logInfo("Setting Complete Contact Endpoint: " + completeEndpoint, (SCESession) mySession);	
		
		setEndPoint(completeEndpoint);	

    }

}

