package connectivity.ws.operations;

import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;

import flow.IProjectVariables;
import flow.utils.Utils;

/**
 * This class is generated automatically.  Manual edits must be outside of the tagged
 * areas (for example, "START:CLASS:..." and "END:CLASS:...").  Changes within the
 * tag areas will be overwritten when the web service operation is regenerated.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class ServiceMetrics extends com.avaya.sce.runtime.connectivity.restws.CallService {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

    /**
    * Constructor for ServiceMetrics.
    */
    public ServiceMetrics( com.avaya.sce.runtimecommon.IRuntimeSession mySession ) {
		//{{START:CLASS:CONSTRUCTOR
        super(mySession);

        //Web Service
        setServiceName("ServiceMetrics");
		setHttpMethod("POST");
		setOutputFormat("JSON");
		setUseQuery("true");
		setUseJavaObject("false");
		setUseBody("true");
        setTimeoutSecondsFromParameter("ServiceMetrics_1456498011733TimeoutSeconds");
        setEndpointFromParameter("ServiceMetrics_1456498011733EndpointUrl");
        setAuthenticationFromParameter("ServiceMetrics_1456498011733Authentication");
        setPasswordFromParameter("ServiceMetrics_1456498011733Password");
        setUsernameFromParameter("ServiceMetrics_1456498011733Username");
        setPreemptiveFromParameter("ServiceMetrics_1456498011733Preemptive");
        setSecurityFromParameter("ServiceMetrics_1456498011733Security");
        setPortFromParameter("ServiceMetrics_1456498011733Port");

        //Operation
        setOperation(new javax.xml.namespace.QName("", "ServiceMetrics_OP"));

        //Input parameters

        //Output parameters
        {
            com.avaya.sce.runtime.connectivity.restws.WsParam param1 = new com.avaya.sce.runtime.connectivity.restws.WsParam(new javax.xml.namespace.QName("(ALL)"));
            param1.setWrapped(false);
            param1.setParamType(0);
            param1.setDDVariableName("ServiceMetricsResponse");
            addOutParameter(param1);
        }
		setMessageBody("SlNPTg0KX3tTZXJ2aWNlTWV0cmljc31fDQo=");
        //}}END:CLASS:CONSTRUCTOR








		//NNB! This section must be placed *outside* the //}}***:CLASS:CONSTRUCTOR section
		//Retrieve the WA Cluster IP, and set it in the REST URL
		String waClusterIP = null;
		String waMetricsURL = null;
		
		IVariable var = mySession.getVariable(IProjectVariables.SELECTED_DATA_CENTER);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			waClusterIP = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_WACLUSTER_IP).getStringValue();
		}
		IVariable var2 = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var2.isComplexVariable() == true ) {
			IComplexVariable cx2 = var2.getComplexVariable();
			waMetricsURL = cx2.getField(IProjectVariables.PROPERTIES_FIELD_WAMETRICS_URL).getStringValue();
		}		
		String metricsEndpoint = String.format(waMetricsURL, waClusterIP);
		Utils.logInfo("Setting Service Metrics Endpoint: " + metricsEndpoint, (SCESession) mySession);	
		
		setEndPoint(metricsEndpoint);

    }

}

