package flow;

import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;

import flow.utils.Utils;

/**
 * The Data class handles many types of server-side operations including data
 * collection (from a data sources such as a database, or web service), variable
 * assignments and operations (like copying variable values, performing mathematic
 * operations, and collection iteration), conditional evaluation to control callflow
 * execution based on variable values, and logging/tracing statements.
 * 
 * Items created in the getDataActions() method are executed/evaluated in order
 * and if a condional branch condition evaluates to "true" then the branch is
 * activated and the execution of data actions is halted.  If no "true" conditions
 * are encountered, then all data actions will be executed/evaluated and the 
 * application will proceed to the "Default" servlet.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class ValidateDataCentre extends com.avaya.sce.runtime.Data {

	//{{START:CLASS:FIELDS
	private static final String SIP_REGEX = "sips?:(.+)@(.+)";	
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public ValidateDataCentre() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * Returns the Next item which will forward application execution
	 * to the next form in the call flow.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public com.avaya.sce.runtime.Next getNext(com.avaya.sce.runtimecommon.SCESession mySession) {
		com.avaya.sce.runtime.Next next = new com.avaya.sce.runtime.Next("BypassCheck", "Default");
		next.setDebugId(542);
		return next;
	}
	/**
	 * Create a list of local variables used by items in the data node.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection<VariableInfo> getLocalVariables(){
		java.util.Collection<VariableInfo> variables = new java.util.ArrayList<VariableInfo>();

		return variables;
	}
	/**
	 * Creates and conditionally executes operations that have been configured
	 * in the Callflow.  This method will build a collection of operations and
	 * have the framework execute the operations by calling evaluateActions().
	 * If the evaluation causes the framework to forward to a different servlet
	 * then execution stops.
	 * Returning true from this method means that the framework has forwarded the
	 * request to a different servlet.  Returning false means that the default
	 * Next will be invoked.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public boolean executeDataActions(com.avaya.sce.runtimecommon.SCESession mySession) throws Exception {
		java.util.Collection actions = null;

		actions = new java.util.ArrayList(1);
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition1", "Validation:ddnIsValid", com.avaya.sce.runtime.Expression.STRING_NOT_EQUAL, "true", false).setDebugId(537)).evaluate(mySession)) {
			actions = new java.util.ArrayList(4);
			actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Default DN is not a valid SIP URI", "").setDebugId(538));
			actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_END_TRANS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Default DN is not a valid SIP URI", "").setDebugId(539));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:InvalidDN", false).setDebugId(566));
			actions.add(new com.avaya.sce.runtime.Next("DefaultError", "Invalid DN").setDebugId(541));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;

		}


		if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition2", "Validation:cdnIsValid", com.avaya.sce.runtime.Expression.STRING_NOT_EQUAL, "true", false).setDebugId(530)).evaluate(mySession)) {
			actions = new java.util.ArrayList(4);
			actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "CDN is not a valid SIP URI", "").setDebugId(532));
			actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "CDN is not a valid SIP URI", "").setDebugId(531));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:InvalidCDN", false).setDebugId(567));
			actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Invalid CDN").setDebugId(540));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;

		}

		// return false if the evaluation of actions did not cause a servlet forward or redirect
		return false;
	}
	
	@Override
	public void requestBegin(SCESession mySession)	{
		IVariable var = mySession.getVariable(IProjectVariables.SELECTED_DATA_CENTER);
		if (var.isComplexVariable() == true) {
			IComplexVariable cx = var.getComplexVariable();

			String cdn = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_CDN)
					.getStringValue();
			if (cdn.matches(SIP_REGEX)) {
				Utils.logInfo("CDN is a valid SIP URI", mySession);
				Utils.setVariableField(IProjectVariables.VALIDATION, IProjectVariables.VALIDATION_FIELD_CDN_IS_VALID, "true", mySession);
			} 
					
			String defaultDN = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_DEFAULT_DN)
					.getStringValue();
			if (defaultDN.matches(SIP_REGEX)) {
				Utils.logInfo("Default DN is a valid SIP URI", mySession);
				Utils.setVariableField(IProjectVariables.VALIDATION, IProjectVariables.VALIDATION_FIELD_DDN_IS_VALID, "true", mySession);
			} 
		}		
		
		
	}

}
