package english.grammars;

import com.avaya.sce.runtimecommon.SCESession;

import flow.IProjectVariables;
import flow.utils.Utils;

/**
 * This class is generated automatically.
 * Only exit this class for Dynamic External grammars and override the method String getURL().
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class CustomerDigit extends com.avaya.sce.runtime.Grammar {

    //{{START:CLASS:FIELDS
    //}}END:CLASS:FIELDS

    /**
    * Constructor for DigitGrammar.
    */
    public CustomerDigit() {
		//{{START:CLASS:CONSTRUCTOR
        super();
        setRootLanguage("en-us");
        setMode("dtmf");
        setBuiltin(true);
        setBuiltinMode("dtmf");
        setType("digits");
        setOptions("minlength=1;maxlength=6");
		//}}END:CLASS:CONSTRUCTOR
    }

	/* (non-Javadoc)
	 * @see com.avaya.sce.runtime.Grammar#updateGrammar(com.avaya.sce.runtimecommon.SCESession)
	 * Default the number of digits collected in the constructor to 6, and if a different value is specified in configuration, use that instead
	 */
	@Override
	public void updateGrammar(SCESession mySession) {

		String maxDigits = null;
		
		maxDigits = (String)Utils.getVariableField(IProjectVariables.PROPERTIES, IProjectVariables.PROPERTIES_FIELD_ACCOUNT_LENGTH, mySession);		
		
		if (!Utils.isStringBlank(maxDigits) && Utils.isNumber(maxDigits)) {
			try {
				int i = Integer.parseInt(maxDigits);
				if (i > 16) {
					maxDigits = "16";
					Utils.logInfo("Configured Digit length (" + maxDigits + ") too large; capping at 16", (SCESession) mySession);					
				} else if (i < 1) {
					maxDigits = "1";
					Utils.logInfo("Configured Digit length (" + maxDigits + ") too small; capping at 1", (SCESession) mySession);						
				}
				Utils.logInfo("Setting Account number length: " + maxDigits, (SCESession) mySession);			
		        setOptions("minlength=1;maxlength=" + maxDigits);								
			} catch (NumberFormatException nfe) {
				Utils.logError("Configured Digit length is not a number; defaulting to 6", (SCESession) mySession);
			}			
		}
		
		super.updateGrammar(mySession);
	}    
}

