package flow;

/**
 * This interface is used to define the name of variables that are 
 * declared in the call flow.  All variables are defined as 
 * <code>public static final String</code>, which allows user-defined
 * code to reference variable names by the Java variable name.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public interface IProjectVariables {





	//{{START:PROJECT:VARIABLES
	/**
	 * This is a reserved block of variable name definitions.
	 * The variable names defined here can be used as the key
	 * to get the <code>com.avaya.sce.runtime.Variable</code>
	 * from the <code>SCESession</code> at runtime.<br>
	 * 
	 * For example, given a variable name <code>phoneNum</code>,
	 * user-defined code should access the variable in this format:<PRE>
	 *   Variable phNum = mySession.getVariable(IProjectVariables.PHONE_NUM);
	 *   if ( phNum != null ) {
	 *        // do something with the variable
	 *   }</PRE>
	 * 
	 * This block of code is generated automatically by Orchestration Designer and should not
	 * be manually edited as changes may be overwritten by future code generation.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public static final String METRICS_RESPONSE_SERVICE_1 = "MetricsResponseService1";
	public static final String XFER_TO_ASSISTED_BRIDGED = "XferToAssistedBridged";
	public static final String CUSTOMER = "Customer";
	public static final String TRAFFIC_BYPASS = "TrafficBypass";
	public static final String SERVICE_METRICS_RESPONSE = "ServiceMetricsResponse";
	public static final String OUTPUT = "output";
	public static final String GET_UCARESOURCES_RESPONSE = "GetUCAResourcesResponse";
	public static final String XFER_TO_ASSISTED_BLIND = "XferToAssistedBlind";
	public static final String FIRST_MENU_SELECTION = "FirstMenuSelection";
	public static final String COMPLETE_CONTACT_RESPONSE = "CompleteContactResponse";
	public static final String GET_CUSTOMER_RESPONSE = "GetCustomerResponse";
	public static final String XFER_TO_ASSISTED_CONSULT = "XferToAssistedConsult";
	public static final String REDIRECTINFO = "redirectinfo";
	public static final String DEFAULT_ERROR_TRANSFER = "DefaultErrorTransfer";
	public static final String COLLECT_CUSTOMER_ID = "CollectCustomerID";
	public static final String CREATE_CONTACT = "CreateContact";
	public static final String CONTEXT = "Context";
	public static final String ___VPAPPNAME = "__VPappname";
	public static final String SELECT_FIRST_MENU = "SelectFirstMenu";
	public static final String ACTIVE_DATA_CENTER = "ActiveDataCenter";
	public static final String SELECTED_DATA_CENTER = "SelectedDataCenter";
	public static final String DATE = "date";
	public static final String ATTRIBUTES = "Attributes";
	public static final String RESULT = "Result";
	public static final String DATA_CENTER_1 = "DataCenter1";
	public static final String DATA_CENTER_2 = "DataCenter2";
	public static final String SECOND_MENU_SELECTION = "SecondMenuSelection";
	public static final String MENU_CATEGORIES = "MenuCategories";
	public static final String VALIDATION = "Validation";
	public static final String PROMPTS = "Prompts";
	public static final String USER_TO_USER = "UserToUser";
	public static final String SELECT_SECOND_MENU = "SelectSecondMenu";
	public static final String AVAYA_OCEANA_USE_SECURE_CONNECTION = "avayaOceanaUseSecureConnection";
	public static final String REQUEST_TYPE = "RequestType";
	public static final String SESSION = "session";
	public static final String PROPERTIES = "Properties";
	public static final String Q_2MULTIPLE_SERVICES = "Q2MultipleServices";
	public static final String ADHOC_CALL = "AdhocCall";
	public static final String COMPLETE_CONTACT = "CompleteContact";
	public static final String SERVICE_METRICS = "ServiceMetrics";
	public static final String SELECT_SPECIFIED_RESOURCE = "SelectSpecifiedResource";
	public static final String EWT = "EWT";
	public static final String CREATE_CONTACT_RESPONSE = "CreateContactResponse";
	public static final String DD_LAST_EXCEPTION = "ddLastException";
	public static final String SAMPLE_CATEGORY = "SampleCategory";
	public static final String CONTEXT_STORE_INPUT = "ContextStoreInput";
	public static final String TIME = "time";
	public static final String SHAREDUUI = "shareduui";
	//}}END:PROJECT:VARIABLES
	//{{START:PROJECT:VARIABLEFIELDS
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_COMPLETED_WORK_COUNT = "CompletedWorkCount";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_EWT = "EWT";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_OLDEST_WORK_WAITING = "OldestWorkWaiting";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_PROCESSING_WORK_COUNT = "ProcessingWorkCount";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_RESOURCE_BUSY_COUNT = "ResourceBusyCount";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_RESOURCE_READY_COUNT = "ResourceReadyCount";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_RESOURCE_STAFFED_COUNT = "ResourceStaffedCount";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_ROLLING_ASA = "RollingASA";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_SERVICE_OCCUPANCY = "ServiceOccupancy";
	public static final String METRICS_RESPONSE_SERVICE_1_FIELD_WAITING_WORK_COUNT = "WaitingWorkCount";
	public static final String XFER_TO_ASSISTED_BRIDGED_FIELD_DURATION = "duration";
	public static final String XFER_TO_ASSISTED_BRIDGED_FIELD_INPUTMODE = "inputmode";
	public static final String XFER_TO_ASSISTED_BRIDGED_FIELD_UTTERANCE = "utterance";
	public static final String XFER_TO_ASSISTED_BRIDGED_FIELD_VALUE = "value";
	public static final String CUSTOMER_FIELD_ACCOUNT_ID = "AccountId";
	public static final String CUSTOMER_FIELD_ACCOUNT_TYPE = "AccountType";
	public static final String CUSTOMER_FIELD_EMAIL = "Email";
	public static final String CUSTOMER_FIELD_EXTERNAL_ID = "ExternalID";
	public static final String CUSTOMER_FIELD_HANDLE = "Handle";
	public static final String CUSTOMER_FIELD_PHONE = "Phone";
	public static final String CUSTOMER_FIELD_PLATFORM = "Platform";
	public static final String TRAFFIC_BYPASS_FIELD_CUSTOMER_ID = "CustomerId";
	public static final String TRAFFIC_BYPASS_FIELD_FIRST_MENU_SELECTION = "FirstMenuSelection";
	public static final String TRAFFIC_BYPASS_FIELD_SECOND_MENU_SELECTION = "SecondMenuSelection";
	public static final String TRAFFIC_BYPASS_FIELD_TRAFFIC_PROFILE_AENABLED = "TrafficProfileAEnabled";
	public static final String TRAFFIC_BYPASS_FIELD_TRAFFIC_PROFILE_BENABLED = "TrafficProfileBEnabled";
	public static final String TRAFFIC_BYPASS_FIELD_USE_CRM = "UseCRM";
	public static final String OUTPUT_FIELD_DATA = "data";
	public static final String OUTPUT_FIELD_MESSAGE = "message";
	public static final String OUTPUT_FIELD_STATUS = "status";
	public static final String FIRST_MENU_SELECTION_FIELD_INDEX = "index";
	public static final String FIRST_MENU_SELECTION_FIELD_SIZE = "size";
	public static final String REDIRECTINFO_FIELD_PRESENTATIONINFO = "presentationinfo";
	public static final String REDIRECTINFO_FIELD_REASON = "reason";
	public static final String REDIRECTINFO_FIELD_SCREENINGINFO = "screeninginfo";
	public static final String REDIRECTINFO_FIELD_URI = "uri";
	public static final String COLLECT_CUSTOMER_ID_FIELD_CONFIDENCE = "confidence";
	public static final String COLLECT_CUSTOMER_ID_FIELD_INPUTMODE = "inputmode";
	public static final String COLLECT_CUSTOMER_ID_FIELD_INTERPRETATION = "interpretation";
	public static final String COLLECT_CUSTOMER_ID_FIELD_NOINPUTCOUNT = "noinputcount";
	public static final String COLLECT_CUSTOMER_ID_FIELD_NOMATCHCOUNT = "nomatchcount";
	public static final String COLLECT_CUSTOMER_ID_FIELD_UTTERANCE = "utterance";
	public static final String COLLECT_CUSTOMER_ID_FIELD_VALUE = "value";
	public static final String CONTEXT_FIELD_CONTEXT_ID = "ContextId";
	public static final String CONTEXT_FIELD_SERVICE_MAP = "ServiceMap";
	public static final String SELECT_FIRST_MENU_FIELD_CONFIDENCE = "confidence";
	public static final String SELECT_FIRST_MENU_FIELD_INPUTMODE = "inputmode";
	public static final String SELECT_FIRST_MENU_FIELD_INTERPRETATION = "interpretation";
	public static final String SELECT_FIRST_MENU_FIELD_NOINPUTCOUNT = "noinputcount";
	public static final String SELECT_FIRST_MENU_FIELD_NOMATCHCOUNT = "nomatchcount";
	public static final String SELECT_FIRST_MENU_FIELD_UTTERANCE = "utterance";
	public static final String SELECT_FIRST_MENU_FIELD_VALUE = "value";
	public static final String SELECTED_DATA_CENTER_FIELD_CDN = "CDN";
	public static final String SELECTED_DATA_CENTER_FIELD_CMCLUSTER_IP = "CMClusterIP";
	public static final String SELECTED_DATA_CENTER_FIELD_CSCLUSTER_IP = "CSClusterIP";
	public static final String SELECTED_DATA_CENTER_FIELD_DEFAULT_DN = "DefaultDN";
	public static final String SELECTED_DATA_CENTER_FIELD_NAME = "Name";
	public static final String SELECTED_DATA_CENTER_FIELD_UCMCLUSTER_IP = "UCMClusterIP";
	public static final String SELECTED_DATA_CENTER_FIELD_WACLUSTER_IP = "WAClusterIP";
	public static final String DATE_FIELD_AUDIO = "audio";
	public static final String DATE_FIELD_DAYOFMONTH = "dayofmonth";
	public static final String DATE_FIELD_DAYOFWEEK = "dayofweek";
	public static final String DATE_FIELD_DAYOFWEEKNUM = "dayofweeknum";
	public static final String DATE_FIELD_DAYOFYEAR = "dayofyear";
	public static final String DATE_FIELD_MONTH = "month";
	public static final String DATE_FIELD_MONTHINYEAR = "monthinyear";
	public static final String DATE_FIELD_YEAR = "year";
	public static final String DATA_CENTER_1_FIELD_CDN = "CDN";
	public static final String DATA_CENTER_1_FIELD_CMCLUSTER_IP = "CMClusterIP";
	public static final String DATA_CENTER_1_FIELD_CSCLUSTER_IP = "CSClusterIP";
	public static final String DATA_CENTER_1_FIELD_DEFAULT_DN = "DefaultDN";
	public static final String DATA_CENTER_1_FIELD_NAME = "Name";
	public static final String DATA_CENTER_1_FIELD_UCMCLUSTER_IP = "UCMClusterIP";
	public static final String DATA_CENTER_1_FIELD_WACLUSTER_IP = "WAClusterIP";
	public static final String DATA_CENTER_2_FIELD_CDN = "CDN";
	public static final String DATA_CENTER_2_FIELD_CMCLUSTER_IP = "CMClusterIP";
	public static final String DATA_CENTER_2_FIELD_CSCLUSTER_IP = "CSClusterIP";
	public static final String DATA_CENTER_2_FIELD_DEFAULT_DN = "DefaultDN";
	public static final String DATA_CENTER_2_FIELD_NAME = "Name";
	public static final String DATA_CENTER_2_FIELD_UCMCLUSTER_IP = "UCMClusterIP";
	public static final String DATA_CENTER_2_FIELD_WACLUSTER_IP = "WAClusterIP";
	public static final String SECOND_MENU_SELECTION_FIELD_INDEX = "index";
	public static final String SECOND_MENU_SELECTION_FIELD_SIZE = "size";
	public static final String MENU_CATEGORIES_FIELD_MENU_1CATEGORY = "Menu1Category";
	public static final String MENU_CATEGORIES_FIELD_MENU_1SELECTION = "Menu1Selection";
	public static final String MENU_CATEGORIES_FIELD_MENU_2CATEGORY = "Menu2Category";
	public static final String MENU_CATEGORIES_FIELD_MENU_2SELECTION = "Menu2Selection";
	public static final String VALIDATION_FIELD_CDN_IS_VALID = "cdnIsValid";
	public static final String VALIDATION_FIELD_DDN_IS_VALID = "ddnIsValid";
	public static final String PROMPTS_FIELD_ANNOUNCE_ERROR = "AnnounceError";
	public static final String PROMPTS_FIELD_ASK_CUSTOMER_ID = "AskCustomerID";
	public static final String PROMPTS_FIELD_ASK_MENU_1 = "AskMenu1";
	public static final String PROMPTS_FIELD_ASK_MENU_2 = "AskMenu2";
	public static final String PROMPTS_FIELD_ASK_MENU_3 = "AskMenu3";
	public static final String PROMPTS_FIELD_CONTACT_FAILED = "ContactFailed";
	public static final String PROMPTS_FIELD_CONTEXT_FAILED = "ContextFailed";
	public static final String PROMPTS_FIELD_ERROR_MESSAGE = "ErrorMessage";
	public static final String PROMPTS_FIELD_ERROR_TRANSFER = "ErrorTransfer";
	public static final String PROMPTS_FIELD_GET_CUST_FAILED = "GetCustFailed";
	public static final String PROMPTS_FIELD_INVALID_CDN = "InvalidCDN";
	public static final String PROMPTS_FIELD_INVALID_CUSTOMER_ID = "InvalidCustomerID";
	public static final String PROMPTS_FIELD_INVALID_DN = "InvalidDN";
	public static final String PROMPTS_FIELD_METRICS_FAILED = "MetricsFailed";
	public static final String PROMPTS_FIELD_SELECT_MENU_1 = "SelectMenu1";
	public static final String PROMPTS_FIELD_SELECT_MENU_2 = "SelectMenu2";
	public static final String PROMPTS_FIELD_SELECT_MENU_3 = "SelectMenu3";
	public static final String PROMPTS_FIELD_TRANSFER = "Transfer";
	public static final String PROMPTS_FIELD_UN_STAFFED = "UnStaffed";
	public static final String PROMPTS_FIELD_WAIT_TO_BE_TRANSFERRED = "WaitToBeTransferred";
	public static final String PROMPTS_FIELD_WELCOME = "Welcome";
	public static final String USER_TO_USER_FIELD_ENCODED = "Encoded";
	public static final String USER_TO_USER_FIELD_PREFIX = "Prefix";
	public static final String USER_TO_USER_FIELD_RAW = "Raw";
	public static final String SELECT_SECOND_MENU_FIELD_CONFIDENCE = "confidence";
	public static final String SELECT_SECOND_MENU_FIELD_INPUTMODE = "inputmode";
	public static final String SELECT_SECOND_MENU_FIELD_INTERPRETATION = "interpretation";
	public static final String SELECT_SECOND_MENU_FIELD_NOINPUTCOUNT = "noinputcount";
	public static final String SELECT_SECOND_MENU_FIELD_NOMATCHCOUNT = "nomatchcount";
	public static final String SELECT_SECOND_MENU_FIELD_UTTERANCE = "utterance";
	public static final String SELECT_SECOND_MENU_FIELD_VALUE = "value";
	public static final String REQUEST_TYPE_FIELD_PREFERRED_RESOURCE = "PreferredResource";
	public static final String REQUEST_TYPE_FIELD_REQUIRED_RESOURCE = "RequiredResource";
	public static final String REQUEST_TYPE_FIELD_SERVICE_MATCH = "ServiceMatch";
	public static final String SESSION_FIELD_AAI = "aai";
	public static final String SESSION_FIELD_ANI = "ani";
	public static final String SESSION_FIELD_CALLTAG = "calltag";
	public static final String SESSION_FIELD_CHANNEL = "channel";
	public static final String SESSION_FIELD_CONVERSEFIRST = "conversefirst";
	public static final String SESSION_FIELD_CONVERSESECOND = "conversesecond";
	public static final String SESSION_FIELD_CURRENTLANGUAGE = "currentlanguage";
	public static final String SESSION_FIELD_DNIS = "dnis";
	public static final String SESSION_FIELD_EXIT_CUSTOMER_ID = "exitCustomerId";
	public static final String SESSION_FIELD_EXIT_INFO_1 = "exitInfo1";
	public static final String SESSION_FIELD_EXIT_INFO_2 = "exitInfo2";
	public static final String SESSION_FIELD_EXIT_PARENT_ID = "exitParentId";
	public static final String SESSION_FIELD_EXIT_PREFERRED_PATH = "exitPreferredPath";
	public static final String SESSION_FIELD_EXIT_REASON = "exitReason";
	public static final String SESSION_FIELD_EXIT_TOPIC = "exitTopic";
	public static final String SESSION_FIELD_LASTERROR = "lasterror";
	public static final String SESSION_FIELD_MEDIATYPE = "mediatype";
	public static final String SESSION_FIELD_MESSAGE_TYPE = "messageType";
	public static final String SESSION_FIELD_PROTOCOLNAME = "protocolname";
	public static final String SESSION_FIELD_PROTOCOLVERSION = "protocolversion";
	public static final String SESSION_FIELD_SESSIONID = "sessionid";
	public static final String SESSION_FIELD_SESSIONLABEL = "sessionlabel";
	public static final String SESSION_FIELD_SHAREDMODE = "sharedmode";
	public static final String SESSION_FIELD_UCID = "ucid";
	public static final String SESSION_FIELD_UUI = "uui";
	public static final String SESSION_FIELD_VIDEOBITRATE = "videobitrate";
	public static final String SESSION_FIELD_VIDEOCODEC = "videocodec";
	public static final String SESSION_FIELD_VIDEOENABLED = "videoenabled";
	public static final String SESSION_FIELD_VIDEOFARFMTP = "videofarfmtp";
	public static final String SESSION_FIELD_VIDEOFORMAT = "videoformat";
	public static final String SESSION_FIELD_VIDEOFPS = "videofps";
	public static final String SESSION_FIELD_VIDEOHEIGHT = "videoheight";
	public static final String SESSION_FIELD_VIDEONEARFMTP = "videonearfmtp";
	public static final String SESSION_FIELD_VIDEOWIDTH = "videowidth";
	public static final String SESSION_FIELD_VPCALLEDEXTENSION = "vpcalledextension";
	public static final String SESSION_FIELD_VPCONVERSEONDATA = "vpconverseondata";
	public static final String SESSION_FIELD_VPCOVERAGEREASON = "vpcoveragereason";
	public static final String SESSION_FIELD_VPCOVERAGETYPE = "vpcoveragetype";
	public static final String SESSION_FIELD_VPRDNIS = "vprdnis";
	public static final String SESSION_FIELD_VPREPORTURL = "vpreporturl";
	public static final String PROPERTIES_FIELD_ACCOUNT_LENGTH = "AccountLength";
	public static final String PROPERTIES_FIELD_ACCOUNT_TYPE = "AccountType";
	public static final String PROPERTIES_FIELD_CALLER_TYPE = "CallerType";
	public static final String PROPERTIES_FIELD_CALL_ID = "CallID";
	public static final String PROPERTIES_FIELD_CONFIGURED_SPECIFIED_RESOURCE = "ConfiguredSpecifiedResource";
	public static final String PROPERTIES_FIELD_CRMIDENTIFIER = "CRMIdentifier";
	public static final String PROPERTIES_FIELD_LOCALE = "Locale";
	public static final String PROPERTIES_FIELD_MAX_PROFICIENCY = "MaxProficiency";
	public static final String PROPERTIES_FIELD_MIN_PROFICIENCY = "MinProficiency";
	public static final String PROPERTIES_FIELD_PRIORITY = "Priority";
	public static final String PROPERTIES_FIELD_PRIORITY_CUSTOMER = "PriorityCustomer";
	public static final String PROPERTIES_FIELD_RANK = "Rank";
	public static final String PROPERTIES_FIELD_SPECIFIED_RESOURCE = "SpecifiedResource";
	public static final String PROPERTIES_FIELD_STRATEGY = "Strategy";
	public static final String PROPERTIES_FIELD_TOPIC = "Topic";
	public static final String PROPERTIES_FIELD_UCAGET_RESOURCE_LIST_URL = "UCAGetResourceListURL";
	public static final String PROPERTIES_FIELD_UCMCOMPLETE_CONTACT_URL = "UCMCompleteContactURL";
	public static final String PROPERTIES_FIELD_UCMCREATE_CONTACT_URL = "UCMCreateContactURL";
	public static final String PROPERTIES_FIELD_USE_CUSTOMER_API = "UseCustomerAPI";
	public static final String PROPERTIES_FIELD_WAMETRICS_URL = "WAMetricsURL";
	public static final String PROPERTIES_FIELD_XFER_TYPE = "XferType";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_CONFIDENCE = "confidence";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_INPUTMODE = "inputmode";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_INTERPRETATION = "interpretation";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_NOINPUTCOUNT = "noinputcount";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_NOMATCHCOUNT = "nomatchcount";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_UTTERANCE = "utterance";
	public static final String SELECT_SPECIFIED_RESOURCE_FIELD_VALUE = "value";
	public static final String EWT_FIELD_EWTLIMIT = "EWTLimit";
	public static final String EWT_FIELD_EWTROUNDED = "EWTRounded";
	public static final String DD_LAST_EXCEPTION_FIELD_ERRORCODE = "errorcode";
	public static final String DD_LAST_EXCEPTION_FIELD_MESSAGE = "message";
	public static final String DD_LAST_EXCEPTION_FIELD_OBJECT = "object";
	public static final String DD_LAST_EXCEPTION_FIELD_STACKTRACE = "stacktrace";
	public static final String DD_LAST_EXCEPTION_FIELD_TYPE = "type";
	public static final String CONTEXT_STORE_INPUT_FIELD_CLUSTER_IP = "clusterIP";
	public static final String CONTEXT_STORE_INPUT_FIELD_DATA = "data";
	public static final String CONTEXT_STORE_INPUT_FIELD_ID = "id";
	public static final String CONTEXT_STORE_INPUT_FIELD_KEY = "key";
	public static final String CONTEXT_STORE_INPUT_FIELD_TOUCHPOINT = "touchpoint";
	public static final String TIME_FIELD_AUDIO = "audio";
	public static final String TIME_FIELD_HOUR = "hour";
	public static final String TIME_FIELD_MILLISECOND = "millisecond";
	public static final String TIME_FIELD_MINUTE = "minute";
	public static final String TIME_FIELD_SECOND = "second";
	public static final String TIME_FIELD_TIMEZONE = "timezone";
	public static final String SHAREDUUI_FIELD_ID = "id";
	public static final String SHAREDUUI_FIELD_VALUE = "value";
	//}}END:PROJECT:VARIABLEFIELDS
	public static final String contextId = "contextId";
}
