package flow.pojo;

import java.util.ArrayList;
import java.util.List;

public class Attribute {

	private final String category;
	private List<AttributeValue> values = new ArrayList<AttributeValue>();
	private int selectedIndex = -1;
	
	public Attribute(String category, List<AttributeValue> values) {
		super();
		this.category = category;
		this.values = values;
	}
	
	public List<AttributeValue> getValues() {
		return values;
	}
	
	public void setValues(List<AttributeValue> values) {
		this.values = values;
	}
	
	public String getCategory() {
		return category;
	}
	
	public int getSelectedIndex() {
		return selectedIndex;
	}
	
	public void setSelectedIndex(int selectedIndex) {
		this.selectedIndex = selectedIndex;
	}
	
	public String toWAString() {
		String result = "";
		if(selectedIndex >= 0){
			result = category + ":" + values.get(selectedIndex).getKey() + ";";
		}
		return result;
	}
	
	public String getSelectedValueKey() {
		String result = "";
		if(selectedIndex >= 0){
			result = values.get(selectedIndex).getKey();
		}
		return result;
	}
	
	public void setSelectedIndexByName(String attrName){
		selectedIndex = -1;
		int i = 0;
		for(AttributeValue attrValue: this.getValues()){
			if(attrValue.getKey().equals(attrName)){
				selectedIndex = i;
				break;
			}
			i++;
		}
	}	
}
