package flow;

import com.avaya.sce.runtimecommon.IVariable;

import flow.constants.SSAConstants;
import flow.utils.Utils;

/**
 * A basic servlet which allows a user to define their code, generate
 * any output, and to select where to transition to next.
 * Last generated by Orchestration Designer at: 2016-JUN-22  03:11:35 PM
 */
public class ProcessContext extends com.avaya.sce.runtime.BasicServlet {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: 2016-JUN-22  03:11:35 PM
	 */
	public ProcessContext() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * This method allows for custom integration with other Java components.
	 * You may use Java for sophisticated logic or to integrate with custom
	 * connectors (i.e. JMS, custom web services, sockets, XML, JAXB, etc.)
	 *
	 * Any custom code added here should work as efficiently as possible to prevent delays.
	 * It's important to design your callflow so that the voice browser (Voice Portal/IR)
	 * is not waiting too long for a response as this can lead to a poor caller experience.
	 * Additionally, if the response to the client voice browser exceeds the configured
	 * timeout, the platform may throw an "error.badfetch". 
	 *
	 * Using this method, you have access to all session variables through the 
	 * SCESession object.
	 *
	 * The code generator will *** NOT *** overwrite this method in the future.
	 * Last generated by Orchestration Designer at: 2016-JUN-22  03:11:35 PM
	 */
	public void servletImplementation(com.avaya.sce.runtimecommon.SCESession mySession) {
		IVariable outvariable = mySession.getVariable(IProjectVariables.OUTPUT);		

		Utils.logInfo("OUTPUT VALUE --------> " + outvariable.getComplexVariable().getField(IProjectVariables.OUTPUT_FIELD_DATA).getStringValue(), mySession);
				
		String uuiContext = "";
		
    	//Check whether this is a transferred call or if CS has auto-generated a context id 
    	String contextId = (String)Utils.getVariableField(IProjectVariables.CONTEXT, IProjectVariables.CONTEXT_FIELD_CONTEXT_ID, mySession);
    	if (Utils.isStringBlank(contextId)) {
    		// Store the auto-generated contextId for use in other nodes
    		contextId = outvariable.getComplexVariable().getField(IProjectVariables.OUTPUT_FIELD_DATA).getStringValue();		
    		Utils.logInfo("Auto-generated contextId returned by CS ==> " + contextId, mySession);		
    		Utils.setVariableField(IProjectVariables.CONTEXT, IProjectVariables.CONTEXT_FIELD_CONTEXT_ID, contextId, mySession);	
		
			uuiContext = String.format(SSAConstants.UUI_FORMAT, contextId, SSAConstants.UUI_CHANNEL_VOICE, SSAConstants.UUI_NEW_CONTACT);
    	} 
    	else {
    		uuiContext = String.format(SSAConstants.UUI_FORMAT, contextId, SSAConstants.UUI_CHANNEL_VOICE, SSAConstants.UUI_TRANSFER);    		
    	}
    	
		Utils.logInfo("Data for injection into UUI ==> " + uuiContext, mySession);
		mySession.getVariable(IProjectVariables.USER_TO_USER).getComplexVariable().getField(IProjectVariables.USER_TO_USER_FIELD_RAW).setValue(uuiContext);
		
       
	}
	/**
	 * Builds the list of branches that are defined for this servlet object.
	 * This list is built automatically by defining Goto nodes in the call flow editor.
	 * It is the programmer's responsibilty to provide at least one enabled Goto.<BR>
	 *
	 * The user should override updateBranches() to determine which Goto that the
	 * framework will activate.  If there is not at least one enabled Goto item, 
	 * the framework will throw a runtime exception.<BR>
	 *
	 * This method is generated automatically and changes to it may
	 * be overwritten next time code is generated.  To modify the list
	 * of branches for the flow item, override:
	 *     <code>updateBranches(Collection branches, SCESession mySession)</code>
	 *
	 * @return a Collection of <code>com.avaya.sce.runtime.Goto</code>
	 * objects that will be evaluated at runtime.  If there are no gotos
	 * defined in the Servlet node, then this returns null.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection getBranches(com.avaya.sce.runtimecommon.SCESession mySession) {
		java.util.List list = null;
		com.avaya.sce.runtime.Goto aGoto = null;
		list = new java.util.ArrayList(1);

		aGoto = new com.avaya.sce.runtime.Goto("PrepareXfer", 0, true, "Default");
		list.add(aGoto);

		return list;
	}
}
