package flow;

import flow.IProjectVariables;
import flow.constants.SSAConstants;
import flow.utils.Utils;
/**
 * A basic servlet which allows a user to define their code, generate
 * any output, and to select where to transition to next.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class SetCallerType extends com.avaya.sce.runtime.BasicServlet {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public SetCallerType() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * This method allows for custom integration with other Java components.
	 * You may use Java for sophisticated logic or to integrate with custom
	 * connectors (i.e. JMS, custom web services, sockets, XML, JAXB, etc.)
	 *
	 * Any custom code added here should work as efficiently as possible to prevent delays.
	 * It's important to design your callflow so that the voice browser (Experienve Portal/IR)
	 * is not waiting too long for a response as this can lead to a poor caller experience.
	 * Additionally, if the response to the client voice browser exceeds the configured
	 * timeout, the platform may throw an "error.badfetch". 
	 *
	 * Using this method, you have access to all session variables through the 
	 * SCESession object.
	 *
	 * The code generator will *** NOT *** overwrite this method in the future.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public void servletImplementation(com.avaya.sce.runtimecommon.SCESession mySession) {
		String resourceList = (String)Utils.getVariableField(IProjectVariables.GET_UCARESOURCES_RESPONSE, mySession);
		Utils.logInfo("List = " + resourceList + ";", mySession);
		String caller = (String)Utils.getVariableField(IProjectVariables.SESSION, IProjectVariables.SESSION_FIELD_ANI, mySession);
		Utils.logInfo("caller = "+ caller, mySession);
		Utils.setVariableField(IProjectVariables.ADHOC_CALL, "false", mySession);
		
		Boolean repeat;
        do {
            repeat = false;
            if (!resourceList.isEmpty() & resourceList.contains(caller)) {
                resourceList.indexOf(caller);
                int i = resourceList.indexOf(caller);
                String callerResource = resourceList.substring(i, resourceList.indexOf('}',i));

                if (callerResource.contains("Voice")) {
                	Utils.setVariableField(IProjectVariables.ADHOC_CALL, "true", mySession);
                } else {
                    repeat = true;
                    resourceList = resourceList.substring(i + callerResource.length());
                }
            }
        } while (repeat);
        Utils.logInfo("Caller extension = " + caller + "; Adhoc call = " + (String)Utils.getVariableField(IProjectVariables.ADHOC_CALL, mySession), mySession);
	}
	/**
	 * Builds the list of branches that are defined for this servlet object.
	 * This list is built automatically by defining Goto nodes in the call flow editor.
	 * It is the programmer's responsibilty to provide at least one enabled Goto.<BR>
	 *
	 * The user should override updateBranches() to determine which Goto that the
	 * framework will activate.  If there is not at least one enabled Goto item, 
	 * the framework will throw a runtime exception.<BR>
	 *
	 * This method is generated automatically and changes to it may
	 * be overwritten next time code is generated.  To modify the list
	 * of branches for the flow item, override:
	 *     <code>updateBranches(Collection branches, SCESession mySession)</code>
	 *
	 * @return a Collection of <code>com.avaya.sce.runtime.Goto</code>
	 * objects that will be evaluated at runtime.  If there are no gotos
	 * defined in the Servlet node, then this returns null.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection getBranches(com.avaya.sce.runtimecommon.SCESession mySession) {
		java.util.List list = null;
		com.avaya.sce.runtime.Goto aGoto = null;
		list = new java.util.ArrayList(1);

		aGoto = new com.avaya.sce.runtime.Goto("CallerTypeCheck", 0, true, "Next");
		list.add(aGoto);

		return list;
	}
}
