package flow;

/**
 * The Data class handles many types of server-side operations including data
 * collection (from a data sources such as a database, or web service), variable
 * assignments and operations (like copying variable values, performing mathematic
 * operations, and collection iteration), conditional evaluation to control callflow
 * execution based on variable values, and logging/tracing statements.
 * 
 * Items created in the getDataActions() method are executed/evaluated in order
 * and if a condional branch condition evaluates to "true" then the branch is
 * activated and the execution of data actions is halted.  If no "true" conditions
 * are encountered, then all data actions will be executed/evaluated and the 
 * application will proceed to the "Default" servlet.
 * Last generated by Orchestration Designer at: 2015-FEB-27  10:34:32 AM
 */
public class SetDataCentre extends com.avaya.sce.runtime.Data {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: 2015-FEB-27  10:34:32 AM
	 */
	public SetDataCentre() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * Returns the Next item which will forward application execution
	 * to the next form in the call flow.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public com.avaya.sce.runtime.Next getNext(com.avaya.sce.runtimecommon.SCESession mySession) {
		com.avaya.sce.runtime.Next next = new com.avaya.sce.runtime.Next("ValidateDataCentre", "Default");
		next.setDebugId(330);
		return next;
	}
	/**
	 * Create a list of local variables used by items in the data node.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection<VariableInfo> getLocalVariables(){
		java.util.Collection<VariableInfo> variables = new java.util.ArrayList<VariableInfo>();

		return variables;
	}
	/**
	 * Creates and conditionally executes operations that have been configured
	 * in the Callflow.  This method will build a collection of operations and
	 * have the framework execute the operations by calling evaluateActions().
	 * If the evaluation causes the framework to forward to a different servlet
	 * then execution stops.
	 * Returning true from this method means that the framework has forwarded the
	 * request to a different servlet.  Returning false means that the default
	 * Next will be invoked.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public boolean executeDataActions(com.avaya.sce.runtimecommon.SCESession mySession) throws Exception {
		java.util.Collection actions = null;

		actions = new java.util.ArrayList(1);
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition1", "ActiveDataCenter", com.avaya.sce.runtime.Expression.STRING_EQUAL, "DataCenter1", false).setDebugId(334)).evaluate(mySession)) {
			actions = new java.util.ArrayList(8);
			actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_DEBUG, "", "ActiveDataCenter").setDebugId(376));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CDN", "DataCenter1:CDN", false).setDebugId(335));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CSClusterIP", "DataCenter1:CSClusterIP", false).setDebugId(336));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:WAClusterIP", "DataCenter1:WAClusterIP", false).setDebugId(337));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CMClusterIP", "DataCenter1:CMClusterIP", false).setDebugId(972));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:UCMClusterIP", "DataCenter1:UCMClusterIP", false).setDebugId(885));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:DefaultDN", "DataCenter1:DefaultDN", false).setDebugId(339));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:Name", "DataCenter1:Name", false).setDebugId(340));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;

		} else if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition2", "ActiveDataCenter", com.avaya.sce.runtime.Expression.STRING_EQUAL, "DataCenter2", false).setDebugId(364)).evaluate(mySession)) {
			actions = new java.util.ArrayList(8);
			actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_DEBUG, "", "ActiveDataCenter").setDebugId(377));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CDN", "DataCenter2:CDN", false).setDebugId(365));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CSClusterIP", "DataCenter2:CSClusterIP", false).setDebugId(366));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:WAClusterIP", "DataCenter2:WAClusterIP", false).setDebugId(367));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:CMClusterIP", "DataCenter2:CMClusterIP", false).setDebugId(973));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:UCMClusterIP", "DataCenter2:UCMClusterIP", false).setDebugId(886));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:DefaultDN", "DataCenter2:DefaultDN", false).setDebugId(369));
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("SelectedDataCenter:Name", "DataCenter2:Name", false).setDebugId(370));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;

		} else {
			actions = new java.util.ArrayList(1);
			actions.add(new com.avaya.sce.runtime.tracking.ReportAlarmInfo(com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Active Data Centre selection not recognised", "ActiveDataCenter", true).setDebugId(372));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;
		}


		actions = new java.util.ArrayList(1);
		actions.add(new com.avaya.sce.runtime.varoperations.Assign("ContextStoreInput:clusterIP", "SelectedDataCenter:CSClusterIP", false).setDebugId(843));
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		// return false if the evaluation of actions did not cause a servlet forward or redirect
		return false;
	}
}
