package connectivity.ws.operations;

import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;

import flow.IProjectVariables;
import flow.utils.Utils;

/**
 * This class is generated automatically.  Manual edits must be outside of the tagged
 * areas (for example, "START:CLASS:..." and "END:CLASS:...").  Changes within the
 * tag areas will be overwritten when the web service operation is regenerated.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class GetUCAResourcesList extends com.avaya.sce.runtime.connectivity.restws.CallService {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

    /**
    * Constructor for GetUCAResourcesList.
    */
    public GetUCAResourcesList( com.avaya.sce.runtimecommon.IRuntimeSession mySession ) {
		//{{START:CLASS:CONSTRUCTOR
        super(mySession);

        //Web Service
        setServiceName("GetUCAResourcesList");
		setHttpMethod("GET");
		setOutputFormat("String");
		setUseQuery("true");
		setUseJavaObject("true");
		setUseBody("false");
        setTimeoutSecondsFromParameter("GetUCAResourcesList_1664298876214TimeoutSeconds");
        setEndpointFromParameter("GetUCAResourcesList_1664298876214EndpointUrl");
        setAuthenticationFromParameter("GetUCAResourcesList_1664298876214Authentication");
        setPasswordFromParameter("GetUCAResourcesList_1664298876214Password");
        setUsernameFromParameter("GetUCAResourcesList_1664298876214Username");
        setPreemptiveFromParameter("GetUCAResourcesList_1664298876214Preemptive");
        setSecurityFromParameter("GetUCAResourcesList_1664298876214Security");
        setPortFromParameter("GetUCAResourcesList_1664298876214Port");

        //Operation
        setOperation(new javax.xml.namespace.QName("", "GetUCAResourcesList_OP"));

        //Input parameters

        //Output parameters
        {
            com.avaya.sce.runtime.connectivity.restws.WsParam param1 = new com.avaya.sce.runtime.connectivity.restws.WsParam(new javax.xml.namespace.QName("(ALL)"));
            param1.setWrapped(false);
            param1.setParamType(0);
            param1.setDDVariableName("GetUCAResourcesResponse");
            addOutParameter(param1);
        }
		setMessageBody("");
        //}}END:CLASS:CONSTRUCTOR











		//NNB! This section must be placed *outside* the //}}***:CLASS:CONSTRUCTOR section
		//Retrieve the UCA/UCM Cluster IP, and set it in the REST URL
		String UCAClusterIP = null;
		String UCAResourcesURL = null;
		
		IVariable var = mySession.getVariable(IProjectVariables.SELECTED_DATA_CENTER);
		if (var.isComplexVariable() == true ) {
			IComplexVariable cx = var.getComplexVariable();
			UCAClusterIP = cx.getField(IProjectVariables.SELECTED_DATA_CENTER_FIELD_WACLUSTER_IP).getStringValue();
		}
		IVariable var2 = mySession.getVariable(IProjectVariables.PROPERTIES);
		if (var2.isComplexVariable() == true ) {
			IComplexVariable cx2 = var2.getComplexVariable();
			UCAResourcesURL = cx2.getField(IProjectVariables.PROPERTIES_FIELD_UCAGET_RESOURCE_LIST_URL).getStringValue();
		}		
		String resourcesEndpoint = String.format(UCAResourcesURL, UCAClusterIP);
		Utils.logInfo("Setting UCA resources Endpoint: " + resourcesEndpoint, (SCESession) mySession);	
		
		setEndPoint(resourcesEndpoint);
    }

}

