package flow;

/**
 * The Data class handles many types of server-side operations including data
 * collection (from a data sources such as a database, or web service), variable
 * assignments and operations (like copying variable values, performing mathematic
 * operations, and collection iteration), conditional evaluation to control callflow
 * execution based on variable values, and logging/tracing statements.
 * 
 * Items created in the getDataActions() method are executed/evaluated in order
 * and if a condional branch condition evaluates to "true" then the branch is
 * activated and the execution of data actions is halted.  If no "true" conditions
 * are encountered, then all data actions will be executed/evaluated and the 
 * application will proceed to the "Default" servlet.
 * Last generated by Orchestration Designer at: (timestamp generation disabled)
 */
public class GetServiceMetrics extends com.avaya.sce.runtime.Data {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public GetServiceMetrics() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * Returns the Next item which will forward application execution
	 * to the next form in the call flow.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public com.avaya.sce.runtime.Next getNext(com.avaya.sce.runtimecommon.SCESession mySession) {
		com.avaya.sce.runtime.Next next = null;
		return next;
	}
	/**
	 * Create a list of local variables used by items in the data node.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection<VariableInfo> getLocalVariables(){
		java.util.Collection<VariableInfo> variables = new java.util.ArrayList<VariableInfo>();

		return variables;
	}
	/**
	 * Creates and conditionally executes operations that have been configured
	 * in the Callflow.  This method will build a collection of operations and
	 * have the framework execute the operations by calling evaluateActions().
	 * If the evaluation causes the framework to forward to a different servlet
	 * then execution stops.
	 * Returning true from this method means that the framework has forwarded the
	 * request to a different servlet.  Returning false means that the default
	 * Next will be invoked.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public boolean executeDataActions(com.avaya.sce.runtimecommon.SCESession mySession) throws Exception {
		java.util.Collection actions = null;

		actions = new java.util.ArrayList(1);
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition1", "SelectSpecifiedResource:value", com.avaya.sce.runtime.Expression.STRING_NOT_EQUAL, "RequestType:RequiredResource", true).setDebugId(832)).evaluate(mySession)) {
			com.avaya.sce.runtime.BooleanOperation bo1 = new com.avaya.sce.runtime.BooleanOperation(com.avaya.sce.runtime.BooleanOperation.OR);
			com.avaya.sce.runtime.Expression be1 = new com.avaya.sce.runtime.Expression("expression1", "ServiceMetricsResponse", com.avaya.sce.runtime.Expression.IS_EMPTY);
			bo1.addExpression(be1);
			com.avaya.sce.runtime.Expression be2 = new com.avaya.sce.runtime.Expression("expression2", "ServiceMetricsResponse", com.avaya.sce.runtime.Expression.IS_NULL);
			bo1.addExpression(be2);
			try {
				actions = new java.util.ArrayList(1);

				//{{START:CODEGEN:EXTENSIONPOINT:com.avaya.sce.restws.avResourceType
				actions.add(new connectivity.ws.operations.ServiceMetrics(mySession).setDebugId(213));
				//}}END:CODEGEN:EXTENSIONPOINT:com.avaya.sce.restws.avResourceType

				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			} catch (com.avaya.sce.runtimecommon.SCERuntimeException e1) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.varoperations.CaptureException(e1).setDebugId(-1));
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Service metrics request failed", "ddLastException:message").setDebugId(579));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Service metrics request failed: ServiceMetricsResponse is empty", "ddLastException:message").setDebugId(696));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:MetricsFailed", false).setDebugId(694));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Caught Error").setDebugId(580));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			}


			if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition").setDebugId(608)).evaluate(mySession, bo1)) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Service metrics request failed: ServiceMetricsResponse is empty", "").setDebugId(616));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Service metrics request failed: ServiceMetricsResponse is empty", "ddLastException:message").setDebugId(642));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:MetricsFailed", false).setDebugId(695));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "No Metrics Response").setDebugId(609));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;

			} else {
				actions = new java.util.ArrayList(3);
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_DEBUG, "Returned Metrics", "ServiceMetricsResponse").setDebugId(215));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_INFO, "Oceana SSA", "Returned Metrics", "ServiceMetricsResponse").setDebugId(613));
				actions.add(new com.avaya.sce.runtime.Next("ParseMetricsResponse", "RequestSucceeded").setDebugId(206));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			}


		} else {
			actions = new java.util.ArrayList(1);
			actions.add(new com.avaya.sce.runtime.Next("GetCustomer", "SkipMetricsRequest").setDebugId(834));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;
		}


		// return false if the evaluation of actions did not cause a servlet forward or redirect
		return false;
	}
}
