package flow;

/**
 * The Data class handles many types of server-side operations including data
 * collection (from a data sources such as a database, or web service), variable
 * assignments and operations (like copying variable values, performing mathematic
 * operations, and collection iteration), conditional evaluation to control callflow
 * execution based on variable values, and logging/tracing statements.
 * 
 * Items created in the getDataActions() method are executed/evaluated in order
 * and if a condional branch condition evaluates to "true" then the branch is
 * activated and the execution of data actions is halted.  If no "true" conditions
 * are encountered, then all data actions will be executed/evaluated and the 
 * application will proceed to the "Default" servlet.
 * Last generated by Orchestration Designer at: 2012-DEC-27  09:38:08 PM
 */
public class StoreContext extends com.avaya.sce.runtime.Data {

	//{{START:CLASS:FIELDS
	//}}END:CLASS:FIELDS

	/**
	 * Default constructor
	 * Last generated by Orchestration Designer at: 2012-DEC-27  09:38:08 PM
	 */
	public StoreContext() {
		//{{START:CLASS:CONSTRUCTOR
		super();
		//}}END:CLASS:CONSTRUCTOR
	}

	/**
	 * Returns the Next item which will forward application execution
	 * to the next form in the call flow.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public com.avaya.sce.runtime.Next getNext(com.avaya.sce.runtimecommon.SCESession mySession) {
		com.avaya.sce.runtime.Next next = new com.avaya.sce.runtime.Next("ProcessContext", "Success");
		next.setDebugId(39);
		return next;
	}
	/**
	 * Create a list of local variables used by items in the data node.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public java.util.Collection<VariableInfo> getLocalVariables(){
		java.util.Collection<VariableInfo> variables = new java.util.ArrayList<VariableInfo>();

		return variables;
	}
	/**
	 * Creates and conditionally executes operations that have been configured
	 * in the Callflow.  This method will build a collection of operations and
	 * have the framework execute the operations by calling evaluateActions().
	 * If the evaluation causes the framework to forward to a different servlet
	 * then execution stops.
	 * Returning true from this method means that the framework has forwarded the
	 * request to a different servlet.  Returning false means that the default
	 * Next will be invoked.
	 * 
	 * This method is generated automatically by the code generator
	 * and should not be manually edited.  Manual edits may be overwritten
	 * by the code generator.
	 * Last generated by Orchestration Designer at: (timestamp generation disabled)
	 */
	public boolean executeDataActions(com.avaya.sce.runtimecommon.SCESession mySession) throws Exception {
		java.util.Collection actions = null;

		actions = new java.util.ArrayList(2);
		actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_DEBUG, "Context for this Contact:", "ContextStoreInput:data").setDebugId(290));
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		if(((com.avaya.sce.runtime.Condition)new com.avaya.sce.runtime.Condition("condition1", "Context:ContextId", com.avaya.sce.runtime.Expression.IS_EMPTY).setDebugId(981)).evaluate(mySession)) {
			actions = new java.util.ArrayList(1);
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("ContextStoreInput:id", "", true).setDebugId(60));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;
			try {
				actions = new java.util.ArrayList(1);

				//{{START:CODEGEN:EXTENSIONPOINT:com.avaya.sce.pdc.oceanaservices.createcontextschema
				actions.add(new com.avaya.sce.pdc.oceanaservices.operations.CreateContextWithSchema("SelectedDataCenter", "CSClusterIP" , false, "ContextStoreInput", "data", "", "" , true, "", "" , true, "ContextStoreInput", "touchpoint" , false, "Properties", "Topic" , false, "output", "data").setDebugId(938));
				//}}END:CODEGEN:EXTENSIONPOINT:com.avaya.sce.pdc.oceanaservices.createcontextschema

				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			} catch (com.avaya.sce.runtimecommon.SCERuntimeException e1) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.varoperations.CaptureException(e1).setDebugId(-1));
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Context creation failed", "ddLastException:message").setDebugId(582));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Failed to write context", "ddLastException:message").setDebugId(693));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:ContextFailed", false).setDebugId(691));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Create Error").setDebugId(583));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			} catch (com.avaya.sce.pdc.oceanaservices.OceanaServicesException e2) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.varoperations.CaptureException(e2).setDebugId(-1));
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Context creation failed", "ddLastException:message").setDebugId(582));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Failed to write context", "ddLastException:message").setDebugId(693));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:ContextFailed", false).setDebugId(691));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Create Error").setDebugId(583));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			}

		} else {
			actions = new java.util.ArrayList(1);
			actions.add(new com.avaya.sce.runtime.varoperations.Assign("ContextStoreInput:id", "Context:ContextId", false).setDebugId(983));
			if(evaluateActions(actions, mySession)) {
				return true;
			}
			actions = null;
			try {
				actions = new java.util.ArrayList(1);

				//{{START:CODEGEN:EXTENSIONPOINT:com.avaya.sce.pdc.oceanaservices.updatecontextschema
				actions.add(new com.avaya.sce.pdc.oceanaservices.operations.UpdateContextWithSchema("SelectedDataCenter", "CSClusterIP" , false, "ContextStoreInput", "id", "ContextStoreInput", "data", "", "" , true, "", "" , true, "ContextStoreInput", "touchpoint" , false).setDebugId(985));
				//}}END:CODEGEN:EXTENSIONPOINT:com.avaya.sce.pdc.oceanaservices.updatecontextschema

				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			} catch (com.avaya.sce.runtimecommon.SCERuntimeException e3) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.varoperations.CaptureException(e3).setDebugId(-1));
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Context update failed", "ddLastException:message").setDebugId(987));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Failed to update context", "ddLastException:message").setDebugId(988));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:ContextFailed", false).setDebugId(989));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Update Error").setDebugId(990));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			} catch (com.avaya.sce.pdc.oceanaservices.OceanaServicesException e4) {
				actions = new java.util.ArrayList(5);
				actions.add(new com.avaya.sce.runtime.varoperations.CaptureException(e4).setDebugId(-1));
				actions.add(new com.avaya.sce.runtime.tracking.TraceInfo(com.avaya.sce.runtimecommon.ITraceInfo.TRACE_LEVEL_ERROR, "Context update failed", "ddLastException:message").setDebugId(987));
				actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_MAJOR, "Oceana SSA", "Failed to update context", "ddLastException:message").setDebugId(988));
				actions.add(new com.avaya.sce.runtime.varoperations.Assign("Prompts:ErrorMessage", "Prompts:ContextFailed", false).setDebugId(989));
				actions.add(new com.avaya.sce.runtime.Next("DefaultErrorTransfer", "Update Error").setDebugId(990));
				if(evaluateActions(actions, mySession)) {
					return true;
				}
				actions = null;
			}
		}


		actions = new java.util.ArrayList(1);
		actions.add(new com.avaya.sce.runtime.tracking.ReportInfo(com.avaya.sce.runtimecommon.IReportInfo.REPORT_TYPE_PROGRESS, com.avaya.sce.runtimecommon.IReportInfo.ALARM_LEVEL_INFO, "Oceana SSA", "Shared Work & Context ID", "output:data").setDebugId(917));
		if(evaluateActions(actions, mySession)) {
			return true;
		}
		actions = null;

		// return false if the evaluation of actions did not cause a servlet forward or redirect
		return false;
	}
}
