//
//  CollapsibleTableViewHeader.h
//  OceanaReferenceClient
//
//  Created by Mohan on 15/07/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class CollapsibleTableViewHeader;
@protocol CollapsibleTableViewHeaderDelegate <NSObject>

-(void) toggleSection: (CollapsibleTableViewHeader *) header : (NSInteger) section;


@end


@interface CollapsibleTableViewHeader : UIView

@property (nonatomic) UILabel *titleLabel;
@property (nonatomic) UIImageView *arrowLabel;
@property (nonatomic ,weak) id<CollapsibleTableViewHeaderDelegate> delegate;
@property (nonatomic) NSInteger section;
@property (nonatomic) BOOL isCollapsed;

-(void) setCollapsed : (BOOL) toCollapse;

@end

NS_ASSUME_NONNULL_END
