//
//  AppSettings.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//
//

#import <Foundation/Foundation.h>
#import "AppSettings.h"
#import "Logging.h"
#import "AppDelegate.h"


@implementation AppSettings

static NSUserDefaults *systemSettings;

NSString* const pref_all_saved_settigns = @"pref_all_saved_settigns";


NSString* const PREF_LOG_ENABLED = @"prefLoggingEnabled";
NSString* const PREF_LOG_LEVEL = @"prefLogLevel";
//NSString* const PREF_LOG_NAME = @"prefLogName";
//NSString* const PREF_LOG_FILE_SIZE = @"prefLogFileSize";
NSString* const PREF_NUM_LOGS = @"prefNumLogs";
//NSString* const PREF_USE_SECURE = @"prefUseSecure";
//NSString* const PREF_PORT = @"prefPort";
//NSString* const PREF_SERVER = @"Server";
//NSString* const PREF_USER = @"Username";
//NSString* const PREF_DISPLAY = @"DisplayName";
//NSString* const PREF_CUSTID = @"CustomerID";
//NSString* const PREF_DESTINATION = @"DestinationAddress";
//NSString* const PREF_AMC_REST_URL = @"prefAMCRestUrl";
//NSString* const PREF_TOPIC = @"Topic";
//
//NSString* const PREF_PRIORITY = @"priority";
//NSString* const PREF_LOCALE = @"locale";
//NSString* const PREF_STRATEGY = @"strategy";
//NSString* const PREF_SOURCE_NAME = @"sourceName";
//NSString* const PREF_RESOURCE_ID = @"resourceId";
//
//NSString* const PREF_NAME_ATTR_ONE = @"Name1";
//NSString* const PREF_VALUE_ATTR_ONE = @"Values1";
//NSString* const PREF_NAME_ATTR_TWO = @"Name2";
//NSString* const PREF_VALUE_ATTR_TWO = @"Values2";
//NSString* const PREF_NAME_ATTR_THREE = @"Name3";
//NSString* const PREF_VALUE_ATTR_THREE = @"Values3";
//
//NSString* const PREF_AAWG_SERVER = @"AAWGServer";
//NSString* const PREF_AAWG_PORT = @"prefAAWGPort";
//NSString* const PREF_AAWG_SECURE = @"prefAAWGSecure";
//NSString* const PREF_AAWG_REST_URL = @"prefAAWGRestUrl";
//
//NSString* const PREF_TOKEN_SERVICE = @"prefTokenService";
//NSString* const PREF_TOKEN_PORT = @"prefTokenServicePort";
//NSString* const PREF_TOKEN_SECURE = @"prefTokenServiceSecure";
//NSString* const PREF_TOKEN_SERVICE_URL = @"prefTokenServiceUrl";

//NSString* const DEFAULT_PORT = @"443";
//NSString* const DEFAULT_SERVER = @"pusntzd195.apac.avaya.com";
//NSString* const DEFAULT_USER = @"1234";
//NSString* const DEFAULT_DISPLAY = @"Oceana";
//NSString* const DEFAULT_CUSTID = @"Cust";
//NSString* const DEFAULT_DESTINATION = @"";
//NSString* const DEFAULT_AMC_REST_URL = @"services/AvayaMobileCommunications/sessions";
//NSString* const DEFAULT_TOPIC = @"";
//
//NSString* const DEFAULT_PRIORITY = @"5";
//NSString* const DEFAULT_LOCALE = @"en_us";
//NSString* const DEFAULT_STRATEGY = @"MOST_IDLE";
//NSString* const DEFAULT_SOURCE_NAME = @"";
//NSString* const DEFAULT_RESOURCE_ID = @"";
//
//NSString* const DEFAULT_NAME_ATTR_ONE = @"Language";
//NSString* const DEFAULT_VALUE_ATTR_ONE = @"English";
//NSString* const DEFAULT_NAME_ATTR_TWO = @"Location";
//NSString* const DEFAULT_VALUE_ATTR_TWO = @"Inhouse";
//NSString* const DEFAULT_NAME_ATTR_THREE = @"Service";
//NSString* const DEFAULT_VALUE_ATTR_THREE = @"Sales";
//
//NSString* const DEFAULT_AAWG_SERVER = @"pusntzd205.apac.avaya.com";
//NSString* const DEFAULT_AAWG_PORT = @"443";
//NSString* const DEFAULT_AAWG_REST_URL = @"csa/resources/tenants/default";
//
//NSString* const DEFAULT_TOKEN_SERVICE = @"pusntzd205.apac.avaya.com";
//NSString* const DEFAULT_TOKEN_PORT = @"443";
//NSString* const DEFAULT_TOKEN_SERVICE_URL = @"token-generation-service/token/getEncryptedToken";



/**********************************************
 Updated Preferences Keys for Updated UI
 ***********************************************/


NSString* const display_name_o = @"display_name_o";
NSString* const from_extention_o = @"from_extention_o";
NSString* const destination_o = @"destination_o";
NSString* const context_o = @"context_o";
NSString* const topic_o = @"topic_o";

NSString* const display_name_e = @"display_name_e";
NSString* const from_extention_e = @"from_extention_e";
NSString* const destination_e = @"destination_e";
NSString* const context_e = @"context_e";
NSString* const topic_e = @"topic_e";

NSString* const amc_cluster_address_o = @"amc_cluster_address";
NSString* const amc_cluster_port_o = @"amc_cluster_port";
NSString* const amc_use_https_o = @"amc_use_https";
NSString* const amc_service_path_o = @"amc_service_path";

NSString* const aawg_server_address_o = @"aawg_server_address_o";
NSString* const aawg_service_port_o = @"aawg_service_port_o";
NSString* const aawg_use_https_o = @"aawg_use_https_o";
NSString* const aawg_service_path_o = @"aawg_service_path_o";

NSString* const aawg_server_address_e = @"aawg_server_address_e";
NSString* const aawg_service_port_e = @"aawg_service_port_e";
NSString* const aawg_use_https_e = @"aawg_use_https_e";
NSString* const aawg_service_path_e = @"aawg_service_path_e";

NSString* const aawg_token_server_address_o = @"aawg_token_server_address_o";
NSString* const aawg_token_service_port_o = @"aawg_token_service_port_o";
NSString* const aawg_token_use_https_o = @"aawg_token_use_https_o";
NSString* const aawg_token_service_path_o = @"aawg_token_service_path_o";

NSString* const aawg_token_server_address_e = @"aawg_token_server_address_e";
NSString* const aawg_token_service_port_e = @"aawg_token_service_port_e";
NSString* const aawg_token_use_https_e = @"aawg_token_use_https_e";
NSString* const aawg_token_service_path_e = @"aawg_token_service_path_e";

NSString* const pref_key_priority = @"pref_key_priority";
NSString* const pref_key_locale = @"pref_key_locale";
NSString* const pref_key_strategy = @"pref_key_strategy";
NSString* const pref_key_attr_one = @"pref_key_attr_one";
NSString* const pref_key_value_one = @"pref_key_value_one";
NSString* const pref_key_attr_two = @"pref_key_attr_two";
NSString* const pref_key_value_two = @"pref_key_value_two";
NSString* const pref_key_attr_three = @"pref_key_attr_three";
NSString* const pref_key_value_three = @"pref_key_value_three";
NSString* const pref_key_source_name = @"pref_key_source_name";
NSString* const pref_key_resource_ID = @"pref_key_resource_ID";

NSString* const pref_key_log_file_name_e = @"pref_key_log_file_name_e";
NSString* const pref_key_log_file_name_o = @"pref_key_log_file_name_o";

NSString* const pref_key_log_file_size = @"pref_key_log_file_size";
NSString* const pref_key_log_backup_file_no = @"pref_key_log_backup_file_no";


// Default Values for the keys

/*
 
// For Debug And Test
 
NSString* const Ddisplay_name_o = @"Oceana Services";
NSString* const Dfrom_extention_o = @"1234";
NSString* const Ddestination_o = @"";
NSString* const Dcontext_o = @"CONTEXT OCEANA";
NSString* const Dtopic_o = @"";

NSString* const Ddisplay_name_e = @"Elite Services";
NSString* const Dfrom_extention_e = @"1234";
NSString* const Ddestination_e = @"450151";
NSString* const Dcontext_e = @"CONTEXT ELITE";
NSString* const Dtopic_e = @"";

NSString* const Damc_cluster_address = @"pusntzd195.apac.avaya.com";
NSString* const Damc_cluster_port = @"443";
NSString* const Damc_use_https = @"YES";
NSString* const Damc_service_path = @"services/AvayaMobileCommunications/sessions";

NSString* const Daawg_server_address = @"pusntzd205.apac.avaya.com";
NSString* const Daawg_service_port = @"443";
NSString* const Daawg_use_https = @"YES";
NSString* const Daawg_service_path = @"csa/resources/tenants/default";

NSString* const Daawg_token_server_address = @"pusntzd205.apac.avaya.com";
NSString* const Daawg_token_service_port = @"443";
NSString* const Daawg_token_use_https = @"YES";
NSString* const Daawg_token_service_path = @"token-generation-service/token/getEncryptedToken";

NSString* const Dpref_key_priority = @"5";
NSString* const Dpref_key_locale = @"en_us";
NSString* const Dpref_key_strategy = @"MOST_IDLE";
NSString* const Dpref_key_attr_one = @"Language";
NSString* const Dpref_key_value_one = @"English";
NSString* const Dpref_key_attr_two = @"Location";
NSString* const Dpref_key_value_two = @"Mohan";
NSString* const Dpref_key_attr_three = @"Service";
NSString* const Dpref_key_value_three = @"Sales";
NSString* const Dpref_key_source_name = @"";
NSString* const Dpref_key_resource_ID = @"";
NSString* const Dpref_key_log_file_name = @"Oceana™ReferenceClient.log";
NSString* const Dpref_key_log_file_size = @"512";
NSString* const Dpref_key_log_backup_file_no = @"5";


NSString* const Ddisplay_name_o = @"Oceana Services";
NSString* const Dfrom_extention_o = @"1234";
NSString* const Ddestination_o = @"";
NSString* const Dcontext_o = @"CONTEXT OCEANA";
NSString* const Dtopic_o = @"";

NSString* const Ddisplay_name_e = @"Elite Services";
NSString* const Dfrom_extention_e = @"1234";
NSString* const Ddestination_e = @"450151";
NSString* const Dcontext_e = @"CONTEXT ELITE";
NSString* const Dtopic_e = @"";

*/

NSString* const Ddisplay_name_o = @"";
NSString* const Dfrom_extention_o = @"";
NSString* const Ddestination_o = @"";
NSString* const Dcontext_o = @"Cust";
NSString* const Dtopic_o = @"";

NSString* const Ddisplay_name_e = @"";
NSString* const Dfrom_extention_e = @"";
NSString* const Ddestination_e = @"";
NSString* const Dcontext_e = @"";
NSString* const Dtopic_e = @"";

NSString* const Damc_cluster_address_o = @"";
NSString* const Damc_cluster_port_o = @"";
NSString* const Damc_use_https_o = @"YES";
NSString* const Damc_service_path_o = @"services/AvayaMobileCommunications/sessions";

NSString* const Daawg_server_address_e = @"";
NSString* const Daawg_service_port_e = @"";
NSString* const Daawg_use_https_e = @"YES";
NSString* const Daawg_service_path_e = @"csa/resources/tenants/default";

NSString* const Daawg_server_address_o = @"";
NSString* const Daawg_service_port_o = @"";
NSString* const Daawg_use_https_o = @"YES";
NSString* const Daawg_service_path_o = @"csa/resources/tenants/default";


NSString* const Daawg_token_server_address_e = @"";
NSString* const Daawg_token_service_port_e = @"";
NSString* const Daawg_token_use_https_e = @"YES";
NSString* const Daawg_token_service_path_e = @"token-generation-service/token/getEncryptedToken";


NSString* const Daawg_token_server_address_o = @"";
NSString* const Daawg_token_service_port_o = @"";
NSString* const Daawg_token_use_https_o = @"YES";
NSString* const Daawg_token_service_path_o = @"token-generation-service/token/getEncryptedToken";


NSString* const Dpref_key_priority = @"";
NSString* const Dpref_key_locale = @"";
NSString* const Dpref_key_strategy = @"MOST_IDLE";

NSString* const Dpref_key_attr_one = @"";
NSString* const Dpref_key_value_one = @"";

NSString* const Dpref_key_attr_two = @"";
NSString* const Dpref_key_value_two = @"";

NSString* const Dpref_key_attr_three = @"";
NSString* const Dpref_key_value_three = @"";

NSString* const Dpref_key_source_name = @"";
NSString* const Dpref_key_resource_ID = @"";

NSString* const Dpref_key_log_file_name_e = @"Elite™ReferenceClient.log";
NSString* const Dpref_key_log_file_name_o = @"Oceana™ReferenceClient.log";

NSString* const Dpref_key_log_file_size = @"512";
NSString* const Dpref_key_log_backup_file_no = @"5";

int const DEFAULT_LOG_LEVEL = 3;
int const DEFAULT_LOG_QUANTITY = 5;

AppDelegate *appdelegate;

+(void)initialize{
    [self setDefaults];
    appdelegate = (AppDelegate *) [[UIApplication sharedApplication] delegate];
    systemSettings = [NSUserDefaults standardUserDefaults];
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    
    [center addObserver:self
               selector:@selector(defaultsChanged:)
                   name:NSUserDefaultsDidChangeNotification
                 object:nil];
}

+(void) setDefaults {
    
    NSDictionary *appDefaults = @{PREF_LOG_ENABLED : @YES ,
                                  PREF_LOG_LEVEL : [NSNumber numberWithInt: DEFAULT_LOG_LEVEL],
                                  pref_key_log_file_name_o : Dpref_key_log_file_name_o,
                                  pref_key_log_file_name_e : Dpref_key_log_file_name_e,
                                  pref_key_log_file_size : Dpref_key_log_file_size,
                                  PREF_NUM_LOGS : [NSNumber numberWithInt: DEFAULT_LOG_QUANTITY],
                                  display_name_o : Ddisplay_name_o,
                                  from_extention_o :Dfrom_extention_o,
                                  destination_o : Ddestination_o,
                                  context_o : Dcontext_o,
                                  topic_o : Dtopic_o,
                                  display_name_e : Ddisplay_name_e,
                                  from_extention_e : Dfrom_extention_e,
                                  destination_e : Ddestination_e,
                                  context_e : Dcontext_e,
                                  topic_e : Dtopic_e,
                                  
                                  amc_cluster_address_o : Damc_cluster_address_o,
                                  amc_cluster_port_o : Damc_cluster_port_o,
                                  amc_use_https_o : Damc_use_https_o,
                                  amc_service_path_o : Damc_service_path_o,
                                  
                                  aawg_server_address_e : Daawg_server_address_e ,
                                  aawg_service_port_e : Daawg_service_port_e,
                                  aawg_use_https_e :Daawg_use_https_e ,
                                  aawg_service_path_e : Daawg_service_path_e,

                                  aawg_server_address_o : Daawg_server_address_o ,
                                  aawg_service_port_o : Daawg_service_port_o,
                                  aawg_use_https_o :Daawg_use_https_o ,
                                  aawg_service_path_o : Daawg_service_path_o,
                                  
                                  aawg_token_server_address_e : Daawg_token_server_address_e ,
                                  aawg_token_service_port_e : Daawg_token_service_port_e,
                                  aawg_token_use_https_e : Daawg_token_use_https_e,
                                  aawg_token_service_path_e : Daawg_token_service_path_e,
                                  
                                  aawg_token_server_address_o : Daawg_token_server_address_o ,
                                  aawg_token_service_port_o : Daawg_token_service_port_o,
                                  aawg_token_use_https_o : Daawg_token_use_https_o,
                                  aawg_token_service_path_o : Daawg_token_service_path_o,

                                  pref_key_priority : Dpref_key_priority,
                                  pref_key_locale : Dpref_key_locale,
                                  pref_key_strategy : Dpref_key_strategy,
                                  pref_key_attr_one : Dpref_key_attr_one,
                                  pref_key_value_one : Dpref_key_value_one,
                                  pref_key_attr_two : Dpref_key_attr_two,
                                  pref_key_value_two : Dpref_key_value_two ,
                                  pref_key_attr_three : Dpref_key_attr_three,
                                  pref_key_value_three : Dpref_key_value_three,
                                  pref_key_source_name : Dpref_key_source_name,
                                  pref_key_resource_ID : Dpref_key_resource_ID,
                                  
                                  pref_key_log_file_name_e : Dpref_key_log_file_name_e,
                                  pref_key_log_file_name_o : Dpref_key_log_file_name_o,
                                  
                                  pref_key_log_file_size : Dpref_key_log_file_size,
                                  pref_key_log_backup_file_no : Dpref_key_log_backup_file_no
                                  
    };
    
    [[NSUserDefaults standardUserDefaults] registerDefaults:appDefaults];
}

// Listens for system settings configuration changes
+ (void)defaultsChanged:(NSNotification *)notification {
    systemSettings = (NSUserDefaults *)[notification object];
    [Logging logDebug:@"Configuration change"];
}

+(NSString *) getLogFileName {
    
    NSString *keyTouse = pref_key_log_file_name_o;
    NSString *valueToUse = Dpref_key_log_file_name_o;
    
    
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = pref_key_log_file_name_e;
        valueToUse = Dpref_key_log_file_name_e;
    }
    
    NSString *destination = [systemSettings stringForKey:keyTouse];
    if (!destination) {
        destination = valueToUse;
    }
    return [destination stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(int) getLogFileSize {
    
    NSString *size = [systemSettings valueForKey:pref_key_log_file_size];
    if(!size){
        size = Dpref_key_log_file_size;
    }
    return [size intValue];
}

+(int) getLogLevel {
    NSNumber* level = (NSNumber*)[systemSettings valueForKey:PREF_LOG_LEVEL];
    if(!level){
        level = [NSNumber numberWithInt:DEFAULT_LOG_LEVEL];
    }
    return [level intValue];
}

+(int) getMaxLogNumber {
    NSNumber* number = (NSNumber*)[systemSettings valueForKey:PREF_NUM_LOGS];
    if(!number){
        number = [NSNumber numberWithInt:DEFAULT_LOG_QUANTITY];
    }
    return [number intValue];
}

+(BOOL) isFileLoggingEnabled {
    return [systemSettings boolForKey:PREF_LOG_ENABLED];
}

+(BOOL) useSecureLogin
{
    
    NSString *value = [systemSettings valueForKey: amc_use_https_o];
    if ([value isEqualToString:@"YES"]) {
        return YES;
    } else {
        return NO;
    }
}

+(NSString*) getPort
{
    NSString *port = [systemSettings stringForKey: amc_cluster_port_o];
    if (!port) {
        port = Damc_cluster_port_o;
    }
    return [port stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getServer {
    NSString *server = [systemSettings stringForKey:amc_cluster_address_o];
    if (!server) {
        server = Damc_cluster_address_o;
    }
    return [server stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getAMCRestUrl {
    NSString *restUrl = [systemSettings stringForKey: amc_service_path_o];
    if (!restUrl) {
        restUrl = Damc_service_path_o;
    }
    return [restUrl stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getUsername {
    
    NSString *keyTouse = from_extention_o;
    NSString *valueToUse = Dfrom_extention_o;
    
    
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = from_extention_e;
        valueToUse = Dfrom_extention_e;
    }
    
    NSString *user = [systemSettings stringForKey:keyTouse];
    if (!user) {
        user = valueToUse;
    }
    
    return [user stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getDisplayName {
    
    NSString *keyTouse = display_name_o;
    NSString *valueToUse = Ddisplay_name_o;
    
    
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = display_name_e;
        valueToUse = Ddisplay_name_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
    
}

+(NSString *) getCustID {
    
    NSString *keyTouse = context_o;
    NSString *valueToUse = Dcontext_o;
    
    
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = context_e;
        valueToUse = Dcontext_e;
    } else {
        return [valueToUse stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]]; // For Oceana 
    }
    
    NSString *customer = [systemSettings stringForKey:keyTouse];
    if (!customer) {
        customer = valueToUse;
    }
    
    return [customer stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getDestinationAddress {
    
    NSString *keyTouse = destination_o;
    NSString *valueToUse = Ddestination_o;
    
    
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = destination_e;
        valueToUse = Ddestination_e;
    }
    
    NSString *destination = [systemSettings stringForKey:keyTouse];
    if (!destination) {
        destination = valueToUse;
    }
    
    return [destination stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getTopic {
    
    NSString *keyTouse = topic_o;
    NSString *valueToUse = Dtopic_o;
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = topic_e;
        valueToUse = Dtopic_e;
    }
    
    NSString *topic = [systemSettings stringForKey:keyTouse];
    if (!topic) {
        topic = valueToUse;
    }
    
    return [topic stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString*) getPriority {
    NSString *priority = [systemSettings stringForKey: pref_key_priority];
    if (!priority) {
        priority = Dpref_key_priority;
    }
    return [priority stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}
+(NSString*) getLocale {
    NSString *locale = [systemSettings stringForKey:pref_key_locale];
    if (!locale) {
        locale = Dpref_key_locale;
    }
    return [locale stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}
+(NSString*) getStrategy {
    NSString *strategy = [systemSettings stringForKey:pref_key_strategy];
    if (!strategy) {
        strategy = Dpref_key_strategy;
    }
    return [strategy stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}
+(NSString*) getSourceName {
    NSString *sourceName = [systemSettings stringForKey: pref_key_source_name];
    if (!sourceName) {
        sourceName = Dpref_key_source_name;
    }
    return [sourceName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}
+(NSString*) getResourceId {
    NSString *resourceId = [systemSettings stringForKey: pref_key_resource_ID];
    if (!resourceId) {
        resourceId = Dpref_key_resource_ID;
    }
    return [resourceId stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getNameAttrOne {
    NSString *nameOne = [systemSettings stringForKey: pref_key_attr_one];
    if (!nameOne) {
        nameOne = Dpref_key_attr_one;
    }
    return [nameOne stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getValueAttrOne {
    NSString *valueOne = [systemSettings stringForKey: pref_key_value_one];
    if (!valueOne) {
        valueOne = Dpref_key_value_one;
    }
    return [valueOne stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getNameAttrTwo {
    NSString *nameTwo = [systemSettings stringForKey: pref_key_attr_two];
    if (!nameTwo) {
        nameTwo = Dpref_key_attr_two;
    }
    return [nameTwo stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getValueAttrTwo {
    NSString *valueTwo = [systemSettings stringForKey:pref_key_value_two];
    if (!valueTwo) {
        valueTwo = Dpref_key_value_two;
    }
    return [valueTwo stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getNameAttrThree {
    NSString *nameThree = [systemSettings stringForKey: pref_key_attr_three];
    if (!nameThree) {
        nameThree = Dpref_key_attr_three;
    }
    return [nameThree stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getValueAttrThree {
    NSString *valueThree = [systemSettings stringForKey: pref_key_value_three];
    if (!valueThree) {
        valueThree = Dpref_key_value_three;
    }
    return [valueThree stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString *) getAAWGServerAddress {
    NSString *keyTouse = aawg_server_address_o;
    NSString *valueToUse = Daawg_server_address_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_server_address_e;
        valueToUse = Daawg_server_address_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString*) getAAWGServerPort
{
    NSString *keyTouse = aawg_service_port_o;
    NSString *valueToUse = Daawg_service_port_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_service_port_e;
        valueToUse = Daawg_service_port_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(BOOL) isAawgSecure
{
    NSString *value = [systemSettings valueForKey: aawg_use_https_o];
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
            value = [systemSettings valueForKey: aawg_use_https_e];
    }
    if ([value isEqualToString:@"YES"]) {
        return YES;
    } else {
        return NO;
    }
}

+(NSString*) getAAWGRestUrl
{
    NSString *keyTouse = aawg_service_path_o;
    NSString *valueToUse = Daawg_service_path_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_service_path_e;
        valueToUse = Daawg_service_path_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString*) getTokenServiceAddress {
    
    NSString *keyTouse = aawg_token_server_address_o;
    NSString *valueToUse = Daawg_token_server_address_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_token_server_address_e;
        valueToUse = Daawg_token_server_address_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(NSString*) getTokenServicePort {
    
    NSString *keyTouse = aawg_token_service_port_o;
    NSString *valueToUse = Daawg_token_service_port_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_token_service_port_e;
        valueToUse = Daawg_token_service_port_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}

+(BOOL) isTokenServiceSecure {
    
    NSString *value = [systemSettings valueForKey: aawg_token_use_https_o];
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
            value = [systemSettings valueForKey: aawg_token_use_https_e];
    }
    
    if ([value isEqualToString:@"YES"]) {
        return YES;
    } else {
        return NO;
    }
}

+(NSString*) getTokenServiceUrlPath {
    
    NSString *keyTouse = aawg_token_service_path_o;
    NSString *valueToUse = Daawg_token_service_path_o;
        
    if(appdelegate.selectedPlatformType == AOPlatFormType_ELITE) {
        keyTouse = aawg_token_service_path_e;
        valueToUse = Daawg_token_service_path_e;
    }
    
    NSString *displayName = [systemSettings stringForKey:keyTouse];
    if (!displayName) {
        displayName = valueToUse;
    }
    return [displayName stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
}


#pragma mark- Read Settings From Settings.json file

+ (NSDictionary *)readSettignsFromJSON
{
    
    NSDictionary *mainSettings = [[NSUserDefaults standardUserDefaults] objectForKey: pref_all_saved_settigns];
    
    if (mainSettings) {
        return mainSettings;
    } else {
        
        NSString *path = [[NSBundle mainBundle] pathForResource:@"SettingsPreferences1" ofType:@"json"];
        NSData *data = [NSData dataWithContentsOfFile:path];
        NSError *err;
        mainSettings = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&err];
        if (err) {
            return @{};
        }
        [[NSUserDefaults standardUserDefaults] setObject:mainSettings forKey:pref_all_saved_settigns];
        [[NSUserDefaults standardUserDefaults] synchronize];
    }
    return mainSettings;
}

+(void) wrightSettignsFromJSON : (NSDictionary *) settingsJson {
    //get the documents directory:
    [[NSUserDefaults standardUserDefaults] setObject:settingsJson forKey:pref_all_saved_settigns];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

+(AOPlatformType) selectedPlatform {
    
    AOPlatformType type = [[NSUserDefaults standardUserDefaults] integerForKey: @"PLATFORM_TYPE"];
    
    return type;
//    return AOPlatFormType_OCEANA;
}

+(void) setSelectedPlatform : (AOPlatformType) type{
    
    [[NSUserDefaults standardUserDefaults] setInteger:type forKey:@"PLATFORM_TYPE"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

@end
