//
//  MenuViewController.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import "MenuViewController.h"
#import "Logging.h"
#import "AppSettings.h"
#import "OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h"
#import "LGPlusButtonsView/LGPlusButtonsView.h"
#import "AppDelegate.h"

@interface MenuViewController()<LGPlusButtonsViewDelegate>
@property LGPlusButtonsView *fabView;
@property (weak, nonatomic) IBOutlet UIButton *recordOrientation;
@property (weak, nonatomic) IBOutlet UILabel *mainTitleLabel;

@end


@implementation MenuViewController

NSMutableArray* supportedResolutions;
long resolutionIndex;
BOOL useSavedResolution = YES;
NSString* const RESOLUTIONS_KEY = @"RESOLUTION";
AOVideoResolution videoResolution;

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.gradientView = [[GradientView alloc] initWithFrame:self.menuView.bounds];
    self.gradientView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    self.gradientView.layer.colors = [NSArray arrayWithObjects:(id)[[UIColor colorWithRed:(255.0/255.0) green:(255.0/255.0) blue:(255.0/255.0) alpha:1] CGColor], (id)[[UIColor colorWithRed:(255.0/255.0) green:(255.0/255.0) blue:(255.0/255.0) alpha:1] CGColor], nil];
//    [self.menuView insertSubview:self.gradientView atIndex:0];
    self.versionNumber.text = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
    
    _pageTitles = @[ NSLocalizedString(@"Enhance Your Customer App By Adding Avaya Oceana™ WebRTC", @"page1")];
    self.menuText.text = [NSString stringWithFormat:@"Enhance Your Customer App By Adding Avaya Oceana™ WebRTC Video"];
    
    SWRevealViewController *revealViewController = self.revealViewController;
    if ( revealViewController )
    {
        //Left Menu
        [self.sidebarButton addTarget:self.revealViewController action:@selector( revealToggle: ) forControlEvents:UIControlEventTouchUpInside];
        [self.view addGestureRecognizer:self.revealViewController.panGestureRecognizer];

        //Right Menu
//        [self.rightSidebarButton addTarget:self.revealViewController action:@selector( rightRevealToggle: ) forControlEvents:UIControlEventTouchUpInside];
//        [self.view addGestureRecognizer:self.revealViewController.panGestureRecognizer];
    }
    self.mainTitleLabel.text = NSLocalizedString(@"Avaya WebRTC Connect Reference Client",nil);
    //Resolution picker setup
    supportedResolutions = [[NSMutableArray alloc] init];

    useSavedResolution = [[NSUserDefaults standardUserDefaults] objectForKey:RESOLUTIONS_KEY] != nil;
    if(useSavedResolution){
        resolutionIndex = [[NSUserDefaults standardUserDefaults] integerForKey:RESOLUTIONS_KEY];
        [Logging logDebug:@"Reading resolutionIndex: %i",resolutionIndex];
    }
    [self setRecorResolutionsAndOrientation];
    [self showAvailableResolutions];
    [self initiateFab2];
           
}

-(void) setRecorResolutionsAndOrientation {
    
    AppDelegate *appDelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];
    [self.btnAvailable setTitle: [self getStringForPrefKey: [NSNumber numberWithInt:(int)appDelegate.currentSelectedVideoRecordPref]] forState:UIControlStateNormal];
    if (appDelegate.currentSelectedVideoRecordOrientation == AOVideoCaptureOrientation_LandscapeOnly) {
        [self.recordOrientation setTitle:NSLocalizedString(@"Landscape Only", nil) forState:UIControlStateNormal];
    } else {
        [self.recordOrientation setTitle:NSLocalizedString(@"Landscape OR Portrait", nil) forState:UIControlStateNormal];
    }
}


-(void) initiateFab2 {
    
    
    self.fabView.backgroundColor = [UIColor blueColor];
    
    self.fabView =  [[LGPlusButtonsView alloc] initWithNumberOfButtons:4 firstButtonIsPlusButton:YES showAfterInit:YES delegate:self];
    [self.fabView setButtonsSize:CGSizeMake(52.f, 52.f) forOrientation:LGPlusButtonsViewOrientationAll];
    [self.fabView setButtonsLayerCornerRadius:52.f/2.f forOrientation:LGPlusButtonsViewOrientationAll];
    [self.fabView setButtonsTitles:@[@"",@"",@"", @""] forState:UIControlStateNormal];
    [self.fabView setDescriptionsTexts:@[@"",@"", NSLocalizedString(@"Start Video",nil), NSLocalizedString(@"Start Voice",nil),]];
    [self.fabView setButtonsImages:@[[UIImage imageNamed:@"ic_fab_plus"], [UIImage new], [UIImage imageNamed:@"ic_fab_video"], [UIImage imageNamed:@"ic_fab_audio"]]
                                  forState:UIControlStateNormal
                            forOrientation:LGPlusButtonsViewOrientationAll];
    [self.fabView setDescriptionsTextColor:[UIColor whiteColor]];
    [self.fabView setDescriptionsTextColor:[UIColor whiteColor]];
    [self.fabView setDescriptionsBackgroundColor:[UIColor colorWithWhite:0.f alpha:0.66]];
    [self.fabView setDescriptionsLayerCornerRadius:6.f forOrientation:LGPlusButtonsViewOrientationAll];
    [self.fabView setDescriptionsContentEdgeInsets:UIEdgeInsetsMake(4.f, 8.f, 4.f, 8.f) forOrientation:LGPlusButtonsViewOrientationAll];
    [self.fabView setPlusButtonAnimationType:LGPlusButtonAnimationTypeRotate];
    [self.view addSubview:self.fabView];
}

-(void) showAvailableResolutions
{
    [supportedResolutions removeAllObjects];
    supportedResolutions = [AOVideoDevice getSupportedCameraCaptureResolutionPrefes];
}

- (void)resolutionToBeUsed:(AOVideoResolution)resolution
{
    videoResolution = resolution;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (PageContentViewController *)viewControllerAtIndex:(NSUInteger)index
{
    if (([self.pageTitles count] == 0) || (index >= [self.pageTitles count])) {
        return nil;
    }
    
    // Create a new view controller and pass suitable data.
    PageContentViewController *pageContentViewController = [self.storyboard instantiateViewControllerWithIdentifier:@"PageContentViewController"];
    pageContentViewController.titleText = self.pageTitles[index];
    pageContentViewController.pageIndex = index;
    
    return pageContentViewController;
}

//

- (void)plusButtonsViewWillShow:(LGPlusButtonsView *)plusButtonsView
{
    
}
- (void)plusButtonsViewWillHide:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewDidShow:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewDidHide:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewWillShowButtons:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewWillHideButtons:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewDidShowButtons:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsViewDidHideButtons:(LGPlusButtonsView *)plusButtonsView {
    
}
- (void)plusButtonsView:(LGPlusButtonsView *)plusButtonsView buttonPressedWithTitle:(NSString *)title description:(NSString *)description index:(NSUInteger)index {
    
    if (index != 0 && index != 1) {
        [plusButtonsView hideButtonsAnimated:YES completionHandler:^{
            UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"iPhone_new" bundle: nil];
            UIViewController *vc;
            SWRevealViewControllerSeguePushController *segue;
            if (index == 2) {
                vc = [storyboard instantiateViewControllerWithIdentifier:@"videoCall"];
                segue = [[SWRevealViewControllerSeguePushController alloc] initWithIdentifier:@"ANY_ID" source:self destination:vc];
                [segue perform];
            }else if (index == 3) {
                vc = [storyboard instantiateViewControllerWithIdentifier:@"audioCall"];
                segue = [[SWRevealViewControllerSeguePushController alloc] initWithIdentifier:@"ANY_ID" source:self destination:vc];
                [segue perform];
            }
        }];
    }
}



#pragma mark - Page View Controller Data Source

- (UIViewController *)pageViewController:(UIPageViewController *)pageViewController viewControllerBeforeViewController:(UIViewController *)viewController
{
    NSUInteger index = ((PageContentViewController*) viewController).pageIndex;
    
    if ((index == 0) || (index == NSNotFound)) {
        return nil;
    }
    
    index--;
    return [self viewControllerAtIndex:index];
}

- (UIViewController *)pageViewController:(UIPageViewController *)pageViewController viewControllerAfterViewController:(UIViewController *)viewController
{
    NSUInteger index = ((PageContentViewController*) viewController).pageIndex;
    
    if (index == NSNotFound) {
        return nil;
    }
    
    index++;
    if (index == [self.pageTitles count]) {
        return nil;
    }
    return [self viewControllerAtIndex:index];
}

- (NSInteger)presentationCountForPageViewController:(UIPageViewController *)pageViewController
{
    return [self.pageTitles count];
}

- (NSInteger)presentationIndexForPageViewController:(UIPageViewController *)pageViewController
{
    return 0;
}

- (IBAction)availableResolutionPreessed:(UIButton *)sender {
    AppDelegate *appDelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];
    UIAlertController *availabeResolutions  = [UIAlertController alertControllerWithTitle:@"Select" message:@"Available Resolutions" preferredStyle:UIAlertControllerStyleActionSheet];
    for (int i = 0; i < supportedResolutions.count; i ++) {
        NSNumber *aPref = (NSNumber*)[supportedResolutions objectAtIndex:i];
        UIAlertAction *action = [UIAlertAction actionWithTitle:[self getStringForPrefKey: aPref] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            appDelegate.currentSelectedVideoRecordPref = [self getKeyFromNumber:aPref];
            [sender setTitle:[self getStringForPrefKey: aPref] forState:UIControlStateNormal];
            [self dismissViewControllerAnimated:availabeResolutions completion:nil];
        }];
        
        if ([[NSNumber numberWithInt:(int)appDelegate.currentSelectedVideoRecordPref] isEqualToNumber: aPref]) {
            [action setValue:@YES forKey:@"checked"];
        }
        [availabeResolutions addAction:action];
    }
    [availabeResolutions addAction: [UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        [self dismissViewControllerAnimated:availabeResolutions completion:nil];
    }]];
    if (availabeResolutions.popoverPresentationController != nil) {
           availabeResolutions.popoverPresentationController.sourceView = self.view;
           availabeResolutions.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           availabeResolutions.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:availabeResolutions animated:YES completion:nil];
}

-(NSString*) getStringForPrefKey :  (NSNumber *) key {
    switch ([key intValue]) {
        case 6:
            return  NSLocalizedString(@"Video Capture Preference Min",nil);
            break;
        case 5:
            return NSLocalizedString(@"Video Capture Preference 270p",nil);
            break;
        case 4:
            return NSLocalizedString(@"Video Capture Preference 360p",nil);
            break;
        case 3:
            return NSLocalizedString(@"Video Capture Preference 540p",nil);
            break;
        case 2:
            return NSLocalizedString(@"Video Capture Preference 720p",nil);
            break;
        case 1:
            return NSLocalizedString(@"Video Capture Preference 1080p",nil);
            break;
        case 0:
            return NSLocalizedString(@"Video Capture Preference Max",nil);
            break;
            
        default:
            break;
    }
    return NSLocalizedString(@"Video Capture Preference Min",nil);
}


-(AOVideoCapturePreference) getKeyFromNumber :  (NSNumber *) key {
    switch ([key intValue]) {
        case 6:
            return AOVideoCapturePreference_Min;
            break;
        case 5:
            return AOVideoCapturePreference_270p;
            break;
        case 4:
            return AOVideoCapturePreference_360p;
            break;
        case 3:
            return AOVideoCapturePreference_540p;
            break;
        case 2:
            return AOVideoCapturePreference_720p;
            break;
        case 1:
            return AOVideoCapturePreference_1080p;
            break;
        case 0:
            return AOVideoCapturePreference_Max;
            break;
        default:
            return AOVideoCapturePreference_Min;
            break;
    }
    return AOVideoCapturePreference_Min;
}


- (IBAction)videoRecordOrienataionPressed:(UIButton *)sender {
    
    AppDelegate *appDelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];

    UIAlertController *availabeResolutions  = [UIAlertController alertControllerWithTitle:@"Select" message:@"Available Resolutions" preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction * landscapeOnlyAction =  [UIAlertAction actionWithTitle:NSLocalizedString(@"Landscape Only", nil) style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
    [sender setTitle:NSLocalizedString(@"Landscape Only", nil) forState:UIControlStateNormal];
    appDelegate.currentSelectedVideoRecordOrientation = AOVideoCaptureOrientation_LandscapeOnly;
        [self dismissViewControllerAnimated:availabeResolutions completion:nil];
    }];
    UIAlertAction * landscapeOrPortAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"Landscape OR Portrait", nil) style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
       appDelegate.currentSelectedVideoRecordOrientation = AOVideoCaptureOrientation_LandscapeOrPortrait;
        [sender setTitle:NSLocalizedString(@"Landscape OR Portrait", nil) forState:UIControlStateNormal];
        [self dismissViewControllerAnimated:availabeResolutions completion:nil];
    }];
    
    [landscapeOnlyAction setValue:@NO forKey:@"checked"];
    [landscapeOrPortAction setValue:@NO forKey:@"checked"];

    [availabeResolutions addAction:landscapeOnlyAction];
    [availabeResolutions addAction:landscapeOrPortAction];
    
    if (appDelegate.currentSelectedVideoRecordOrientation == AOVideoCaptureOrientation_LandscapeOnly) {
        [landscapeOnlyAction setValue:@YES forKey:@"checked"];
    } else {
        [landscapeOrPortAction setValue:@YES forKey:@"checked"];
    }
    [availabeResolutions addAction: [UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        [self dismissViewControllerAnimated:availabeResolutions completion:nil];
    }]];
    if (availabeResolutions.popoverPresentationController != nil) {
           availabeResolutions.popoverPresentationController.sourceView = self.view;
           availabeResolutions.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           availabeResolutions.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:availabeResolutions animated:YES completion:nil];
}

@end
