//
//  RCVideoCallStatsViewController.m
//  OceanaReferenceClient
//
//  Created by Mohan on 03/03/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "RCVideoCallStatsViewController.h"
#import "RCCallStatTableViewCell.h"
#import "Constants.h"

@interface RCVideoCallStatsViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) NSArray* arrayOfVideoStatsR, *arrayOfVideoStatsS;
@property (weak, nonatomic) IBOutlet UITableView *mainTableView;
@property (weak, nonatomic) NSTimer *refreshTimer;
@end

@implementation RCVideoCallStatsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self updateTheCallStatestics];
}

- (void) updateTheCallStatestics {
    
    __weak RCVideoCallStatsViewController *weakSelf = self;
        [self.oceanaVideoClient readVideoDetailsWithCompletionHandler:^(AOVideoDetails *videoDetails) {
            [weakSelf initStatsWithVideoDetails:videoDetails];
        }];
}

-(void) initStatsWithVideoDetails : (AOVideoDetails* ) currentVideDetails {
    
    if (currentVideDetails.codec) {
    self.arrayOfVideoStatsR = @[
                               @{kNSStringConstResolution:[NSString stringWithFormat:@"%lu X %lu",(unsigned long)currentVideDetails.receiveStatistics.width, (unsigned long)currentVideDetails.receiveStatistics.height]},
                               @{kNSStringConstFrameRate:[NSString stringWithFormat:@"%lu fps", currentVideDetails.receiveStatistics.actualFrameRate]},
                               @{kNSStringConstCodec: currentVideDetails.codec},
                               @{kNSStringConstActualBitRate: [NSString stringWithFormat:@"%lu kbps", currentVideDetails.receiveStatistics.actualBitrate]},
                               @{kNSStringConstMaxBitRate: [NSString stringWithFormat:@"%lu kbps", currentVideDetails.receiveStatistics.targetBitrate]},
                               @{kNSStringConstRoundTripDelay: [NSString stringWithFormat:@"%lu ms", currentVideDetails.roundTripTimeMilliseconds]},
                               @{kNSStringConstJitter: [NSString stringWithFormat:@"%lu ms", currentVideDetails.receiveStatistics.jitterBufferSizeMilliseconds]},
                               @{kNSStringConstPacketLost: [NSString stringWithFormat:@"%lu packets, %lu %%", currentVideDetails.receiveStatistics.packetLossTotal, currentVideDetails.receiveStatistics.packetLossFraction]},
                               @{kNSStringConstEncryption: [self encryptioTypeToString:currentVideDetails.mediaEncryptionType]},
                          ];
    self.arrayOfVideoStatsS = @[
                                @{kNSStringConstResolution:[NSString stringWithFormat:@"%lu X %lu",(unsigned long)currentVideDetails.transmitStatistics.width, (unsigned long)currentVideDetails.transmitStatistics.height]},
                                @{kNSStringConstFrameRate:[NSString stringWithFormat:@"%lu fps", currentVideDetails.transmitStatistics.actualFrameRate]},
                                @{kNSStringConstCodec: currentVideDetails.codec},
                                @{kNSStringConstActualBitRate: [NSString stringWithFormat:@"%lu kbps", currentVideDetails.transmitStatistics.actualBitrate]},
                                @{kNSStringConstMaxBitRate: [NSString stringWithFormat:@"%lu kbps", currentVideDetails.transmitStatistics.targetBitrate]},
                                @{kNSStringConstRoundTripDelay: [NSString stringWithFormat:@"%lu ms", currentVideDetails.roundTripTimeMilliseconds]},
                                @{kNSStringConstJitter: [NSString stringWithFormat:@"%lu ms", currentVideDetails.transmitStatistics.jitterBufferSizeMilliseconds]},
                                @{kNSStringConstPacketLost: [NSString stringWithFormat:@"%lu packets, %lu %%", currentVideDetails.transmitStatistics.packetLossTotal, currentVideDetails.transmitStatistics.packetLossFraction]},
                                @{kNSStringConstEncryption: [self encryptioTypeToString:currentVideDetails.mediaEncryptionType]},
                                ];
    
        [self.mainTableView reloadData];
    }
}

-(void) viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    if (!self.refreshTimer) {
        self.refreshTimer = [NSTimer scheduledTimerWithTimeInterval:5 target:self selector:@selector(updateTheCallStatestics) userInfo:nil repeats:YES];
    }
}

-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    if (self.refreshTimer) {
        [self.refreshTimer invalidate];
        self.refreshTimer = nil;
    }
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
    return self.arrayOfVideoStatsS.count;
    } else if (section == 1) {
      return self.arrayOfVideoStatsR.count;
    } else {
        return 0;
    }
}


- (RCCallStatTableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    RCCallStatTableViewCell *cell =(RCCallStatTableViewCell*) [tableView dequeueReusableCellWithIdentifier:@"call_stat_cell" forIndexPath:indexPath];
    if (cell != nil) {
        if (indexPath.section == 0) {
        cell.propertyLabel.text = [[[self.arrayOfVideoStatsS objectAtIndex:indexPath.row] allKeys] firstObject];
        NSString *key = [[[self.arrayOfVideoStatsS objectAtIndex:indexPath.row] allKeys] firstObject];
        cell.valueLabel.text = [[self.arrayOfVideoStatsS objectAtIndex:indexPath.row] valueForKey:key];
        } else {
            cell.propertyLabel.text = [[[self.arrayOfVideoStatsR objectAtIndex:indexPath.row] allKeys] firstObject];
            NSString *key = [[[self.arrayOfVideoStatsR objectAtIndex:indexPath.row] allKeys] firstObject];
            cell.valueLabel.text = [[self.arrayOfVideoStatsR objectAtIndex:indexPath.row] valueForKey:key];
        }
    }
    return cell;
}
- (IBAction)backButtonPressed:(UIBarButtonItem *)sender {
    [self.tabBarController dismissViewControllerAnimated:YES completion:nil];
    
}

//- (CGFloat) tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
//
//    NSString *key = [[[self.arrayOfVideoStatsS objectAtIndex:indexPath.row] allKeys] firstObject];
//    if ([key isEqualToString:@"Encryption"]) {
//        return 90;
//    }
//    return 70;
//}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return UITableViewAutomaticDimension;
}

- (UIView *) tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    
    UILabel *titleView =[[UILabel alloc]initWithFrame:CGRectMake(0, 0, tableView.frame.size.width, 30)];
    titleView.backgroundColor = [UIColor colorWithRed:56/255.0 green:80/255.0 blue:99/255.0 alpha:1];
    titleView.textColor = [UIColor whiteColor];
    titleView.textAlignment = NSTextAlignmentCenter;
    titleView.font = [UIFont systemFontOfSize:15];
    if (section == 0) {
        titleView.text = @"SEND";
    } else {
        titleView.text = @"RECEIVE";
    }
    return titleView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (NSString*)encryptioTypeToString:(AOMediaEncryptionType)formatType {
    NSString *result = nil;
    
    switch(formatType) {
        case AOMediaEncryptionTypeNone:
            result = @"AOMediaEncryptionTypeNone";
            break;
        case AOMediaEncryptionTypeAES128SHA1HMAC80:
            result = @"AOMediaEncryptionTypeAES128SHA1HMAC80";
            break;
        case AOMediaEncryptionTypeAES128SHA1HMAC32:
            result = @"AOMediaEncryptionTypeAES128SHA1HMAC32";
            break;
        case AOMediaEncryptionTypeAES256SHA1HMAC80:
            result = @"AOMediaEncryptionTypeAES256SHA1HMAC80";
            break;
        case AOMediaEncryptionTypeAES256SHA1HMAC32:
            result = @"AOMediaEncryptionTypeAES256SHA1HMAC32";
            break;
        default:
            result = @"AOMediaEncryptionTypeNone";
    }
    
    return result;
}

@end

