//
//  RFSettingsViewController.m
//  OceanaReferenceClient
//
//  Created by Mohan on 08/05/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "RFSettingsViewController.h"
#import "RFTextFTableViewCell.h"
#import "RFSwitchTableViewCell.h"
#import "AppSettings.h"
#import "AppDelegate.h"
#import "CollapsibleTableViewHeader.h"

#import <OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h>


NSString *const key_CLIENT_Config_Elite = @"Client Config Elite";
NSString *const key_CLIENT_Config_Oceana = @"Client Config Oceana";
NSString *const key_AMC_Config = @"AMC Config Oceana";

NSString * key_AAWG_Config = @"AAWG Config";
NSString * key_TOKEN_Config = @"Token Config";
NSString * key_SERVICE_Config = @"Service";

NSString * key_AAWG_Config_e = @"AAWG Config";
NSString * key_TOKEN_Config_e = @"Token Config";
NSString * key_SERVICE_Config_e = @"Service";

NSString *const key_ATTRIBUTE_ONE = @"Attribute One";
NSString *const key_ATTRIBUTE_TWO = @"Attribute Two";
NSString *const key_ATTRIBUTE_THREE = @"Attribute Three";
NSString *const key_RESOURCES = @"Resources";
NSString * key_LOGGING = @"Logging";

NSString *const key_RESOURCES_e = @"Resources";
NSString *const key_LOGGING_e = @"Logging";

NSString *const key_OCEANA = @"Oceana";
NSString *const key_ELITE = @"Elite";

@interface RFSettingsViewController ()<UITableViewDelegate, UITableViewDataSource , RFCellWithTextFDelegate, RFCellWithSwitchDelegate, CollapsibleTableViewHeaderDelegate> {
    
    NSMutableArray *arrayOfsettings;
    NSMutableArray *arrayOfsettingsKeys;
    NSMutableDictionary *mainSetingsDictionary;
    NSMutableArray *arrayOfSections;
}
@property (weak, nonatomic) IBOutlet UITableView *settingsTableView;

@end

@implementation RFSettingsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    arrayOfSections = [[NSMutableArray alloc] init];
    self.settingsTableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
}


-(void) viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self changeClientConfigs:nil];
    [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];
    [[NSNotificationCenter defaultCenter]
     addObserver:self selector:@selector(orientationChanged:)
     name:UIDeviceOrientationDidChangeNotification
     object:[UIDevice currentDevice]];
}
-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}

- (IBAction)changeClientConfigs:(UIBarButtonItem *)sender {
    
    __weak RFSettingsViewController * weakSelf = (RFSettingsViewController *) self;
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:NSLocalizedString(@"Select",nil) message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
        
    UIAlertAction *oceanaAction = [UIAlertAction actionWithTitle:key_OCEANA style:UIAlertActionStyleDefault handler:^(UIAlertAction * action){
        [weakSelf changeSettingsForConfig : 0];
    }];
    
    UIAlertAction *eliteAction = [UIAlertAction actionWithTitle:key_ELITE style:UIAlertActionStyleDefault handler:^(UIAlertAction * action){
        [weakSelf changeSettingsForConfig : 1];
    }];
        
    AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];
    if (appdelegate.selectedPlatformType == AOPlatFormType_OCEANA) {
        [oceanaAction setValue:@true forKey:@"checked"];
    } else {
        [eliteAction setValue:@true forKey:@"checked"];
    }

    [alert addAction:oceanaAction];
    [alert addAction:eliteAction];

    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction * action){
        
        AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];
           if (appdelegate.selectedPlatformType == AOPlatFormType_OCEANA) {
               
               [weakSelf changeSettingsForConfig : 0];
           } else {
               
               [weakSelf changeSettingsForConfig : 1];
           }
        [self performSegueWithIdentifier:@"returnToMenu" sender:self];
    }];
    [alert addAction:cancelAction];
    
    if (alert.popoverPresentationController != nil) {
        alert.popoverPresentationController.sourceView = self.view;
        alert.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
        alert.popoverPresentationController.permittedArrowDirections = 0;
    }
    
    [self presentViewController:alert animated:YES completion:nil];
}

-(void) changeSettingsForConfig : (NSInteger) config {
    
    AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];

    NSDictionary* dictOfSettings = [AppSettings readSettignsFromJSON];
    if (dictOfSettings.allKeys.count <= 0) {
        // Show Error.
        return;
    }
        
    if (mainSetingsDictionary) {
        [mainSetingsDictionary removeAllObjects];
        mainSetingsDictionary = nil;
    }
    
    if (arrayOfsettings) {
        [arrayOfsettings removeAllObjects];
        arrayOfsettings = nil;
    }
    
    if (arrayOfsettingsKeys) {
        [arrayOfsettingsKeys removeAllObjects];
        arrayOfsettingsKeys = nil;
    }
    
    mainSetingsDictionary = [[NSMutableDictionary alloc] initWithDictionary:dictOfSettings];
    arrayOfsettings = [[NSMutableArray alloc] init];
    arrayOfsettingsKeys = [[NSMutableArray alloc] init];
        
    
    switch (config) {
        case 0:
            
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_CLIENT_Config_Oceana] atIndex:0];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@",key_AMC_Config]] atIndex:1];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_AAWG_Config,key_OCEANA]] atIndex:2];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_TOKEN_Config,key_OCEANA]] atIndex:3];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_SERVICE_Config] atIndex:4];
//           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_ATTRIBUTE_ONE] atIndex:5];
//           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_ATTRIBUTE_TWO] atIndex:6];
//           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_ATTRIBUTE_THREE] atIndex:7];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_RESOURCES] atIndex:5];
           [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_LOGGING,key_OCEANA]] atIndex:6];

           [arrayOfsettingsKeys insertObject:  key_CLIENT_Config_Oceana   atIndex:0];
            [arrayOfsettingsKeys insertObject:  key_AMC_Config   atIndex:1];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_AAWG_Config,key_OCEANA] atIndex:2];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_TOKEN_Config,key_OCEANA] atIndex:3];
            [arrayOfsettingsKeys insertObject:  key_SERVICE_Config   atIndex:4];
//            [arrayOfsettingsKeys insertObject:  key_ATTRIBUTE_ONE   atIndex:5];
//            [arrayOfsettingsKeys insertObject:  key_ATTRIBUTE_TWO   atIndex:6];
//            [arrayOfsettingsKeys insertObject:  key_ATTRIBUTE_THREE   atIndex:7];
            [arrayOfsettingsKeys insertObject:  key_RESOURCES   atIndex:5];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_LOGGING,key_OCEANA]   atIndex:6];
            
            appdelegate.selectedPlatformType = AOPlatFormType_OCEANA;
            [AppSettings setSelectedPlatform:AOPlatFormType_OCEANA];
            break;
            
        case 1:
                   
            [arrayOfsettings insertObject:[dictOfSettings valueForKey: key_CLIENT_Config_Elite] atIndex:0];
            [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_AAWG_Config,key_ELITE]] atIndex:1];
            [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_TOKEN_Config,key_ELITE]] atIndex:2];
            [arrayOfsettings insertObject:[dictOfSettings valueForKey: [NSString stringWithFormat:@"%@ %@",key_LOGGING,key_ELITE]] atIndex:3];
            
            [arrayOfsettingsKeys insertObject:  key_CLIENT_Config_Elite   atIndex:0];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_AAWG_Config,key_ELITE] atIndex:1];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_TOKEN_Config,key_ELITE] atIndex:2];
            [arrayOfsettingsKeys insertObject:  [NSString stringWithFormat:@"%@ %@",key_LOGGING,key_ELITE]   atIndex:3];
                        
            appdelegate.selectedPlatformType = AOPlatFormType_ELITE;
            [AppSettings setSelectedPlatform:AOPlatFormType_ELITE];
            break;
    }
        
    [arrayOfSections removeAllObjects];
    for (NSString * key in arrayOfsettingsKeys) {
        CollapsibleTableViewHeader * header = [[CollapsibleTableViewHeader alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 50)];
        header.titleLabel.text = key;
        header.delegate = self;
        header.isCollapsed = YES;
        [arrayOfSections addObject:header];
    }

    [UIView transitionWithView: self.settingsTableView
                      duration: 0.2f
                       options: UIViewAnimationOptionTransitionCrossDissolve
                    animations: ^(void){
                                [self.settingsTableView reloadData];
                                } completion: nil];
    
}



#pragma mark- Action

- (IBAction)closeButtonPressed:(UIBarButtonItem *)sender {
    
    [self performSegueWithIdentifier:@"returnToMenu" sender:self];
}



#pragma mark- UItableView delegate and datasource

- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (arrayOfsettings.count <= 0) {
        return 0;
    }
//    CollapsibleTableViewHeader *headerForSection = (CollapsibleTableViewHeader*)[tableView headerViewForSection:section];
//    if (headerForSection.isCollapsed) {
        NSArray *sectionArray = [arrayOfsettings objectAtIndex:section];
        return sectionArray.count;
//    }
    return 0;
}

- (UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    UIView *selectionView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, tableView.frame.size.width, 50)];
    selectionView.backgroundColor = [UIColor clearColor];
    
    NSArray *sectionArray = [arrayOfsettings objectAtIndex:indexPath.section];
    NSDictionary *currentDict = [sectionArray objectAtIndex:indexPath.row];
    
    NSMutableArray *tempKeyArray = [NSMutableArray arrayWithArray:currentDict.allKeys];
    [tempKeyArray removeObject:@"type"];
    [tempKeyArray removeObject:@"values"];
    [tempKeyArray removeObject:@"pref_key"];
    
    NSString *keylabel = [tempKeyArray firstObject];
    NSString *keyValue = [currentDict valueForKey:keylabel];
    
    if (![[NSUserDefaults standardUserDefaults] valueForKey: [currentDict valueForKey:@"pref_key"]] || [[[NSUserDefaults standardUserDefaults] valueForKey: [currentDict valueForKey:@"pref_key"]] isEqualToString:@""]) {
        [[NSUserDefaults standardUserDefaults] setObject: keyValue forKey: [currentDict valueForKey:@"pref_key"]];
        [[NSUserDefaults standardUserDefaults] synchronize];
    }
    
    if ([[currentDict valueForKey:@"type"] isEqualToString:@"text"]) {
        RFTextFTableViewCell *cell =(RFTextFTableViewCell*) [tableView dequeueReusableCellWithIdentifier:@"cell_with_text_cell" forIndexPath:indexPath];
        cell.propertyKeyLabel.text = keylabel;
        cell.theTextField.text = keyValue;
        cell.accessoryType = UITableViewCellAccessoryNone;
        cell.theTextField.textAlignment = NSTextAlignmentLeft;
        cell.isTypeList = NO;
        cell.textFDelegate = self;
        if (cell != nil) {
            
            
        }
        cell.selectedBackgroundView = selectionView;
        return cell;
    }if ([[currentDict valueForKey:@"type"] isEqualToString:@"list"]) {
        RFTextFTableViewCell *cell =(RFTextFTableViewCell*) [tableView dequeueReusableCellWithIdentifier:@"cell_with_text_cell" forIndexPath:indexPath];
        cell.propertyKeyLabel.text = keylabel;
        cell.theTextField.text = keyValue;
        cell.theTextField.textAlignment = NSTextAlignmentRight;
        cell.textFDelegate = self;
        cell.isTypeList = YES;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        cell.contentView.superview.backgroundColor = cell.contentView.backgroundColor;
        if (cell != nil) {
            
        }
        cell.selectedBackgroundView = selectionView;
        return cell;
    }else {
        RFSwitchTableViewCell *cell =(RFSwitchTableViewCell*) [tableView dequeueReusableCellWithIdentifier:@"cell_with_switch_cell" forIndexPath:indexPath];
        cell.propertyKeylabel.text = keylabel;
        [cell.theSwitch setOn:YES];
        cell.accessoryType = UITableViewCellAccessoryNone;
        if ([keyValue isEqualToString:@"NO"]) {
            [cell.theSwitch setOn:NO];
        }
        cell.switchDelegate = self;
        if (cell != nil) {
            
        }
        cell.selectedBackgroundView = selectionView;
        return cell;
    }
}

- (void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    RFTextFTableViewCell *cell =  (RFTextFTableViewCell *)[tableView cellForRowAtIndexPath:indexPath];
    if ([cell isKindOfClass:[RFTextFTableViewCell class]] && cell.isTypeList) {
        
        NSArray *sectionArray = [arrayOfsettings objectAtIndex:indexPath.section];
        NSDictionary *currentDict = [sectionArray objectAtIndex:indexPath.row];
        [self cellWithTypeListIsPressedWithValues:[NSArray arrayWithArray:[currentDict valueForKey:@"values"]] andTextF:cell.theTextField];
    } else if ([cell isKindOfClass:[RFTextFTableViewCell class]] && !cell.isTypeList){
        
        [cell.theTextField becomeFirstResponder];
    }
    [tableView deselectRowAtIndexPath:indexPath animated:NO];
}

-(NSInteger) numberOfSectionsInTableView:(UITableView *)tableView {
    
    return  arrayOfsettings.count;
}

//- (NSString *) tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
//    return [arrayOfsettingsKeys objectAtIndex:section];
//}

- (CollapsibleTableViewHeader *) tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    CollapsibleTableViewHeader * header= (CollapsibleTableViewHeader*)[arrayOfSections objectAtIndex:section];
    header.section = section;
    header.backgroundColor = self.view.backgroundColor;
    return header;
}

-(CGFloat) tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return 50;
}

-(CGFloat) tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    CollapsibleTableViewHeader * header  = (CollapsibleTableViewHeader*)[arrayOfSections objectAtIndex:indexPath.section];
    return header.isCollapsed ? 0 : UITableViewAutomaticDimension;
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */


#pragma mark- TextF and Switch Cell Delegates

-(void) textFieldValueUpdatedWithTextWithCell : (RFTextFTableViewCell *) cell : (NSString *) string {
    
    NSIndexPath *indexPath = [self.settingsTableView indexPathForCell:cell];
    NSMutableArray *sectionArray = [[NSMutableArray alloc] initWithArray:[arrayOfsettings objectAtIndex:indexPath.section]];
    
    NSMutableDictionary *currentDict = [[NSMutableDictionary alloc] initWithDictionary:[sectionArray objectAtIndex:indexPath.row]];
    [sectionArray removeObjectAtIndex:indexPath.row];
    [currentDict setValue:string forKey:cell.propertyKeyLabel.text];
    
    [[NSUserDefaults standardUserDefaults] setObject:string forKey: [currentDict valueForKey:@"pref_key"]];
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    [sectionArray insertObject:currentDict atIndex:indexPath.row];
    
    NSString *keyToBeChanged = [arrayOfsettingsKeys objectAtIndex:indexPath.section];
    [mainSetingsDictionary removeObjectForKey:keyToBeChanged];
    [mainSetingsDictionary setObject:sectionArray forKey:keyToBeChanged];
    [arrayOfsettings removeObjectAtIndex:indexPath.section];
    [arrayOfsettings insertObject:sectionArray atIndex:indexPath.section];
    [AppSettings wrightSettignsFromJSON:mainSetingsDictionary];
}

- (void) textFieldValueUpdatedDoneWithTextWithCell  : (RFTextFTableViewCell *) cell : (NSString *) string {
    
    [self textFieldValueUpdatedWithTextWithCell : cell : string];
    [self.view endEditing:YES];
    [AppSettings wrightSettignsFromJSON:mainSetingsDictionary];
    NSIndexPath *indexPath = [self.settingsTableView indexPathForCell:cell];
    NSIndexPath *nextIndexPath =  [NSIndexPath indexPathForRow:indexPath.row + 1 inSection:indexPath.section];
    RFTextFTableViewCell *nextCell = (RFTextFTableViewCell *)[self.settingsTableView cellForRowAtIndexPath:nextIndexPath];
    if ([nextCell isKindOfClass: [RFTextFTableViewCell class]] && !nextCell.isTypeList) {
        
        [nextCell.theTextField becomeFirstResponder];
    }else {
        [self.settingsTableView reloadData];
    }
}

-(void) scollTableViewTillCell : (RFTextFTableViewCell *) cell {
            
    
    [UIView animateWithDuration:0.3
                          delay:0
                        options: UIViewAnimationOptionCurveLinear | UIViewAnimationOptionCurveEaseIn animations:^
     {
        NSIndexPath *indexPath = [self.settingsTableView indexPathForCell:cell];
        [self.settingsTableView scrollToRowAtIndexPath:indexPath atScrollPosition:UITableViewScrollPositionMiddle animated:NO];
        
        CGPoint pointInTable = [cell.theTextField.superview convertPoint:cell.theTextField.frame.origin toView:self.settingsTableView];
        CGPoint contentOffset = self.settingsTableView.contentOffset;
        contentOffset.y = (pointInTable.y - cell.theTextField.inputAccessoryView.frame.size.height - 200);
        [self.settingsTableView setContentOffset:contentOffset animated:NO];
    }completion:^(BOOL finished)
     {
        
    }];
}


-(void) switchValueUpdatedForCell:(RFSwitchTableViewCell *)cell {
    
    NSIndexPath *indexPath = [self.settingsTableView indexPathForCell:cell];
    NSMutableArray *sectionArray = [[NSMutableArray alloc] initWithArray:[arrayOfsettings objectAtIndex:indexPath.section]];
    NSMutableDictionary *currentDict = [[NSMutableDictionary alloc] initWithDictionary:[sectionArray objectAtIndex:indexPath.row]];
    [sectionArray removeObjectAtIndex:indexPath.row];
    NSString *value = @"YES";
    if (!cell.theSwitch.isOn) {
        value = @"NO";
    }
    [[NSUserDefaults standardUserDefaults] setObject:value forKey: [currentDict valueForKey:@"pref_key"]];
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    [currentDict setValue:value forKey:cell.propertyKeylabel.text];
    [sectionArray insertObject:currentDict atIndex:indexPath.row];
    NSString *keyToBeChanged = [arrayOfsettingsKeys objectAtIndex:indexPath.section];
    [mainSetingsDictionary removeObjectForKey:keyToBeChanged];
    [mainSetingsDictionary setObject:sectionArray forKey:keyToBeChanged];
    [arrayOfsettings removeObjectAtIndex:indexPath.section];
    [arrayOfsettings insertObject:sectionArray atIndex:indexPath.section];
    [self.view endEditing:YES];
    [AppSettings wrightSettignsFromJSON:mainSetingsDictionary];
    [self.settingsTableView reloadData];
}

-(void) cellWithTypeListIsPressedWithValues : (NSArray *) list andTextF : (UITextField *) textF {
    
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:NSLocalizedString(@"Select",nil) message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    __block NSString *selectedString = textF.text;
    
    for (NSString *item in list) {
        UIAlertAction *anAction = [UIAlertAction actionWithTitle:item style:UIAlertActionStyleDefault handler:^(UIAlertAction * action){
            selectedString  = item;
            textF.text = item;
        }];
        
        [alert addAction:anAction];
    }
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * action){
        // Other action
    }];
    [alert addAction:cancelAction];
    if (alert.popoverPresentationController != nil) {
           alert.popoverPresentationController.sourceView = self.view;
           alert.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           alert.popoverPresentationController.permittedArrowDirections = 0;
    }
    [self presentViewController:alert animated:YES completion:nil];
}


-(void) toggleSection: (CollapsibleTableViewHeader *) header : (NSInteger) section {
    for (CollapsibleTableViewHeader *allHeaders in arrayOfSections) {
        if(![header isEqual:allHeaders]) {
            [allHeaders setCollapsed: YES];
        }
    }
    [header setCollapsed: !header.isCollapsed];
//    NSIndexSet *sectionS = [NSIndexSet indexSetWithIndex:section];
//    [self.settingsTableView reloadSections:sectionS withRowAnimation:UITableViewRowAnimationAutomatic];
    [self.settingsTableView reloadData];
}

- (void) orientationChanged:(NSNotification *)note
{
    AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];
    if (appdelegate.selectedPlatformType == AOPlatFormType_OCEANA) {
        [self changeSettingsForConfig : 0];
    } else {        
        [self changeSettingsForConfig : 1];
    }
}


@end
