//
//  NetworkListener.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//
//

#import <Foundation/Foundation.h>
#import "NetworkListener.h"
#import "Logging.h"

@implementation NetworkListener

NetworkStatus oldStatus = ReachableViaWiFi;
Reachability *reachability;

+ (id) getInstance {
    static NetworkListener *listener = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        listener = [[self alloc] init];
    });
    return listener;
}

- (void)startListening {
    if(reachability == nil){
        [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(checkNetworkCoverage:)
                                                     name:kReachabilityChangedNotification object:nil];
        reachability = [Reachability reachabilityForInternetConnection];
        [reachability startNotifier];
        
        [self checkNetworkCoverage:nil];
    }
}

-(void) stopListening {
    if(reachability != nil){
        [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
        [reachability stopNotifier];
        [[NSNotificationCenter defaultCenter] removeObserver:self];
    }
    reachability = nil;
}

-(void) checkNetworkCoverage:(NSNotification *)notice {
    NetworkStatus status = [reachability currentReachabilityStatus];
    if(oldStatus != status){
        if(status == NotReachable)
        {
            [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
            
            UIAlertController *alert = [UIAlertController
                                        alertControllerWithTitle:@"Network Error"
                                        message:@"The Network is Unreachable. Please Check Your Internet Connection"
                                        preferredStyle:UIAlertControllerStyleAlert];
            UIAlertAction *okButton = [UIAlertAction
                                       actionWithTitle:@"OK"
                                       style:UIAlertActionStyleDefault
                                       handler:^(UIAlertAction * _Nonnull action) {
                                       }];
            [alert addAction:okButton];
            
            id rootViewController = [UIApplication sharedApplication].delegate.window.rootViewController;
            if ([rootViewController isKindOfClass:[UINavigationController class]]) {
                rootViewController = ((UINavigationController *)rootViewController).viewControllers.firstObject;
            }
            [rootViewController presentViewController:alert animated:YES completion:nil];
            
        }
        else if (status == ReachableViaWiFi)
        {
            [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
        }
        else if (status == ReachableViaWWAN)
        {
            [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
            
            UIAlertController *alert = [UIAlertController
                                        alertControllerWithTitle:@"Network Issue"
                                        message:@"You are connected using 3G/4G/LTE. Calls may be unstable"
                                        preferredStyle:UIAlertControllerStyleAlert];
            UIAlertAction *okButton = [UIAlertAction
                                       actionWithTitle:@"OK"
                                       style:UIAlertActionStyleDefault
                                       handler:^(UIAlertAction * _Nonnull action) {
                                       }];
            [alert addAction:okButton];
            
            id rootViewController = [UIApplication sharedApplication].delegate.window.rootViewController;
            if ([rootViewController isKindOfClass:[UINavigationController class]]) {
                rootViewController = ((UINavigationController *)rootViewController).viewControllers.firstObject;
            }
            [rootViewController presentViewController:alert animated:YES completion:nil];
        }
    }
    oldStatus = status;
}

- (void)dealloc {
    [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
    [self stopListening];
}


@end
