//
//  RFTextFTableViewCell.h
//  OceanaReferenceClient
//
//  Created by Mohan on 08/05/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import <UIKit/UIKit.h>

@class RFTextFTableViewCell;

NS_ASSUME_NONNULL_BEGIN

@protocol RFCellWithTextFDelegate <NSObject>

-(void) textFieldValueUpdatedWithTextWithCell : (RFTextFTableViewCell *) cell : (NSString *) string;
-(void) textFieldValueUpdatedDoneWithTextWithCell : (RFTextFTableViewCell *) cell : (NSString *) string;
-(void) scollTableViewTillCell : (RFTextFTableViewCell *) cell;

@end

@interface RFTextFTableViewCell : UITableViewCell <UITextFieldDelegate>
@property (weak, nonatomic) IBOutlet UILabel *propertyKeyLabel;
@property (weak, nonatomic) IBOutlet UITextField *theTextField;
@property (assign, nonatomic) BOOL isTypeList;
@property (assign, nonatomic) NSArray *arrayOfalues;

@property (weak, nonatomic) id <RFCellWithTextFDelegate> textFDelegate;

@end

NS_ASSUME_NONNULL_END
