//
//  VideoCallView.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import <Foundation/Foundation.h>
#import "VideoCallView.h"
#import "RightSideBarViewController.h"
#import "MenuViewController.h"
#import "Logging.h"
#import "AVFoundation/AVFoundation.h"
#import "AppSettings.h"
#import "RCCallStatsTableViewController.h"
#import "RCVideoCallStatsViewController.h"
#import "GraphStatsViewController.h"
#import "AppDelegate.h"

@interface VideoCallView(){
    BOOL isDTMFShowing, isVideoViewSwitched;
}
@property UIImage* audioOn;
@property UIImage* audioOff;
@property UIImage* videoOn;
@property UIImage* videoOff;
@property UIImage* videoSwitchOff;
@property UIImage* videoSwitchOn;
@property UIImage* videoAdd;
@property UIImage* videoRemove;

@property UIImage* showDTMF;
@property UIImage* hideDTMF;

@property UIImage* hold;
@property UIImage* unhold;
@property UIImage* speaker_on;
@property UIImage* speaker_off;
@property UIImage* bluetooth;
@property (weak, nonatomic) IBOutlet UIImageView *avayaLogoImageView;
@property (nonatomic, strong)AOVideoDetails *currentVideoDetails;
@property (nonatomic, strong)AOAudioDetails *currentAudioDetails;
@property (nonatomic, weak) id<AOCallQualityChangeDelegate> callQualityChangeDelegate;
@property (weak, nonatomic) IBOutlet UIButton *menuButton;
@property (weak, nonatomic) IBOutlet UILabel *videoStateLabel;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *dtmfViewConstraint;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *remoteViewWidthConstraint;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *remoteViewHeightConstraint;
@property (weak, nonatomic) IBOutlet UIView *mainCallViewContainer;
@property (weak, nonatomic) IBOutlet AVRoutePickerView *audioRouteButton;

#pragma mark- New UI

@property (weak, nonatomic) IBOutlet UIView *controlsContainerView;
@property (weak, nonatomic) IBOutlet UIButton *audioMuteButton;
@property (weak, nonatomic) IBOutlet UIButton *dtmfButton;
@property (weak, nonatomic) IBOutlet UIButton *holdButton;
@property (weak, nonatomic) IBOutlet UIButton *localVideoMuteButton;
@property (weak, nonatomic) IBOutlet UIButton *remoteVideoMuteButton;
@property (weak, nonatomic) IBOutlet UIButton *switchCameraButton;
@property (weak, nonatomic) IBOutlet UILabel *callStateLabel;
@property (weak, nonatomic) IBOutlet UILabel *timeElaspedLabel;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *remoteVideoViewBottomC;
@property (assign) BOOL isInLandscape;
@property (assign) BOOL isContainerViewHidden;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *localViewBottomConstraint;
@property (weak, nonatomic) IBOutlet UIProgressView *emosProgressBar;
@property (weak, nonatomic) IBOutlet UILabel *eMOSCOuntLabel;
@property (weak, nonatomic) IBOutlet UIView *emosView;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *vwLocalWidthConstraint;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *vwLocalHeightContraints;
@property (weak, nonatomic) IBOutlet UIImageView *netwotkQualityImageView;
@end

@implementation VideoCallView : UIViewController

NSTimer* videoCallTimer;
NSTimer* landScapeVIewAnimate;
NSString* callState;
NSString* const MAIN_MENU_SEGUE = @"returnToMainMenu";
AAWGTokenRequest* aawgVideoTokenRequest;
NSString* videoToken;


- (void)viewDidLoad
{
    [super viewDidLoad];
    isVideoViewSwitched = false;
    self.gradientView = [[GradientView alloc] initWithFrame:self.view.bounds];
    self.gradientView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    self.gradientView.layer.colors = [NSArray arrayWithObjects:(id)[[UIColor colorWithRed:(86/255.0) green:(90/255.0) blue:(92/255.0) alpha:1] CGColor], (id)[[UIColor colorWithRed:(218/255.0) green:(41/255.0) blue:(28/255.0) alpha:1] CGColor], nil];
    [self.view insertSubview:self.gradientView atIndex:0];
    
    [self checkPermissions];
    self.vwDTMF.hidden = true;
    [self.btShowDTMF setImage:self.showDTMF forState:UIControlStateNormal];
    
    [self createOptionMenuForThisScreen];
    aawgVideoTokenRequest = [[AAWGTokenRequest alloc]init];
    [self getAAWGToken];
    callState = @"Idle";
    
    
    UITapGestureRecognizer *singleTap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hidetheDTMFView)];
    singleTap.numberOfTouchesRequired = 1;
    singleTap.numberOfTapsRequired = 1;
    [self.mainCallViewContainer addGestureRecognizer:singleTap];
    
    AVRoutePickerView *routePickerView = [[AVRoutePickerView alloc] initWithFrame:CGRectMake(0.0f, 30.0f, 30.0f, 30.0f)];
    routePickerView.activeTintColor = [UIColor whiteColor];
    self.audioRouteButton.activeTintColor = [UIColor whiteColor];
    [self initAnimationTimerFoLandscape];
    
    UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(switchVideoViews)];
    tapGesture.numberOfTouchesRequired = 1;
    tapGesture.numberOfTapsRequired = 1;
    [self.vwLocal addGestureRecognizer:tapGesture];

}

-(void) viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];
    [[NSNotificationCenter defaultCenter]
     addObserver:self selector:@selector(orientationChanged:)
     name:UIDeviceOrientationDidChangeNotification
     object:[UIDevice currentDevice]];
    [self orientationChanged:nil];
}

-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}

- (void)dealloc
{
    self.oceanaVideoClient = nil;
}

- (void)getAAWGToken
{
    [aawgVideoTokenRequest getAuthenticationToken:[AppSettings getTokenServiceAddress] displayName:[AppSettings getDisplayName] fromAddress:[AppSettings getUsername] andNotify:self];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(void) switchVideoViews {
    
//    CGRect tempFrame = self.vwLocal.frame;
//    self.vwLocal.frame = self.vwRemote.frame;
//    self.vwRemote.frame = tempFrame;
// or
//    [self.oceanaVideoClient toggleVideoEnabled];
//    if (!isVideoViewSwitched) {
//        [self.oceanaVideoClient setRemoteView:self.vwLocal];
//        [self.oceanaVideoClient setLocalView:self.vwRemote];
//    }else {
//        [self.oceanaVideoClient setRemoteView:self.vwRemote];
//        [self.oceanaVideoClient setLocalView:self.vwLocal];
//    }
//    isVideoViewSwitched = !isVideoViewSwitched;
//    [self.oceanaVideoClient toggleVideoEnabled];
}

/**
 *  Shows the DTMF View
 */
- (IBAction)btDTMF_Pressed:(id)sender
{
    if ([self.btShowDTMF isSelected]) {
        [self.btShowDTMF setImage:self.hideDTMF forState:UIControlStateNormal];
        [self showDTMFView];
    } else {
        [self.btShowDTMF setImage:self.showDTMF forState:UIControlStateSelected];
        [self hideDTMFView];
    }
    [self.btShowDTMF setSelected: !self.btShowDTMF.isSelected];
}

- (void) showDTMFView
{
    
    [self animateCOntrolsContainerViewToHide:YES];
    [UIView transitionWithView:self.vwControls
                      duration:0.3
                       options:UIViewAnimationOptionTransitionCrossDissolve
                    animations:^{
        self.vwDTMF.hidden = NO;
        self.vwControls.alpha = 0.0;
        self.btHangup.alpha = 0.0;
    }   completion:^(BOOL finished) {
        [self.mainCallViewContainer bringSubviewToFront:self.vwDTMF];
    }];
}

- (void) hideDTMFView
{
    [self animateCOntrolsContainerViewToHide:NO];
    [UIView transitionWithView:self.vwControls
                      duration:0.3
                       options:UIViewAnimationOptionTransitionCrossDissolve
                    animations:^{
        self.vwControls.alpha = 1.0;
        self.btHangup.alpha = 1.0;
        self.vwDTMF.hidden = YES;
    }   completion:^(BOOL finished) {
        [self.mainCallViewContainer bringSubviewToFront:self.vwDTMF];
    }];
}

- (IBAction)btDTMFTone_Pressed:(id)sender
{
    
    UIButton* button = (UIButton*)sender;
    long digit = [button tag];
    switch (digit) {
        case 0:
            [self.oceanaVideoClient sendDTMF:AODTMFToneZero];
            break;
        case 1:
            [self.oceanaVideoClient sendDTMF:AODTMFToneOne];
            break;
        case 2:
            [self.oceanaVideoClient sendDTMF:AODTMFToneTwo];
            break;
        case 3:
            [self.oceanaVideoClient sendDTMF:AODTMFToneThree];
            break;
        case 4:
            [self.oceanaVideoClient sendDTMF:AODTMFToneFour];
            break;
        case 5:
            [self.oceanaVideoClient sendDTMF:AODTMFToneFive];
            break;
        case 6:
            [self.oceanaVideoClient sendDTMF:AODTMFToneSix];
            break;
        case 7:
            [self.oceanaVideoClient sendDTMF:AODTMFToneSeven];
            break;
        case 8:
            [self.oceanaVideoClient sendDTMF:AODTMFToneEight];
            break;
        case 9:
            [self.oceanaVideoClient sendDTMF:AODTMFToneNine];
            break;
        case 10:
            [self.oceanaVideoClient sendDTMF:AODTMFToneStar];
            break;
        case 11:
            [self.oceanaVideoClient sendDTMF:AODTMFTonePound];
            break;
        case 12:
            [self.oceanaVideoClient sendDTMF:AODTMFToneA];
            break;
        case 13:
            [self.oceanaVideoClient sendDTMF:AODTMFToneB];
            break;
        case 14:
            [self.oceanaVideoClient sendDTMF:AODTMFToneC];
            break;
        case 15:
            [self.oceanaVideoClient sendDTMF:AODTMFToneD];
            break;
        default:
            [Logging logWarn:@"Unknown tag received to send DTMF: %d", digit];
            break;
    }
}

- (IBAction)btHangup_Pressed:(id)sender
{
    [self.oceanaVideoClient endInteraction];
}

- (IBAction)btHold_Pressed:(id)sender {
    [self.oceanaVideoClient toggleHold];
}

/**
 * Swap Camera Button Press Handler
 */
- (IBAction) btSwapCamera_Pressed:(id)sender {
    [self.oceanaVideoClient switchCamera];
    [self toggleSwitchCameraButton];
}

-(void) toggleSwitchCameraButton {
    //Change the button appearance
    if ([self.btSwitchCamera isSelected]) {
        [self.btSwitchCamera setImage:self.videoSwitchOff forState:UIControlStateNormal];
    } else {
        [self.btSwitchCamera setImage:self.videoSwitchOn forState:UIControlStateSelected];
    }
    [self.btSwitchCamera setSelected: !self.btSwitchCamera.isSelected];
}

/**
 * Enable / Disable Video press Handler
 */
- (IBAction) btEnableVideo_Pressed:(id)sender {
    [self.oceanaVideoClient toggleVideoEnabled];
}

/**
 * Sets the video enabled buton to the given select state
 */
-(void) toggleVideoEnabledButton {
    //Change the button appearance
    
    if(!self.remoteVideoMuteButton.isSelected){
        [self.remoteVideoMuteButton setImage: [UIImage imageNamed:@"ic_remote_video_off"] forState:UIControlStateSelected];
        //Show the video control buttons
        self.localVideoMuteButton.enabled = NO;
        self.switchCameraButton.enabled = NO;
        self.vwRemote.hidden = YES;
        self.vwLocal.hidden = YES;
        self.avayaLogoImageView.hidden = NO;
    }
    else  {
        [self.remoteVideoMuteButton setImage:[UIImage imageNamed:@"ic_remote_video_on"] forState:UIControlStateNormal];
        //hide the video mute and swap buttons
        self.localVideoMuteButton.enabled = YES;
        self.switchCameraButton.enabled = YES;
        self.vwRemote.hidden = NO;
        self.vwLocal.hidden = NO;
        self.avayaLogoImageView.hidden = YES;
    }
    [self.remoteVideoMuteButton setSelected: !self.remoteVideoMuteButton.isSelected];
    
    //    if(!self.btEnableVideo.isSelected){
    //        [self.btEnableVideo setImage:self.videoRemove forState:UIControlStateSelected];
    //        //Show the video control buttons
    //        self.btMuteVideo.hidden = NO;
    //        self.btSwitchCamera.hidden = NO;
    //        self.vwRemote.hidden = NO;
    //        self.vwLocal.hidden = NO;
    //    }
    //    else  {
    //        [self.btEnableVideo setImage:self.videoAdd forState:UIControlStateNormal];
    //        //hide the video mute and swap buttons
    //        self.btMuteVideo.hidden = YES;
    //        self.btSwitchCamera.hidden = YES;
    //        self.vwRemote.hidden = YES;
    //        self.vwLocal.hidden = YES;
    //    }
    //    [self.btEnableVideo setSelected: !self.btEnableVideo.isSelected];
}

- (IBAction) btToggleAudioMute_Pressed:(id)sender
{
    [self.oceanaVideoClient toggleMuteAudio];
    [self.oceanaVideoClient readVideoDetailsWithCompletionHandler:^(AOVideoDetails *videoDetails) {
    }];
    [self.oceanaVideoClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
    }];
}

- (void) toggleAudioMuteButton:(BOOL)isMuted
{
    if (isMuted) {
        //        [self.btMuteAudio setImage:self.audioOff forState:UIControlStateNormal];
        [self.audioMuteButton setImage:[UIImage imageNamed:@"ic_unmute_button"] forState:UIControlStateNormal];
    } else {
        //        [self.btMuteAudio setImage:self.audioOn forState:UIControlStateNormal];
        [self.audioMuteButton setImage:[UIImage imageNamed:@"ic_mute_button"] forState:UIControlStateNormal];
    }
    //    [self.btMuteAudio setSelected:!self.btMuteAudio.isSelected];
    [self.audioMuteButton setSelected:!self.btMuteAudio.isSelected];
}

- (IBAction) btToggleVideoMute_Pressed:(id)sender {
    [self.oceanaVideoClient toggleMuteVideo];
}

-(void) toggleVideoMuteButton:(BOOL)isMuted {
    //    if (isMuted) {
    //        [self.btMuteVideo setImage:self.videoOff forState:UIControlStateNormal];
    //        self.vwLocal.hidden = YES;
    //    } else {
    //        [self.btMuteVideo setImage:self.videoOn forState:UIControlStateNormal];
    //        self.vwLocal.hidden = NO;
    //    }
    //    [self.btMuteVideo setSelected:!self.btMuteVideo.isSelected];
    if (isMuted) {
        [self.localVideoMuteButton setImage: [UIImage imageNamed:@"ic_self_video_on"] forState:UIControlStateNormal];
        self.vwLocal.hidden = YES;
    } else {
        [self.localVideoMuteButton setImage: [UIImage imageNamed:@"ic_self_video_off"] forState:UIControlStateNormal];
        self.vwLocal.hidden = NO;
    }
    [self.localVideoMuteButton setSelected:!self.localVideoMuteButton.isSelected];
}

- (void) setCallTimer
{
    if(videoCallTimer != nil){
        [videoCallTimer invalidate];
    }
    videoCallTimer = [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(callTimerFired:) userInfo:nil repeats:YES];
}

- (void) callTimerFired:(NSTimer*)timer
{
    long timeElapsed = [self.oceanaVideoClient getCallTimeElapsed];
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
    if ([self.oceanaVideoClient isHeld]) {
          callState = NSLocalizedString(@"Held",nil);
      }
    timeElapsed = timeElapsed / 1000;
    long mins = timeElapsed / 60;
    long secs = timeElapsed % 60;
    NSString* timeStamp;
    if(secs > 9){
        timeStamp = [NSString stringWithFormat:@"%ld:%ld",mins, secs];
    } else {
        timeStamp = [NSString stringWithFormat:@"%ld:0%ld",mins, secs];
    }
    if (![self.lbState.text isEqualToString:@"Connecting...."]) {
        self.lbState.text = [NSString stringWithFormat:@"%@", callState];
        self.callStateLabel.text = [[NSString stringWithFormat:@"%@", callState] uppercaseString];
    }
    //    self.lbTimer.text = [NSString stringWithFormat:@"Elapsed Time: (%@)",timeStamp];
    self.timeElaspedLabel.text = [NSString stringWithFormat:@"(%@)",timeStamp];
    if ([self.oceanaVideoClient isVideoEnabled]) {
        self.videoStateLabel.text = @"Video Enabled";
    } else {
        self.videoStateLabel.text = @"Video Disabled";
    }
    
    if ([self.oceanaVideoClient getInteractionState] == AOInteractionStateEstablished) {
        self.emosView.hidden = NO;
        self.netwotkQualityImageView.hidden = NO;
    //[self updateTheCallStatesticsForVideoCall];//Moved MOS logic to SDK
    }
}

//AuthenticationToken Delegate Methods

- (void) getAAWGTokenSuccessful:(NSString *)token
{
    [Logging logDebug:@"%s Token: %@", __PRETTY_FUNCTION__, token];
    videoToken = token;
    OceanaVideoClient* oceanaVideoClient = [[OceanaVideoClient alloc] init];
    self.oceanaVideoClient = oceanaVideoClient;
    [self.oceanaVideoClient setVideoDelegate:self];
    [self.oceanaVideoClient setConnectionDelegate:self];
    [self.oceanaVideoClient configureInteraction];
    [self.oceanaVideoClient setAuthorizationToken:videoToken];
    [self.oceanaVideoClient startInteraction];
    
}

- (void) getAAWGTokenFailed:(NSError *)error
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [Logging logError:@"%s Error: %@",__PRETTY_FUNCTION__, error];
        
        UIAlertController *alert = [UIAlertController
                                    alertControllerWithTitle:NSLocalizedString(@"Token Request Error",nil)
                                    message:[error localizedDescription]
                                    preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction *okButton = [UIAlertAction
                                   actionWithTitle:NSLocalizedString(@"OK",nil)
                                   style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * _Nonnull action) {
            [self performSegueWithIdentifier:@"returnToMainMenu" sender:self];
        }];
        [alert addAction:okButton];
        [self presentViewController:alert animated:YES completion:nil];
    });
}

//AOConnectionListener Delegate Methods

- (void)interactionServiceConnecting
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    self.lbState.text = [NSString stringWithFormat:NSLocalizedString(@"Connecting....",nil)];
}

- (void)interactionServiceConnected
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    self.lbState.text = [NSString stringWithFormat:@"%@", callState];
}

- (void)interactionServiceDisconnectedWithError:(NSError *)error
{
    [Logging logInfo:@"%s Error: ", __PRETTY_FUNCTION__];
}


//AOAudioInteraction Delegate Methods

- (void)interactionInitiating
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
}

-(void)interactionActive
{
    self.avayaLogoImageView.hidden = YES;
    self.vwRemote.hidden = NO;
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
    [self.oceanaVideoClient setLocalView:self.vwLocal];
    [self.oceanaVideoClient setRemoteView:self.vwRemote];
    [self.vwRemote bringSubviewToFront:self.vwLocal];
    [self.oceanaVideoClient selectCamera:AOCameraTypeFront];
    [self orientationChanged:nil];
}

- (void)interactionFailed:(NSError *)error
{
    self.avayaLogoImageView.hidden = NO;
    [Logging logInfo:@"%s Error: %@", __PRETTY_FUNCTION__, error];
    if(videoCallTimer != nil){
        [videoCallTimer invalidate];
        self.lbState.text = nil;
        callState = nil;
    }
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
    [self showError:error forMethod:NSLocalizedString(@"Start Interaction",nil)];
    
}

-(void)interactionRemoteAlerting
{
    [self orientationChanged:nil];
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
    [self setCallTimer];
}

-(void)interactionEnded
{
    self.avayaLogoImageView.hidden = NO;
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    if(videoCallTimer != nil){
        [videoCallTimer invalidate];
        self.lbState.text = nil;
        callState = nil;
    }
    callState = [VideoCallView convertSessionState:[self.oceanaVideoClient getInteractionState]];
    [self.oceanaVideoClient discard];
}
-(void)interactionAudioMuteStatusChanged:(BOOL)isMuted
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self toggleAudioMuteButton:isMuted];
}

- (void)interactionVideoMuteStatusChanged:(BOOL)isMuted
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self toggleVideoMuteButton:isMuted];
}

- (void)interactionVideoEnabledStatusChanged:(BOOL)isEnabled
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self toggleVideoEnabledButton];
}

- (void)holdComplete
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    //    [self.btHold setImage:self.unhold forState:UIControlStateNormal];
    [self.holdButton setImage:[UIImage imageNamed:@"ic_unhold"] forState:UIControlStateNormal];
}

- (void)unholdComplete
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    //    [self.btHold setImage:self.hold forState:UIControlStateNormal];
    [self.holdButton setImage:[UIImage imageNamed:@"ic_hold"] forState:UIControlStateNormal];
}

- (void)discardComplete {
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self performSegueWithIdentifier:@"returnToMainMenu" sender:self];
}

- (void)onInteractionQualityChanged:(AOCallQuality) quality {
    [self renderCallQuality:quality];
}

//    @Override
//    public void onInteractionVideoDisabledBelowThreshold(AOCallQuality callQuality) {
//        mLogger.d("VideoInteraction:onInteractionVideoDisabledBelowThreshold, state - " + callQuality.getValue());
//
//        Toast.makeText(this,R.string.video_disabled_due_to_unacceptable_quality,Toast.LENGTH_SHORT).show();
//    }

//    @Override
//    public void onInteractionVideoCanBeEnabledThresholdCrossed(AOCallQuality callQuality) {
//        mLogger.d("VideoInteraction:onInteractionVideoCanBeEnabledThresholdCrossed, state - " + callQuality.getValue());
//
//        Toast.makeText(this,R.string.video_can_be_enabled_threshold_crossed,Toast.LENGTH_SHORT).show();
//        if (mVideoInteraction != null) {
//            mVideoInteraction.enableVideo(true);
//        }
//
//    }
/**
 * Converts a session state to a NSString
 */
+ (NSString* ) convertSessionState: (AOInteractionState) state
{
    switch (state) {
        case AOInteractionStateEnded:
            return NSLocalizedString(@"Ended",nil);
        case AOInteractionStateEstablished:
            return NSLocalizedString(@"Established",nil);
        case AOInteractionStateFailed:
            return NSLocalizedString(@"Failed",nil);
        case AOInteractionStateInitiating:
            return NSLocalizedString(@"Initiating",nil);
        case AOInteractionStateRemoteAlerting:
            return NSLocalizedString(@"Alerting",nil);
        case AOInteractionStateIdle:
            return NSLocalizedString(@"Idle",nil);
        default:
            return [NSString stringWithFormat: @"Tried to convert non convertable state %ld", (long)state];
    }
}

/**
 * Utility method to pop an alert with a given error and title
 */
- (void) showError:(NSError*)error forMethod:(NSString*)methodName
{
    NSString* errorMessage =[error localizedFailureReason];
    if(errorMessage == nil || [errorMessage length] < 1){
        errorMessage = [error localizedDescription];
        
        if(errorMessage == nil || [errorMessage length] < 1){
            errorMessage = [error description];
        }
    }
    
    [self showError:methodName withMessage:errorMessage];
}

- (void) showError:(NSString*)method withMessage:(NSString*) message
{
    UIAlertController *alert = [UIAlertController
                                alertControllerWithTitle:[NSString stringWithFormat:@"%@: %@",NSLocalizedString(@"Error",nil) ,method]
                                message:message
                                preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *okButton = [UIAlertAction
                               actionWithTitle:NSLocalizedString(@"OK",nil)
                               style:UIAlertActionStyleDefault
                               handler:^(UIAlertAction * _Nonnull action) {
        [self.oceanaVideoClient discard];
    }];
    [alert addAction:okButton];
    [self presentViewController:alert animated:YES completion:nil];
}

- (void)checkPermissions
{
    AVAudioSessionRecordPermission permissionStatus = [[AVAudioSession sharedInstance] recordPermission];
    AVAuthorizationStatus status = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeVideo];
    
    switch (permissionStatus) {
        case AVAudioSessionRecordPermissionUndetermined: {
            [Logging logInfo:@"%s Microphone Permission Undetermined", __PRETTY_FUNCTION__];
            [[AVAudioSession sharedInstance] requestRecordPermission:^(BOOL granted) {
                if (granted) {
                    [Logging logInfo:@"%s Microphone Permission Granted", __PRETTY_FUNCTION__];
                }
                else {
                    [self showError:NSLocalizedString(@"Permissions Denied",nil) withMessage:NSLocalizedString(@"Microphone Permissions Required",nil)];
                }
            }];
            break;
        }
        case AVAudioSessionRecordPermissionDenied:
            [self showError:NSLocalizedString(@"Permissions Denied",nil) withMessage:NSLocalizedString(@"Microphone Permissions Required",nil)];
            break;
        case AVAudioSessionRecordPermissionGranted:
            [Logging logInfo:@"%s Microphone Permission Granted", __PRETTY_FUNCTION__];
            break;
        default:
            break;
    }
    
    if(status == AVAuthorizationStatusAuthorized){
        [Logging logInfo:@"%s Camera Permission Granted", __PRETTY_FUNCTION__];
    } else if(status == AVAuthorizationStatusDenied){
        [Logging logInfo:@"%s Camera Permission Denied", __PRETTY_FUNCTION__];
        [self showOneWayVideoWarning];
    } else if(status == AVAuthorizationStatusRestricted){
        [Logging logInfo:@"%s Camera Permission Restricted", __PRETTY_FUNCTION__];
    } else if(status == AVAuthorizationStatusNotDetermined){
        [Logging logInfo:@"%s Camera Permission Not Determined", __PRETTY_FUNCTION__];
        [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {
            if(granted){
                [Logging logInfo:@"%s Camera Permission Granted", __PRETTY_FUNCTION__];
            } else {
                [self showOneWayVideoWarning];
            }
        }];
    }
}

- (void)showOneWayVideoWarning
{
    UIAlertController *alert = [UIAlertController
                                alertControllerWithTitle:[NSString stringWithFormat:NSLocalizedString(@"Permissions Denied",nil)]
                                message:NSLocalizedString(@"Camera Permission Denied. One Way Video Only",nil)
                                preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *okButton = [UIAlertAction
                               actionWithTitle:NSLocalizedString(@"OK",nil)
                               style:UIAlertActionStyleDefault
                               handler:^(UIAlertAction * _Nonnull action) {
        self.btMuteVideo.hidden = YES;
        self.vwLocal.hidden = YES;
        self.btSwitchCamera.hidden = YES;
        self.btEnableVideo.hidden = YES;
    }];
    [alert addAction:okButton];
    [self presentViewController:alert animated:YES completion:nil];
}


#pragma mark- Option Menu

-(void) showCallStatScreen {
    
    UITabBarController *tbvc = (UITabBarController *)[self.storyboard instantiateViewControllerWithIdentifier:@"call_stats_tabbar"];
    UINavigationController * nv1 = (UINavigationController*)[[tbvc viewControllers] objectAtIndex:0];
    UINavigationController * nv2 = (UINavigationController*)[[tbvc viewControllers] objectAtIndex:1];
    RCCallStatsTableViewController * vc1 = (RCCallStatsTableViewController*)[[nv1 viewControllers] objectAtIndex:0];
    RCVideoCallStatsViewController * vc2 = (RCVideoCallStatsViewController*)[[nv2 viewControllers] objectAtIndex:0];
    vc1.oceanaVideoClient = self.oceanaVideoClient;
    vc2.oceanaVideoClient = self.oceanaVideoClient;
    [self presentViewController:tbvc animated:YES completion: nil];
}

-(void) showCallStatScreenWithGraph {
    dispatch_async(dispatch_get_main_queue(), ^{
        UINavigationController *graphNav = (UINavigationController *)[self.storyboard instantiateViewControllerWithIdentifier:@"call_stats_with_graph"];
        GraphStatsViewController * vc1 = (GraphStatsViewController*)[[graphNav viewControllers] objectAtIndex:0];
        self.callQualityChangeDelegate = vc1;
        vc1.oceanaVideoClient = self.oceanaVideoClient;
        [self presentViewController:graphNav animated:YES completion: nil];
    });
}

-(void) createOptionMenuForThisScreen {
    
    menuArray = @[ NSLocalizedString(@"Call Statistics", nil), NSLocalizedString(@"Call Statistics Graph", nil)];
    isOptionVisible = NO;
}

- (IBAction)optionMenuPressed:(UIButton *)sender {
    
    UIAlertController *options = [UIAlertController alertControllerWithTitle:@"" message:NSLocalizedString(@"Select",nil) preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction *action = [UIAlertAction actionWithTitle: menuArray.firstObject style: UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self showCallStatScreen];
    }];
    UIAlertAction *action1 = [UIAlertAction actionWithTitle: [NSString stringWithFormat:@"%@", [menuArray objectAtIndex:1]] style: UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
          [self showCallStatScreenWithGraph];
      }];
    UIAlertAction *Cancelaction = [UIAlertAction actionWithTitle: NSLocalizedString(@"Cancel",nil) style: UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    [options addAction:action];
    [options addAction:action1];
    [options addAction:Cancelaction];
    if (options.popoverPresentationController != nil) {
           options.popoverPresentationController.sourceView = self.view;
           options.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           options.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:options animated:YES completion:nil];
}

- (void) orientationChanged:(NSNotification *)note
{
    
    AppDelegate *appDelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];
    CGRect screenRect = [[UIScreen mainScreen] bounds];
    UIDevice * device = note.object;
    if (!device) {
        device = [UIDevice currentDevice];
    }
    switch(device.orientation)
    {
        case UIDeviceOrientationPortrait:
        case UIDeviceOrientationPortraitUpsideDown:
        case UIDeviceOrientationFaceUp:
            /* start special animation */
            self.dtmfViewConstraint.constant = 260;
//            self.remoteVideoViewBottomC.constant = 300;
            [self animateCOntrolsContainerViewToHide:NO];
            //self.vwRemote.center = CGPointMake(self.view.center.x, self.vwRemote.frame.size.height/2);
            self.isInLandscape = NO;
//            self.vwRemote.frame = CGRectMake(0, 0, screenRect.size.width * 3/4, screenRect.size.width);
//            self.vwRemote.frame = CGRectMake(0, 0, screenRect.size.width, screenRect.size.width * 3/4);
            self.remoteViewWidthConstraint.constant = screenRect.size.width;
            self.remoteViewHeightConstraint.constant = screenRect.size.width * 0.60;
            if (appDelegate.currentSelectedVideoRecordOrientation == AOVideoCaptureOrientation_LandscapeOrPortrait) {
                self.vwLocalWidthConstraint.constant = 120 * 0.70;
                self.vwLocalHeightContraints.constant = 120;
            }
            break;
            
        case UIDeviceOrientationLandscapeLeft:
        case UIDeviceOrientationLandscapeRight:
            /* start special animation */
            self.dtmfViewConstraint.constant = 80;
//            self.remoteVideoViewBottomC.constant = 0;
            self.isInLandscape = YES;
//            self.vwRemote.frame = CGRectMake(0, 0, screenRect.size.width, screenRect.size.height);
//            self.vwRemote.frame = CGRectMake(0, 0, screenRect.size.width * 3/4, screenRect.size.width);
//            self.vwRemote.center = CGPointMake(self.view.center.x, self.view.center.y + 20);
//            self.vwRemote.frame = CGRectMake(0, 0, screenRect.size.width, 800);
            self.remoteViewWidthConstraint.constant = screenRect.size.width;
            self.remoteViewHeightConstraint.constant = screenRect.size.height;
            if (appDelegate.currentSelectedVideoRecordOrientation == AOVideoCaptureOrientation_LandscapeOrPortrait) {
                self.vwLocalWidthConstraint.constant = 200;
                self.vwLocalHeightContraints.constant = 110;
            }
            break;
            
        default:
            break;
    };
            
    
    [self.mainCallViewContainer bringSubviewToFront:self.vwDTMF];
}

-(void) hidetheDTMFView {
    if (isDTMFShowing){
        //        [self btDTMF_Pressed:nil];
        [self dtmfButtonPressed: self.dtmfButton];
    }
    [self animateCOntrolsContainerViewToHide : !self.isContainerViewHidden];
}

-(void) hideShowControlsContainer : (BOOL) show {
    
    if (show) {
        
    } else {
        [UIView transitionWithView:self.vwControls
                          duration:0.3
                           options:UIViewAnimationOptionTransitionCrossDissolve
                        animations:^{
            self.vwControls.alpha = 0.0;
        }
                        completion:^(BOOL finished) {
        }];
    }
}

#pragma mark- Updated UI Actions

-(void) initAnimationTimerFoLandscape {
    
    if(landScapeVIewAnimate != nil){
        [landScapeVIewAnimate invalidate];
    }
//    landScapeVIewAnimate = [NSTimer scheduledTimerWithTimeInterval:5 target:self selector:@selector(animateLocalConrolViews) userInfo:nil repeats:YES];
}

-(void) animateLocalConrolViews {
    
    if (self.isInLandscape && self.isContainerViewHidden) {
        [self animateCOntrolsContainerViewToHide: !self.isContainerViewHidden];
    }
}

-(void) animateCOntrolsContainerViewToHide : (BOOL) toHide{
    if (!self.isInLandscape) {
        return;
    }
    if (toHide) {
        [UIView transitionWithView:self.controlsContainerView
                          duration:0.3
                           options:UIViewAnimationOptionTransitionCrossDissolve
                        animations:^{
            self.localViewBottomConstraint.constant = -30 - 150;
        }
                        completion:^(BOOL finished) {
        }];
    } else {
        [UIView transitionWithView:self.controlsContainerView
                          duration:0.3
                           options:UIViewAnimationOptionTransitionCrossDissolve
                        animations:^{
            self.localViewBottomConstraint.constant = -30;
        }
                        completion:^(BOOL finished) {
        }];
    }
    self.isContainerViewHidden = !self.isContainerViewHidden;
}

- (IBAction)muteAudioButtonPressed:(UIButton *)sender {
    
    [self.oceanaVideoClient toggleMuteAudio];
    [self.oceanaVideoClient readVideoDetailsWithCompletionHandler:^(AOVideoDetails *videoDetails) {
    }];
    [self.oceanaVideoClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
    }];
}

- (IBAction)dtmfButtonPressed:(UIButton *)sender {
    
    if (isDTMFShowing) {
        [self hideDTMFView];
        [sender setImage:[UIImage imageNamed:@"ic_dtmf_off"] forState:UIControlStateNormal];
    } else {
        [self showDTMFView];
        [sender setImage:[UIImage imageNamed:@"ic_dtmf_on"] forState:UIControlStateNormal];
    }
    isDTMFShowing =! isDTMFShowing;
    
}

- (IBAction)holdButtonPressed:(UIButton *)sender {
    
    [self.oceanaVideoClient toggleHold];
}

- (IBAction)hangUpButtonPressed:(UIButton *)sender {
    
    [self.oceanaVideoClient endInteraction];
}
- (IBAction)localVideoMuteButtonPressed:(UIButton *)sender {
    [self.oceanaVideoClient toggleMuteVideo];
}
- (IBAction)remoteVideoButtonPressed:(UIButton *)sender {
    [self.oceanaVideoClient toggleVideoEnabled];
}
- (IBAction)switchButtonPressed:(UIButton *)sender {
    [self.oceanaVideoClient switchCamera];
}

#pragma mark- EMOS
/* Moved the MOS logic to SDK*/
/*
- (void) updateTheCallStatesticsForVideoCall {
    if (self.oceanaVideoClient != nil) {
        [self.oceanaVideoClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
            [self.oceanaVideoClient readVideoDetailsWithCompletionHandler:^(AOVideoDetails *videoDetails) {
                    [self getMOSFromTheVideoCallStats:videoDetails :audioDetails];
            }];
        }];
    }
}*/

-(void)renderCallQuality:(AOCallQuality)quality {
    NSString *callQualityRatingResource = @"No_Network";
    NSString *callQualityText = @"";
    if (quality == AOCallQualityExcellent) {
        callQualityRatingResource = @"5";
        callQualityText = @"Excellent";
    } else if (quality == AOCallQualityGood) {
        callQualityRatingResource = @"4";
        callQualityText = @"Good";
    } else if (quality == AOCallQualityFair) {
        callQualityRatingResource = @"3";
        callQualityText = @"Fair";
    } else if (quality == AOCallQualityPoor) {
        callQualityRatingResource = @"2";
        callQualityText = @"Poor";
    } else if (quality == AOCallQualityBad) {
        callQualityRatingResource = @"1";
        callQualityText = @"Bad";
    } else {
        callQualityText = @"No_Network";
//        callQualityRatingResource = R.drawable.ic_networkquality_0;
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        self.eMOSCOuntLabel.text = callQualityText;
        self.netwotkQualityImageView.image = [UIImage imageNamed: [NSString stringWithFormat:@"ic_networkquality_%@",callQualityRatingResource]];
        //self.emosLabelwithImage.text = callQualityText;
    });
}

@end
