//
//  WorkConfig.m
//  OceanaReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import <Foundation/Foundation.h>
#import "WorkConfig.h"
#import "AppSettings.h"
#import "Logging.h"

#define name     @"name"
#define values   @"values"
#define routable   @"routable"

@implementation WorkConfig

- (NSString*)topicBuilder
{
    NSString* topic;
    
    if (![[AppSettings getTopic] isEqualToString:@""]) {
        topic = [AppSettings getTopic];
    }
    return topic;
}

- (NSMutableArray <AOService*>*)serviceMapBuilder
{
    NSMutableArray *services = [[NSMutableArray alloc]init];
    AOService *service = [[AOService alloc]init];
    service.attributes = [self getServiceMapAttributes];
    service.priority = [self checkPriority];
    
    [services addObject:service];

    return services;
}

- (NSMutableArray <AOResource*>*)resourceMapBuilder
{
    NSMutableArray *resources = [[NSMutableArray alloc]init];
    AOResource *resource = [[AOResource alloc]init];
    resource.nativeResourceId = [AppSettings getResourceId];
    resource.sourceName = [AppSettings getSourceName];
    
    [resources addObject:resource];
    
    return resources;
}

- (NSMutableDictionary*) getServiceMapAttributes
{
    NSDictionary *dictA, *dictB, *dictC;
    NSMutableDictionary *service = [NSMutableDictionary dictionary];
    
    if ([[AppSettings getNameAttrOne] isEqual: @"" ] || [[AppSettings getValueAttrOne]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute One Not Set", __PRETTY_FUNCTION__];
    } else {
        dictA = @{[AppSettings getNameAttrOne]: @[[AppSettings getValueAttrOne]],};
        [service addEntriesFromDictionary:dictA];
    }
    if ([[AppSettings getNameAttrTwo] isEqual: @"" ] || [[AppSettings getValueAttrTwo]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute Two Not Set", __PRETTY_FUNCTION__];
    } else {
        dictB = @{[AppSettings getNameAttrTwo]: @[[AppSettings getValueAttrTwo]],};
        [service addEntriesFromDictionary:dictB];
    }
    if ([[AppSettings getNameAttrThree] isEqual: @"" ] || [[AppSettings getValueAttrThree]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute Three Not Set",__PRETTY_FUNCTION__];
    } else {
        dictC = @{[AppSettings getNameAttrThree]: @[[AppSettings getValueAttrThree]]};
        [service addEntriesFromDictionary:dictC];
    }
    
    return service;
}

- (NSString*) checkPriority
{
    NSString* priority;
    
    if ([[AppSettings getPriority] isEqual: @"" ] || [[AppSettings getPriority]isEqualToString:@""]) {
        priority = @"5";
    } else {
        priority = [AppSettings getPriority];
    }
    return priority;
}

/*
 * Alternate method of creating routing attributes.
 * The below mechanism creates a simple work request with the attributes provided
 */
- (NSArray*)attributeBuilder
{
    NSMutableArray *attributeArray;
    NSDictionary *dict1, *dict2, *dict3;
    
    attributeArray = [[NSMutableArray alloc]init];

    if ([[AppSettings getNameAttrOne] isEqual: @"" ] || [[AppSettings getValueAttrOne]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute One Not Set", __PRETTY_FUNCTION__];
    } else {
        dict1 =  [NSDictionary dictionaryWithObjectsAndKeys:
                  [AppSettings getNameAttrOne], name,
                  @[[AppSettings getValueAttrOne]], values,
                  @"true" , routable,
                  nil];
        [attributeArray addObject:dict1];
    }
    if ([[AppSettings getNameAttrTwo] isEqual: @"" ] || [[AppSettings getValueAttrTwo]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute Two Not Set", __PRETTY_FUNCTION__];
    } else {
        dict2 =  [NSDictionary dictionaryWithObjectsAndKeys:
                  [AppSettings getNameAttrTwo], name,
                  @[[AppSettings getValueAttrTwo]], values,
                  @"true" , routable,
                  nil];
        [attributeArray addObject:dict2];
    }
    if ([[AppSettings getNameAttrThree] isEqual: @"" ] || [[AppSettings getValueAttrThree]isEqualToString:@""]) {
        [Logging logDebug:@"%s Attribute Three Not Set", __PRETTY_FUNCTION__];
    } else {
        dict3 =  [NSDictionary dictionaryWithObjectsAndKeys:
                  [AppSettings getNameAttrThree], name,
                  @[[AppSettings getValueAttrThree]], values,
                  @"true" , routable,
                  nil];
        [attributeArray addObject:dict3];
    }
    return attributeArray;
}

@end


