//
//  AppSettings.h
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//
//
#import <OceanaCustomerWebVoiceVideo/AOOceanaCustomerWebVoiceVideo.h>

@interface AppSettings : NSObject

//Client 
+(NSString*) getPort;
+(NSString*) getServer;
+(NSString*) getUsername;
+(NSString*) getDisplayName;
+(NSString*) getCustID;
+(NSString*) getDestinationAddress;
+(NSString*) getAMCRestUrl;
+(NSString*) getTopic;
+(BOOL) useSecureLogin;

//AAWG
+(NSString*) getAAWGServerAddress;
+(NSString*) getAAWGServerPort;
+(BOOL) isAawgSecure;
+(NSString*) getAAWGRestUrl;

//TokenService
+(NSString*) getTokenServiceAddress;
+(NSString*) getTokenServicePort;
+(BOOL) isTokenServiceSecure;
+(NSString*) getTokenServiceUrlPath;

//Attribute Settings
+(NSString*) getPriority;
+(NSString*) getLocale;
+(NSString*) getStrategy;
+(NSString*) getSourceName;
+(NSString*) getResourceId;
+(NSString*) getNameAttrOne;
+(NSString*) getValueAttrOne;
+(NSString*) getNameAttrTwo;
+(NSString*) getValueAttrTwo;
+(NSString*) getNameAttrThree;
+(NSString*) getValueAttrThree;

//Logging Settings
+(int) getLogLevel;
+(int) getLogFileSize;
+(int) getMaxLogNumber;
+(BOOL) isFileLoggingEnabled;
+(NSString*) getLogFileName;

+ (NSDictionary *)readSettignsFromJSON;
+(void) wrightSettignsFromJSON : (NSDictionary *) settingsJson;

+(AOPlatformType) selectedPlatform;
+(void) setSelectedPlatform : (AOPlatformType) type;

@end
