//
//  OceanaClient.h
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import "OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h"
#import "OceanaVideoClient.h"


@interface OceanaClient : NSObject

- (void) setAuthorizationToken:(NSString*)token;

- (void) configureAudio;

- (void) startInteraction;

- (void) endInteraction;

- (void) discard;

- (void) sendDTMF:(AODTMFTone) tone;

- (void) toggleMuteAudio;

- (void) toggleHold;

- (long) getCallTimeElapsed;

- (void) setAudioDelegate:(NSObject<AOAudioInteractionDelegate>*)delegate;

- (void) setConnectionlistenerDelegate:(NSObject<AOConnectionListenerDelegate>*)delegate;

- (BOOL) isHeld;

- (AOInteractionState) getInteractionState;

- (NSString*)versionNumber;

- (void)readAudioDetailsWithCompletionHandler:(void (^)(AOAudioDetails *audioDetails))handler;
- (void)readCallTypeWithCompletionHandler:(void (^)(NSString *csCallTypeString))handler;
@end
