//
//  AMVTokenRequest.h
//  OceanaReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.

@protocol AAWGTokenRequestDelegate <NSObject>

/**
 * Called when a get token attempt succeeds.
 */
-(void) getAAWGTokenSuccessful:(NSString *)token;

/**
 * Called when a get token attempt fails.
 */
-(void) getAAWGTokenFailed:(NSError *)error;

@end

@interface AAWGTokenRequest : NSObject<NSURLSessionDelegate>

/**
 * Login asynchronously against the given AAWG token server using NSURLConnection
 */
-(void)getAuthenticationToken:(NSString*)server displayName:(NSString*)displayName fromAddress:(NSString*)fromAddress andNotify:(id<AAWGTokenRequestDelegate>)delegate;

@end
