//
//  CollapsibleTableViewHeader.m
//  OceanaReferenceClient
//
//  Created by Mohan on 15/07/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "CollapsibleTableViewHeader.h"

@implementation CollapsibleTableViewHeader


-(instancetype) initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self != nil) {
        
        self.titleLabel = [[UILabel alloc] initWithFrame: CGRectMake(10, frame.size.height/2 - 10, 200, 20)];
        self.titleLabel.font = [UIFont systemFontOfSize:15 weight:UIFontWeightBold];
        self.titleLabel.textColor = [UIColor whiteColor];
        self.arrowLabel = [[UIImageView alloc] initWithFrame: CGRectMake(frame.size.width - 25, frame.size.height/2 - 10, 20, 20)];
        self.arrowLabel.contentMode = UIViewContentModeScaleToFill;
        [self.arrowLabel setImage:[UIImage imageNamed:@"ic_sett_header"]];
        
        [self addSubview:self.titleLabel];
        [self addSubview:self.arrowLabel];
        
        UITapGestureRecognizer *singleTop = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(headerTapped:)];
        singleTop.numberOfTouchesRequired = 1;
        singleTop.numberOfTapsRequired = 1;
        [self addGestureRecognizer:singleTop];
    }
    return self;
}

-(void) headerTapped : (UITapGestureRecognizer*) gestureRecognizer {
    
    if (self.delegate && [self.delegate respondsToSelector:@selector(toggleSection::)]){
        [self.delegate toggleSection:self : self.section];
    }
}

-(void) setCollapsed : (BOOL) toCollapse {
    self.isCollapsed = toCollapse;
    self.arrowLabel.transform = CGAffineTransformMakeRotation(toCollapse ? 0 : M_PI_2); //rotation in radians
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
     Drawing code  myImageView.transform = CGAffineTransformMakeRotation(M_PI_2); //rotation in radians

}
*/

@end
