//
//  SideBarViewController.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import <Foundation/Foundation.h>
#import "SideBarViewController.h"
#import "AppSettings.h"
#import "Logging.h"
#import "IssueReporter.h"
#import "AppDelegate.h"

#define SYSTEM_VERSION_GREATER_THAN_OR_EQUAL_TO(v)  ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] != NSOrderedAscending)

@interface SidebarViewController ()

@end

@implementation SidebarViewController {
    NSArray *menuItems;
}

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    menuItems = @[@"Settings", @"Feedback"];
#ifdef DEBUG_1
    menuItems = @[@"Settings", @"Feedback", @"Change Audio CODEC"];
#endif
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    return menuItems.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *CellIdentifier = [menuItems objectAtIndex:indexPath.row];
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier forIndexPath:indexPath];
    
    return cell;
}

#ifdef DEBUG_1
-(void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (indexPath.row == 2) {
        [self.revealViewController rightRevealToggleAnimated:YES];
        [self showAndSelectTheAudioCodec];
        
    }
}
- (IBAction)showSelecteCodec:(UIButton *)sender {
    [self.revealViewController rightRevealToggleAnimated:YES];
    [self showAndSelectTheAudioCodec];
}

-(void) showAndSelectTheAudioCodec {
    
    AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];
    
    UIAlertController *actionSheet = [UIAlertController alertControllerWithTitle:@"Select From" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction *g711Action = [UIAlertAction actionWithTitle:@"G.711" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        
        appdelegate.selectedCodec = CSAudioCodecG711A;
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }];
    
    UIAlertAction *opusAction = [UIAlertAction actionWithTitle:@"OPUS" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        appdelegate.selectedCodec = CSAudioCodecOpus;
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }];
    
    switch (appdelegate.selectedCodec) {
        case CSAudioCodecG711A:
            [g711Action setValue:@true forKey:@"checked"];
            break;
        case CSAudioCodecOpus:
            [opusAction setValue:@true forKey:@"checked"];
            break;
        default:
            
            break;
    }
    
    [actionSheet addAction:g711Action];
    [actionSheet addAction:opusAction];
    
    [actionSheet addAction:[UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction *action) {
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }]];
    if (actionSheet.popoverPresentationController != nil) {
        actionSheet.popoverPresentationController.sourceView = self.view;
        actionSheet.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
        actionSheet.popoverPresentationController.permittedArrowDirections = 0;
    }
    [self presentViewController:actionSheet animated:YES completion:nil];
}



#endif
- (IBAction)btnSettingsPressed {
    
    if (SYSTEM_VERSION_GREATER_THAN_OR_EQUAL_TO(@"8.0")) {
        //        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:UIApplicationOpenSettingsURLString]];
    } else {
        UIAlertController *alert = [UIAlertController
                                    alertControllerWithTitle:@"Unsupported Action"
                                    message:@"Please access OceanaReferenceClient settings using the Settings application on this device"
                                    preferredStyle:UIAlertControllerStyleAlert];
        [self presentViewController:alert animated:YES completion:nil];
    }
}

- (IBAction)btnReportPressed {
    NSMutableArray* logFiles = [Logging getErrorLogs];
    if ([logFiles count] > 0) {
        [IssueReporter reportIssue:self];
    } else {
        UIAlertController *alert = [UIAlertController
                                    alertControllerWithTitle:@"No logs to attach."
                                    message:@"Logs get created when application encounters some error or crash."
                                    preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *okButton = [UIAlertAction
                                   actionWithTitle:@"OK"
                                   style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * _Nonnull action) {
                                   }];
        [alert addAction:okButton];
        [self presentViewController:alert animated:YES completion:nil];
    }
}


- (void)mailComposeController:(MFMailComposeViewController*)controller didFinishWithResult:(MFMailComposeResult)result error:(NSError*)error
{
    // Notifies users about errors associated with the interface
    switch (result)
    {
        case MFMailComposeResultCancelled:
            [Logging logInfo:@"Send Issue Report Result: Canceled"];
            break;
        case MFMailComposeResultSaved:
            [Logging logInfo:@"Send Issue Report Result: Saved"];
            break;
        case MFMailComposeResultSent:
            [Logging logInfo:@"Send Issue Report Result: Sent"];
            break;
        case MFMailComposeResultFailed:
            [Logging logInfo:@"Send Issue Report Result: Failed"];
            break;
        default:
            [Logging logInfo:@"Send Issue Report Result: Not Sent"];
            break;
    }
    [self dismissViewControllerAnimated:YES completion:nil];
}

@end
