//
//  OCAAudioCallTest.m
//  OceanaReferenceClientTests
//
//  Created by Mohan on 06/04/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import <XCTest/XCTest.h>
#import <OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h>
#import "AAWGTokenRequest.h"

@interface OCAAudioCallTest : XCTestCase <AAWGTokenRequestDelegate>

@end

@implementation OCAAudioCallTest

- (void)setUp {
    // Put setup code here. This method is called before the invocation of each test method in the class.
}

- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
}

- (void)testExample {
    // This is an example of a functional test case.
    // Use XCTAssert and related functions to verify your tests produce the correct results.
}

- (void)testPerformanceExample {
    // This is an example of a performance test case.
    [self measureBlock:^{
        // Put the code you want to measure the time of here.
    }];
}

-(void) testAWGTokenRequest {
    
    XCTestExpectation * expectation = [self expectationWithDescription:@"AWG Token service"];
    
    NSDictionary *jsonPayload;
    NSString* loginUrlFormatString = @"%@://%@:%i/%@";
    
    NSString* port = @"443";
    NSString* protocol = @"https";
    NSString* urlPath = @"token-generation-service/token/getEncryptedToken";
    NSString*url = [NSString stringWithFormat:loginUrlFormatString, protocol, @"pusntzd205.apac.avaya.com", [port intValue], urlPath];
    
    NSString *displayName = @"Oceana";
    NSString *fromAddress = @"";
        
    NSMutableDictionary *requestPayload = [[NSMutableDictionary alloc]init];
    
    [requestPayload setObject:@"csaGuest" forKey:@"use"];
    [requestPayload setObject:displayName forKey:@"displayName"];
    [requestPayload setObject:fromAddress forKey:@"callingNumber"];
    [requestPayload setObject:@"120000" forKey:@"expiration"];
    
    jsonPayload = [NSDictionary dictionaryWithDictionary:requestPayload];
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonPayload options:NSJSONWritingPrettyPrinted error:nil];
    
    NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
    [request setTimeoutInterval:5.0]; // Test app, so timeout quickly...
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Content-Type"];
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Accept"];
    request.HTTPBody =jsonData;
    request.HTTPMethod = @"POST";
    
    
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *task = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        
        XCTAssertNil(error, @"dataTaskWithURL error %@", error);

        if ([response isKindOfClass:[NSHTTPURLResponse class]]) {
            NSInteger statusCode = [(NSHTTPURLResponse *) response statusCode];
            XCTAssertEqual(statusCode, 200, @"status code was not 200; was %ld", (long)statusCode);
        }

        XCTAssert(data, @"data nil");

        [expectation fulfill];
    }];
    [task resume];
        
    [self waitForExpectationsWithTimeout:20.0 handler:nil];
}

@end

