//
//  GraphStatsViewController.m
//  OceanaReferenceClient
//
//  Created by Mohan on 29/06/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "GraphStatsViewController.h"
#import "AFSessionQualityUtil.h"
#import "Logging.h"
#import "VideoCallView.h"
#import <Charts/Charts.h>

@interface GraphStatsViewController ()<ChartViewDelegate, AOCallQualityChangeDelegate>
{
    LineChartDataSet *dataSet1FromCallDetails;
    LineChartData *dataSetForChart1;
    NSInteger selectedIndex;
    int staticCount;
    
    UILabel *sentLable;
    UILabel *recieveLable;
    NSArray *arrayOfAudioOptions;
    NSArray *arrayOfVideoOptions;
}
@property (strong, nonatomic) LineChartView *lineChart1;
@property (strong, nonatomic) LineChartView *lineChart2;
@property (weak, nonatomic) NSTimer *refreshTimer;
@property (weak, nonatomic) IBOutlet UIProgressView *emosProgressBar;
@property (weak, nonatomic) IBOutlet UILabel *eMOSCOuntLabel;

// Test
@property (nonatomic, strong) NSMutableArray *data;
@property (nonatomic, strong) NSMutableArray *arrayOfFrames;
@property (nonatomic, strong) NSMutableArray *labels;

@property (nonatomic, strong) UIScrollView *mainScrollView;
@property (weak, nonatomic) IBOutlet UIImageView *netwotkQualityImageView;

@end

@implementation GraphStatsViewController 

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    staticCount = 1;
    selectedIndex = 0;
    
    arrayOfAudioOptions = @[NSLocalizedString(@"Packets",nil) , NSLocalizedString(@"Bytes",nil) , NSLocalizedString(@"Round Trip Delay",nil) , NSLocalizedString(@"Processor Usage %",nil)];
    arrayOfVideoOptions = @[NSLocalizedString(@"Packets",nil) , NSLocalizedString(@"Bytes",nil), NSLocalizedString(@"Target Frame Rate",nil), NSLocalizedString(@"Actual Frame Rate",nil),NSLocalizedString( @"Actual Bitrate",nil) , NSLocalizedString(@"Target Bitrate",nil), NSLocalizedString(@"Round Trip Delay",nil) ,NSLocalizedString(@"Processor Usage %",nil)];

    self.mainScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height - 100)];
    [self.view addSubview:self.mainScrollView];
    [self _setupExampleGraph];
}

-(void) viewWillAppear:(BOOL)animated {
    
    [super viewWillAppear:animated];
    
    [self orientationChanged: nil];
    
    if (!self.refreshTimer) {
        if (self.oceanaClient) {
            self.refreshTimer = [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(updateTheCallStatesticsForAudioCall) userInfo:nil repeats:YES];
        } else if (self.oceanaVideoClient) {
            self.refreshTimer = [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(updateTheCallStatesticsForVideoCall) userInfo:nil repeats:YES];
        } else if (self.oceanaClient == nil && self.oceanaVideoClient) {
            UIAlertController *errorAlert = [UIAlertController alertControllerWithTitle:NSLocalizedString(@"Error",nil) message:NSLocalizedString(@"No Audio or Video Client is set",nil) preferredStyle:UIAlertControllerStyleAlert];
            UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"Packets",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                [self dismissViewControllerAnimated:YES completion:nil];
            }];
            [errorAlert addAction:cancelAction];
            [self presentViewController:errorAlert animated:YES completion:nil];
        }
    }
    [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];
    [[NSNotificationCenter defaultCenter]
     addObserver:self selector:@selector(orientationChanged:)
     name:UIDeviceOrientationDidChangeNotification
     object:[UIDevice currentDevice]];
    
}

-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    if (self.refreshTimer) {
        [self.refreshTimer invalidate];
        self.refreshTimer = nil;
    }
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}

- (IBAction)changeTheParamButtonPressed:(UIBarButtonItem *)sender {
    
    UIAlertController *optionsCOntroller = [UIAlertController alertControllerWithTitle:NSLocalizedString(@"Select",nil) message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    if (self.oceanaClient) {
        for(int i = 0; i < arrayOfAudioOptions.count; i++) {
            [optionsCOntroller addAction: [UIAlertAction actionWithTitle:[arrayOfAudioOptions objectAtIndex:i] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self removePreviousValuesFromDataSet];
                selectedIndex = i;
            }]];
        }
    } else if (self.oceanaVideoClient) {
        for(int i = 0; i < arrayOfVideoOptions.count; i++) {
            [optionsCOntroller addAction: [UIAlertAction actionWithTitle:[arrayOfVideoOptions objectAtIndex:i] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self removePreviousValuesFromDataSet];
                selectedIndex = i;
            }]];
        }
    }    
    [optionsCOntroller addAction:[UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        [optionsCOntroller dismissViewControllerAnimated:YES completion:nil];
    }]];
    if (optionsCOntroller.popoverPresentationController != nil) {
           optionsCOntroller.popoverPresentationController.sourceView = self.view;
           optionsCOntroller.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           optionsCOntroller.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:optionsCOntroller animated:YES completion:nil];
}


-(void) removePreviousValuesFromDataSet {
    
    if (self.lineChart1.data.dataSetCount > 0)
    {
        LineChartDataSet *set1 = nil;
        set1 = (LineChartDataSet *)self.lineChart1.data.dataSets[0];
        [set1 clear];
        [set1 notifyDataSetChanged];
        [self.lineChart1.data notifyDataChanged];
        [self.lineChart1 notifyDataSetChanged];
    }
    LineChartDataSet *set2 = nil;
    if (self.lineChart2.data.dataSetCount > 0)
    {
        set2 = (LineChartDataSet *)self.lineChart2.data.dataSets[0];
        [set2 clear];
        [set2 notifyDataSetChanged];
        [self.lineChart2.data notifyDataChanged];
        [self.lineChart2 notifyDataSetChanged];
    }
}


- (IBAction)backButtonPressed:(UIBarButtonItem *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}


#pragma mark- Get Call details


- (void) updateTheCallStatesticsForVideoCall {
    staticCount = staticCount + 1;
    if (self.oceanaVideoClient != nil) {
        [self.oceanaVideoClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
            [self.oceanaVideoClient readVideoDetailsWithCompletionHandler:^(AOVideoDetails *videoDetails) {
                
               self.lineChart2.hidden = NO;
                double yValueR = 0.0;
                double yValueS = 0.0;
                
                recieveLable.hidden = NO;
                NSString *datasetHeader = NSLocalizedString(@"Packets",nil);
                datasetHeader = [arrayOfVideoOptions objectAtIndex:selectedIndex];
                if(selectedIndex == 0) {
                    yValueR = audioDetails.packetsReceived;
                    yValueS = audioDetails.packetsTransmitted;
                    [sentLable setText:NSLocalizedString(@"Packets Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Packets Received",nil)];
                } else if(selectedIndex == 1)  {
                    yValueR = audioDetails.bytesReceived;
                    yValueS = audioDetails.bytesTransmitted;
                    datasetHeader = NSLocalizedString(@"Bytes",nil);
                    [sentLable setText:NSLocalizedString(@"Bytes Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Bytes Received",nil)];
                }
                else if(selectedIndex == 2)  {
                    yValueR = videoDetails.receiveStatistics.targetFrameRate;
                    yValueS = videoDetails.transmitStatistics.targetFrameRate;
                    datasetHeader = NSLocalizedString(@"Target Frame Rate",nil);
                    [sentLable setText:NSLocalizedString(@"Target Frame Rate Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Target Frame Rate Received",nil)];
                } else if(selectedIndex == 3)  {
                    yValueR = videoDetails.receiveStatistics.actualFrameRate;
                    yValueS = videoDetails.transmitStatistics.actualFrameRate;
                    datasetHeader = NSLocalizedString(@"Actual Frame Rate",nil);
                    [sentLable setText:NSLocalizedString(@"Actual Frame Rate Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Actual Frame Rate Received",nil)];
                }else if(selectedIndex == 4)  {
                    yValueR = videoDetails.receiveStatistics.actualBitrate;
                    yValueS = videoDetails.transmitStatistics.actualBitrate;
                    datasetHeader = NSLocalizedString(@"Actual Bitrate",nil);
                    [sentLable setText:NSLocalizedString(@"Actual Bitrate Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Actual Bitrate Received",nil)];
                }else if(selectedIndex == 5)  {
                    yValueR = videoDetails.receiveStatistics.targetBitrate;
                    yValueS = videoDetails.transmitStatistics.targetBitrate;
                    datasetHeader = NSLocalizedString(@"Target Bitrate",nil);
                    [sentLable setText:NSLocalizedString(@"Target Bitrate Sent",nil)];
                    [recieveLable setText:NSLocalizedString(@"Target Bitrate Received",nil)];
                }
                else if(selectedIndex == 6)  {
                    [sentLable setText:datasetHeader];
                    yValueS = audioDetails.roundTripTimeMilliseconds;
                    recieveLable.hidden = YES;
                    self.lineChart2.hidden = YES;
                } else if(selectedIndex == 7)  {
                    yValueS = roundf([AFSessionQualityUtil cpu_usage]/[AFSessionQualityUtil countCores]);
                    [sentLable setText:datasetHeader];
                    recieveLable.hidden = YES;
                    self.lineChart2.hidden = YES;
                }
                
                if (self.lineChart1.data.dataSetCount > 0)
                {
                    LineChartDataSet *set1 = nil;
                    set1 = (LineChartDataSet *)self.lineChart1.data.dataSets[0];
                    if (selectedIndex < 6 ) {
                        [set1 setLabel:[NSString stringWithFormat:@"%@ %@", datasetHeader,NSLocalizedString(@"Sent",nil)]];
                    } else {
                        [set1 setLabel:datasetHeader];
                    }
                    if (set1.entryCount > 10) {
                        BOOL ok = [set1 removeFirst]; if(ok) {}
                    }
                    BOOL isAdded = [set1 addEntry:[[ChartDataEntry alloc] initWithX:staticCount y:yValueS icon: [UIImage imageNamed:@"icon"]]];
                    if (isAdded) {
                        [set1 notifyDataSetChanged];
                        [self.lineChart1.data notifyDataChanged];
                        [self.lineChart1 notifyDataSetChanged];
                    }
                }
                LineChartDataSet *set2 = nil;
                if (self.lineChart2.data.dataSetCount > 0)
                {
                    set2 = (LineChartDataSet *)self.lineChart2.data.dataSets[0];
                    [set2 setLabel:[NSString stringWithFormat:@"%@ %@", datasetHeader,NSLocalizedString(@"Received",nil)]];
                    if (set2.entryCount > 10) {
                        BOOL ok = [set2 removeFirst]; if(ok) {}
                    }
                    BOOL isAdded = [set2 addEntry:[[ChartDataEntry alloc] initWithX:staticCount y:yValueR icon: [UIImage imageNamed:@"icon"]]];
                    if(isAdded) {
                        [set2 notifyDataSetChanged];
                        [self.lineChart2.data notifyDataChanged];
                        [self.lineChart2 notifyDataSetChanged];
                    }
                }
//                [self getMOSFromTheAudioCallStats: audioDetails];
//                [self getMOSFromTheVideoCallStats:videoDetails :audioDetails];
            }];
        }];
    }
}

- (void) updateTheCallStatesticsForAudioCall {
    staticCount = staticCount + 1;
    if (self.oceanaClient != nil) {
        [self.oceanaClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
                        
            self.lineChart2.hidden = NO;
            
            double yValueR = 0.0;
            double yValueS = 0.0;
            
            recieveLable.hidden = NO;
            NSString *datasetHeader = NSLocalizedString(@"Packets",nil);
            datasetHeader = [arrayOfAudioOptions objectAtIndex:selectedIndex];
            if(selectedIndex == 0) {
                yValueR = audioDetails.packetsReceived;
                yValueS = audioDetails.packetsTransmitted;
                
                [sentLable setText:NSLocalizedString(@"Packets Sent",nil)];
                [recieveLable setText:NSLocalizedString(@"Packets Received",nil)];
                
            } else if(selectedIndex == 1)  {
                yValueR = audioDetails.bytesReceived;
                yValueS = audioDetails.bytesTransmitted;
                datasetHeader = NSLocalizedString(@"Bytes",nil);
                [sentLable setText:NSLocalizedString(@"Bytes Sent",nil)];
                [recieveLable setText:NSLocalizedString(@"Bytes Received",nil)];
            } else if(selectedIndex == 2)  {
                [sentLable setText:datasetHeader];
                yValueS = audioDetails.roundTripTimeMilliseconds;
                recieveLable.hidden = YES;
                self.lineChart2.hidden = YES;
            } else if(selectedIndex == 3)  {
                yValueS = roundf([AFSessionQualityUtil cpu_usage]/[AFSessionQualityUtil countCores]);
                [sentLable setText:datasetHeader];
                recieveLable.hidden = YES;
                self.lineChart2.hidden = YES;
            }
            
            if (self.lineChart1.data.dataSetCount > 0)
            {
                LineChartDataSet *set1 = nil;
                set1 = (LineChartDataSet *)self.lineChart1.data.dataSets[0];
                if (selectedIndex < 2 ) {
                    [set1 setLabel:[NSString stringWithFormat:@"%@ %@", datasetHeader,NSLocalizedString(@"Sent",nil)]];
                } else {
                    [set1 setLabel:datasetHeader];
                }
                if (set1.entryCount > 10) {
                    BOOL ok = [set1 removeFirst]; if(ok) {}
                }
                BOOL isAdded = [set1 addEntry:[[ChartDataEntry alloc] initWithX:staticCount y:yValueS icon: [UIImage imageNamed:@"icon"]]];
                if (isAdded) {
                    [set1 notifyDataSetChanged];
                    [self.lineChart1.data notifyDataChanged];
                    [self.lineChart1 notifyDataSetChanged];
                }
            }
            LineChartDataSet *set2 = nil;
            if (self.lineChart2.data.dataSetCount > 0)
            {
                set2 = (LineChartDataSet *)self.lineChart2.data.dataSets[0];
                [set2 setLabel:[NSString stringWithFormat:@"%@ %@", datasetHeader,NSLocalizedString(@"Received",nil)]];
                if (set2.entryCount > 10) {
                    BOOL ok = [set2 removeFirst]; if(ok) {}
                }
                BOOL isAdded = [set2 addEntry:[[ChartDataEntry alloc] initWithX:staticCount y:yValueR icon: [UIImage imageNamed:@"icon"]]];
                if(isAdded) {
                    [set2 notifyDataSetChanged];
                    [self.lineChart2.data notifyDataChanged];
                    [self.lineChart2 notifyDataSetChanged];
                }
            }
//            [self getMOSFromTheAudioCallStats: audioDetails];
        }];
    }
}


-(void) _setupExampleGraph {
    
    sentLable = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 200, 30)];
    sentLable.textAlignment = NSTextAlignmentCenter;
    [sentLable setText:NSLocalizedString(@"Packets Sent",nil)];
    
    sentLable.center = CGPointMake(self.view.center.x, 80);
    
    self.lineChart1 = [[LineChartView alloc] initWithFrame:CGRectMake(10, 100, self.view.frame.size.width - 20, 200)];
    recieveLable = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 200, 30)];
    recieveLable.textAlignment = NSTextAlignmentCenter;
    [recieveLable setText:NSLocalizedString(@"Packets Received",nil)];
    
    recieveLable.center = CGPointMake(self.view.center.x, 320);
    
    sentLable.textColor = [UIColor whiteColor];
    recieveLable.textColor = [UIColor whiteColor];
    
    self.lineChart2 = [[LineChartView alloc] initWithFrame:CGRectMake(10, 340, self.view.frame.size.width - 20, 200)];
    
    [self.mainScrollView addSubview:sentLable];
    [self.mainScrollView addSubview:self.lineChart1];
    [self.mainScrollView addSubview:recieveLable];
    [self.mainScrollView addSubview:recieveLable];
    [self.mainScrollView addSubview:self.lineChart2];
    
    for (int i = 0; i < 1; i++)
    {
        LineChartData *data = [self dataWithCount:1 range:1];
        LineChartData *data2 = [self dataWithCount:2 range:1];
        [data setValueFont:[UIFont fontWithName:@"HelveticaNeue-Light" size:7.f]];
        
        NSArray *colors = @[
            [UIColor colorWithRed:137/255.f green:230/255.f blue:81/255.f alpha:1.f],
            [UIColor colorWithRed:240/255.f green:240/255.f blue:30/255.f alpha:1.f],
            [UIColor colorWithRed:89/255.f green:199/255.f blue:250/255.f alpha:1.f],
            [UIColor colorWithRed:250/255.f green:104/255.f blue:104/255.f alpha:1.f],
        ];
        [self setupChart:self.lineChart1 data:data color:colors[i % colors.count]];
        [self setupChart:self.lineChart2 data:data2 color:colors[1 % colors.count]];
    }
}


#pragma mark- SetUpGraps Tests

- (void)setupChart:(LineChartView *)chart data:(LineChartData *)data color:(UIColor *)color
{
    [(LineChartDataSet *)[data getDataSetByIndex:0] setCircleHoleColor:color];
    
    chart.delegate = self;
    chart.backgroundColor = [UIColor whiteColor];
    
    chart.chartDescription.enabled = YES;
    chart.scaleYEnabled = YES;
    chart.drawGridBackgroundEnabled = NO;
    chart.dragEnabled = NO;
    [chart setScaleEnabled:YES];
    chart.pinchZoomEnabled = YES;
    chart.legend.enabled = YES;
    chart.leftAxis.enabled = YES;
    chart.leftAxis.spaceTop = 0.4;
    chart.leftAxis.spaceBottom = 0.4;
    chart.rightAxis.enabled = YES;
    chart.xAxis.enabled = YES;
    chart.data = data;
    [chart animateWithXAxisDuration:2.5];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (LineChartData *)dataWithCount:(int)count range:(double)range
{
    NSMutableArray *yVals = [[NSMutableArray alloc] init];
    [yVals addObject:[[ChartDataEntry alloc] initWithX:0 y:0]];
    LineChartDataSet *set1 = [[LineChartDataSet alloc] initWithEntries:yVals label:[NSString stringWithFormat:@"DataSet %d", count]];
    if (count == 1) {
        [set1 setLabel:@"Packets Sent"];
    } else {
        [set1 setLabel:@"Packets Received"];
    }
    set1.drawIconsEnabled = NO;
    set1.lineDashLengths = @[@5.f, @2.5f];
    set1.highlightLineDashLengths = @[@5.f, @2.5f];
    [set1 setColor:UIColor.blackColor];
    [set1 setCircleColor:UIColor.blackColor];
    set1.lineWidth = 1.0;
    set1.circleRadius = 3.0;
    set1.drawCircleHoleEnabled = NO;
    set1.valueFont = [UIFont systemFontOfSize:9.f];
    set1.formLineDashLengths = @[@5.f, @2.5f];
    set1.formLineWidth = 1.0;
    set1.formSize = 15.0;
    
    NSArray *gradientColors = @[
        (id)[ChartColorTemplates colorFromString:@"#00ff0000"].CGColor,
        (id)[ChartColorTemplates colorFromString:@"#ffff0000"].CGColor
    ];
    CGGradientRef gradient = CGGradientCreateWithColors(nil, (CFArrayRef)gradientColors, nil);
    
    set1.fillAlpha = 1.f;
    set1.fill = [ChartFill fillWithLinearGradient:gradient angle:90.f];
    set1.drawFilledEnabled = YES;
    
    CGGradientRelease(gradient);
    
    
    return [[LineChartData alloc] initWithDataSet:set1];
}

#pragma mark - ChartViewDelegate

- (void)chartValueSelected:(ChartViewBase * __nonnull)chartView entry:(ChartDataEntry * __nonnull)entry highlight:(ChartHighlight * __nonnull)highlight
{
    [Logging logInfo:@"chartValueSelected"];
}

- (void)chartValueNothingSelected:(ChartViewBase * __nonnull)chartView
{
    NSLog(@"chartValueNothingSelected");
}


//-(void) getMOSFromTheAudioCallStats : (AOAudioDetails *) callDetails {
//
//    NSString *networkQImage = @"1";
//    double EffectiveLatency = callDetails.roundTripTimeMilliseconds + (callDetails.averageJitterReceivedMilliseconds + callDetails.averageJitterTransmittedMilliseconds) + 10;
//    double R = 0.0;
//    if (EffectiveLatency < 160.0) {
//        R = 93.2 - EffectiveLatency/40.0;
//    } else {
//        R = 93.2 - (EffectiveLatency - 120)/10.0;
//    }
//    R = R - (callDetails.currentPacketLossRate * 2.5);
//    double MOS = 1 + (0.035) * R + (.000007) * R * (R-60) * (100-R);
//    self.emosProgressBar.progress = MOS * 40 / 200;
//    NSString *emosValueString = [NSString stringWithFormat:@"Fair : %.2f/5", MOS];
//      if (MOS < 1) {
//          emosValueString = [NSString stringWithFormat:@"Bad : %.2f/5", MOS];
//          self.emosProgressBar.progressTintColor = [UIColor redColor];
//          networkQImage = @"1";
//      } else if (MOS >=1 && MOS < 2){
//          self.emosProgressBar.progressTintColor = [UIColor orangeColor];
//          emosValueString = [NSString stringWithFormat:@"Poor : %.2f/5", MOS];
//          networkQImage = @"2";
//      }else if (MOS >=2 && MOS < 3){
//          self.emosProgressBar.progressTintColor = [UIColor orangeColor];
//          emosValueString = [NSString stringWithFormat:@"Fair : %.2f/5", MOS];
//          networkQImage = @"3";
//      }else if (MOS >= 3 && MOS < 4){
//          emosValueString = [NSString stringWithFormat:@"Good : %.2f/5", MOS];
//          self.emosProgressBar.progressTintColor = [UIColor greenColor];
//          networkQImage = @"4";
//      }else if (MOS >= 4){
//          emosValueString = [NSString stringWithFormat:@"Excellent : %.2f/5", MOS];
//          self.emosProgressBar.progressTintColor = [UIColor greenColor];
//          networkQImage = @"5";
//      }
//      self.eMOSCOuntLabel.text = emosValueString;
//    self.netwotkQualityImageView.image = [UIImage imageNamed: [NSString stringWithFormat:@"ic_networkquality_%@",networkQImage]];
//}

//-(void) getMOSFromTheVideoCallStats : (AOVideoDetails *)callDetailsVideo : (AOAudioDetails *) callDetails {
//    
//    NSString *networkQImage = @"1";
//    double EffectiveLatency = callDetailsVideo.roundTripTimeMilliseconds + (callDetails.averageJitterReceivedMilliseconds + callDetails.averageJitterTransmittedMilliseconds) + 10;
//    double R = 0.0;
//    if (EffectiveLatency < 160.0) {
//        R = 93.2 - EffectiveLatency/40.0;
//    } else {
//        R = 93.2 - (EffectiveLatency - 120)/10.0;
//    }
//    R = R - (callDetails.currentPacketLossRate * 2.5);
//    double MOS = 1 + (0.035) * R + (.000007) * R * (R-60) * (100-R);
////    if (MOS < 2.5) {
////        if ([self.oceanaVideoClient isVideoEnabled]) {
////            [self.oceanaVideoClient toggleVideoEnabled];
////        }
////    } else if (MOS >= 2.5){
////        if (![self.oceanaVideoClient isVideoEnabled]) {
////            [self.oceanaVideoClient toggleVideoEnabled];
////        }
////    }
//    self.emosProgressBar.progress = MOS * 40 / 200;
//    NSString *emosValueString = [NSString stringWithFormat:@"Fair : %.2f/5", MOS];
//    if (MOS < 1) {
//        emosValueString = [NSString stringWithFormat:@"Bad : %.2f/5", MOS];
//        self.emosProgressBar.progressTintColor = [UIColor redColor];
//        networkQImage = @"1";
//    } else if (MOS >=1 && MOS < 2){
//        self.emosProgressBar.progressTintColor = [UIColor orangeColor];
//        emosValueString = [NSString stringWithFormat:@"Poor : %.2f/5", MOS];
//        networkQImage = @"2";
//    }else if (MOS >=2 && MOS < 3){
//        self.emosProgressBar.progressTintColor = [UIColor orangeColor];
//        emosValueString = [NSString stringWithFormat:@"Fair : %.2f/5", MOS];
//        networkQImage = @"3";
//    }else if (MOS >= 3 && MOS < 4){
//        emosValueString = [NSString stringWithFormat:@"Good : %.2f/5", MOS];
//        self.emosProgressBar.progressTintColor = [UIColor greenColor];
//        networkQImage = @"4";
//    }else if (MOS >= 4){
//        emosValueString = [NSString stringWithFormat:@"Excellent : %.2f/5", MOS];
//        self.emosProgressBar.progressTintColor = [UIColor greenColor];
//        networkQImage = @"5";
//    }
//    self.eMOSCOuntLabel.text = emosValueString;
//    self.netwotkQualityImageView.image = [UIImage imageNamed: [NSString stringWithFormat:@"ic_networkquality_%@",networkQImage]];
//}

- (void) orientationChanged:(NSNotification *)note
{
    self.mainScrollView.frame = CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height - 100);
    sentLable.center = CGPointMake(self.view.center.x, 80);
    recieveLable.center = CGPointMake(self.view.center.x, 320);
    self.lineChart1.frame = CGRectMake(10, 100, self.view.frame.size.width - 20, 200);
    self.lineChart2.frame = CGRectMake(10, 340, self.view.frame.size.width - 20, 200);
    self.mainScrollView.contentSize = CGSizeMake(self.mainScrollView.frame.size.width, 550);
}

-(void)renderCallQuality:(AOCallQuality)quality {
    NSString *callQualityRatingResource = @"No_Network";
    NSString *callQualityText = @"";
    if (quality == AOCallQualityExcellent) {
        callQualityRatingResource = @"5";
        callQualityText = @"Excellent";
    } else if (quality == AOCallQualityGood) {
        callQualityRatingResource = @"4";
        callQualityText = @"Good";
    } else if (quality == AOCallQualityFair) {
        callQualityRatingResource = @"3";
        callQualityText = @"Fair";
    } else if (quality == AOCallQualityPoor) {
        callQualityRatingResource = @"2";
        callQualityText = @"Poor";
    } else if (quality == AOCallQualityBad) {
        callQualityRatingResource = @"1";
        callQualityText = @"Bad";
    } else {
        callQualityText = @"No_Network";
//        callQualityRatingResource = R.drawable.ic_networkquality_0;
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        self.eMOSCOuntLabel.text = callQualityText;
        self.netwotkQualityImageView.image = [UIImage imageNamed: [NSString stringWithFormat:@"ic_networkquality_%@",callQualityRatingResource]];
        //self.emosLabelwithImage.text = callQualityText;
    });
}

#pragma mark AOCallQualityChangeDelegate
- (void)callQualityChangedTo:(AOCallQuality)quality {
    [self renderCallQuality:quality];
}


@end
