 //
 //  Logging.h
 //  Oceana™ReferenceClient
 //
 //  Copyright 2016 Avaya Inc
 //  All rights reserved. Usage of this source is bound to the terms described the file
 //  Avaya SDK EULA.txt, included in this SDK.
 //  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 //
 //

#include <UIKit/UIKit.h>

#define NSLog(args...) _Log(@"DEBUG ", __FILE__,__LINE__,__PRETTY_FUNCTION__,args);
@interface Logging : NSObject
/**
 * Function that overrides the standard NSLOG command (see the define above).
 * Allows Avaya Mobile Video SDK log messages to be logged out to a file.
 */
void _Log(NSString *prefix, const char *file, int lineNumber, const char *funcName, NSString *format,...);

/**
 * Returns an array of NSData, where each instance of NSData is the contents of a log file.
 */
+(NSMutableArray *)getErrorLogs;

/**
 *  Read the ASL system logs into a file and return it.
 *  Needed for reading the Reference Client SDK logs.
 */
+(NSData*) readASLLogs;

/**
 * Tells the logger to re-read the app settings.
 */
+(void) updateValuesFromPrefs;

/**
 * Log an exception
 */
+(void) logException: (NSString*) name withReason: (NSString*) reason andTrace: (NSArray*) trace;

/**
 * Log an Error.
 */
+(void) logError: (NSString*) msg, ...;

/**
 * Log a Warning.
 */
+(void) logWarn: (NSString*) msg, ...;

/**
 * Log an Info message.
 */
+(void) logInfo: (NSString*) msg, ...;

/**
 * Log a Debug message.
 */
+(void) logDebug: (NSString*) msg, ...;
//extern NSUInteger ddLogLevel;
@end
