//
//  AppDelegate.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import "AppDelegate.h"
#import "Logging.h"
#import "CrashHandler.h"
#import "NetworkListener.h"
#import "AppSettings.h"
#import <OceanaCustomerWebVoiceVideo/CustomLog.h>
#import "Logging.h"

@interface AppDelegate() <CustomLogDelegate>
@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    // Override point for customization after application launch.
    UIPageControl *pageControl = [UIPageControl appearance];
    UIColor *color= [UIColor colorWithRed:(229/255.0) green:(0/255.0) blue:(35/255.0) alpha:1] ;
    pageControl.pageIndicatorTintColor = color;
    pageControl.currentPageIndicatorTintColor = color;
    pageControl.backgroundColor = [UIColor clearColor];
    
    self.currentSelectedVideoRecordOrientation = AOVideoCaptureOrientation_LandscapeOrPortrait;
    self.currentSelectedVideoRecordPref = AOVideoCapturePreference_Max;
    
    [[NetworkListener getInstance] startListening];
    [Logging logDebug:@"%s", __PRETTY_FUNCTION__];
    [[CrashHandler instance] initialise];
    self.selectedPlatformType = AOPlatFormType_OCEANA;
    [NSThread sleepForTimeInterval:0.5];
    
    AOPlatformType type = [AppSettings selectedPlatform];
    self.selectedPlatformType = type;
    [[CustomLog sharedInstance] setCustomLogDelegate: self];
    [CSClient setLogHandler:^(CSLogLevel level, NSString * _Nullable tag, NSString * _Nonnull message) {
        [[CustomLog sharedInstance] addLogToFile:level withTag:tag message:message];
    }];
    //***********Saving NSLogs to file**********
    /*NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *fileName =[NSString stringWithFormat:@"CompleteLog.log"];
    NSString *logFilePath = [documentsDirectory stringByAppendingPathComponent:fileName];
    //Clear logs when application is relaunched
    if([[NSFileManager defaultManager] fileExistsAtPath:logFilePath]) {
        [[NSFileManager defaultManager] removeItemAtPath:logFilePath error:nil];
    }
    freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding],"a+",stderr);*/
    
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    
    [[NetworkListener getInstance] stopListening];
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    
    [[NetworkListener getInstance] startListening];
    [[CustomLog sharedInstance] addLogToFile:CSLogLevelInfo withTag:@"WebSDK" message:[NSString stringWithFormat:@"%s", __PRETTY_FUNCTION__]];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    [[CustomLog sharedInstance] addLogToFile:CSLogLevelInfo withTag:@"WebSDK" message:[NSString stringWithFormat:@"%s", __PRETTY_FUNCTION__]];
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

#pragma Mark CustomLogDelegate
- (void)didAddLogToFile:(CSLogLevel)level withTag:(NSString * _Nullable)tag message:(NSString * _Nonnull)message {
    NSString *tagString = @"";
    if (tag != NULL) {
        tagString = [NSString stringWithFormat:@"%@:",tag];
    }
    switch (level) {
        case CSLogLevelError:
            [Logging logError:@"%@ %@",tagString, message];
            break;
        case CSLogLevelWarning:
            [Logging logWarn:@"%@ %@",tagString, message];
            break;
        case CSLogLevelInfo:
            [Logging logInfo:@"%@ %@",tagString, message];
            break;
        case CSLogLevelDebug:
            [Logging logDebug:@"%@ %@",tagString, message];
            break;
        default:
            break;
    }
}

@end
