package com.avaya.sdksampleapp.commpackage;

import android.net.Uri;

class MeetingInfo {

    void setConferenceURL(String conferenceURL) {
        this.conferenceURL = conferenceURL;

        // Parse conference URL (e.g. "https://<host>:<port>/portal/tenants/default/?ID=<conference ID>")
        Uri uri = Uri.parse(conferenceURL);
        this.conferenceID  = uri.getQueryParameter("ID");

        // Retrieve all URL string except parameters
        Uri.Builder builder = new Uri.Builder();
        this.portalURL = builder.scheme(uri.getScheme()).encodedAuthority(uri.getAuthority()).path(uri.getPath()).toString();
    }

    String conferenceURL = "";
    String conferenceID = "";
    String portalURL = "";
    String conferencePasscode = "";
    boolean loginAsGuest = true;
    String userDisplayName = "";
    String userName = "";
    String password = "";
}
