package com.avaya.sdksampleapp.commpackage;

import android.util.Log;

import com.avaya.clientservices.credentials.Challenge;
import com.avaya.clientservices.credentials.CredentialCompletionHandler;
import com.avaya.clientservices.credentials.CredentialProvider;
import com.avaya.clientservices.credentials.UserCredential;

/*
 * Credential provider listener section
 */
class UserCredentialProvider implements CredentialProvider {
    private static final String LOG_TAG = UserCredentialProvider.class.getSimpleName();
    private final String userName;
    private final String password;

    public UserCredentialProvider(String userName, String password)
    {
        this.userName = userName;
        this.password = password;
    }

    @Override
    public void onAuthenticationChallenge(Challenge challenge, CredentialCompletionHandler credentialCompletionHandler) {
        Log.d(LOG_TAG, "onAuthenticationChallenge : Challenge = "
                + challenge);

        UserCredential userCredential = null;
        if (challenge.getFailureCount() <= 1) {
            userCredential = new UserCredential(userName, password);
        }
        credentialCompletionHandler.onCredentialProvided(userCredential);
    }

    @Override
    public void onCredentialAccepted(Challenge challenge) {
        Log.d(LOG_TAG, "onCredentialAccepted : Challenge = "
                + challenge);
    }

    @Override
    public void onAuthenticationChallengeCancelled(Challenge challenge) {
        Log.d(LOG_TAG, "onAuthenticationChallengeCancelled : Challenge = "
                + challenge);
    }

    @Override
    public boolean supportsPreEmptiveChallenge() {
        return false;
    }
}
