/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

/**
 * The Callback / simultaneous ring feature Configuration class that contains
 * the callback / simultaneous ring feature parameters specific for this User.
 */
@interface CSSimRingCallbackConfiguration : NSObject

/**
 * A boolean value indicating whether the callback / simultaneous ring feature
 * is enabled to be set up for this User.
 * If the feature is disabled in the configuration but is set up on the server, the server
 * will be requested to disable the feature on its side and clear the user settings.
 * The default value is false.
 */
@property (nonatomic, getter=isEnabled) BOOL enabled;

@end
