/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

#import "CSSimRingCallbackDestination.h"

@class CSSimRingCallbackDestination;

/**
 * This class represents the callback / simultaneous ring feature details for the current
 * user extension.
 * @see CSCallFeatureService::simRingCallback
 * @see CSCallFeatureServiceDelegate::callFeatureService:didChangeSimRingCallbackStatus:
 */
@interface CSSimRingCallbackStatusParameters : NSObject

/**
 * Constructs an empty CSSimRingCallbackStatusParameters object.
 */
- (instancetype)init;

/**
 * Constructs a CSSimRingCallbackStatusParameters object from the specified parameters.
 *
 * @param destination1 The first callback / simultaneous ring destination.
 * @param destination2 The second callback / simultaneous ring destination.
 * @param destination3 The third callback / simultaneous ring destination.
 * @param destination4 The fourth callback / simultaneous ring destination.
 * @param defaultCallbackDestinationNumber The default callback destination number. Can be empty (nil or "").
 *                                         If set up, this number will be used as a source from where
 *                                         the callback call is initiated if it is not explicitly
 *                                         specified in the @see CSCallFeatureService::invokeCallbackCall:withRemoteAddress:completionHandler:
 *                                         feature call.
 */

- (instancetype)initWithDestination1:(CSSimRingCallbackDestination*)destination1
                        destination2:(CSSimRingCallbackDestination*)destination2
                        destination3:(CSSimRingCallbackDestination*)destination3
                        destination4:(CSSimRingCallbackDestination*)destination4
    defaultCallbackDestinationNumber:(NSString*)defaultCallbackDestinationNumber;

/**
 * The first callback / simultaneous ring destination.
 */
@property(nonatomic, readonly) CSSimRingCallbackDestination *destination1;

/**
 * The second callback / simultaneous ring destination.
 */
@property(nonatomic, readonly) CSSimRingCallbackDestination *destination2;

/**
 * The third callback / simultaneous ring destination.
 */
@property(nonatomic, readonly) CSSimRingCallbackDestination *destination3;

/**
 * The fourth callback / simultaneous ring destination.
 */
@property(nonatomic, readonly) CSSimRingCallbackDestination *destination4;

/**
 * The default callback destination number. Can be empty.
 * If set up, this number will be used as a source from where
 * the callback call is initiated if it is not explicitly
 * specified in the @see CSCallFeatureService::invokeCallbackCall:withRemoteAddress:completionHandler:
 * feature call.
 */
@property(nonatomic, readonly) NSString *defaultCallbackDestinationNumber;

@end
