/* Copyright Avaya Inc. */

#import <Foundation/Foundation.h>

/**
 * Defines the list of supported feature modes.
 */
typedef NS_ENUM(NSInteger, CSFeatureMode) {
	/**
	 * The uninitialized (or unknown) feature mode.
	 */
	CSFeatureModeUninitialized = 0,
	
	/**
	 * The button state will be retained on per call basis.
	 */
	CSFeatureModeTransient,
	
	/**
	 * The button state will be retained until changed by the user.
	 */
	CSFeatureModePermanent
};
