/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "DeviceServiceSettingsViewController.h"
#import "SDKManager.h"
#import "ConfigData.h"

@interface DeviceServiceSettingsViewController ()

@end

@implementation DeviceServiceSettingsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    ConfigData *configuration = [ConfigData getInstance];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.applyBtnLabel.attributedTitle];
    titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.applyBtnLabel.attributedTitle = formattedTitle;
    
    self.acsServerAddress.stringValue = configuration.acsServerAddress;
    self.acsPort.integerValue = (UInt)configuration.acsPort;
    
    self.acsUsername.stringValue = configuration.acsUsername;
    self.acsPassword.stringValue = configuration.acsPassword;
    
    self.acsConnectionTypeLabel.title = configuration.acsConnectionTypeSecure ? @"YES" : @"NO";
    
    if (configuration.acsLogin == ACSLoginStatusLoggedIn) {
        
        self.acsLoginStatusLabel.stringValue = @"Logged In";
    } else if (configuration.acsLogin == ACSLoginStatusLoggedOut) {
        
        self.acsLoginStatusLabel.stringValue = @"Not Logged In";
    }
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}

- (IBAction)applyBtn:(id)sender {
    
    ConfigData *configuration = [ConfigData getInstance];
    
    // Check if client is already logged in
    if (configuration.acsLogin == ACSLoginStatusLoggedOut) {
        
        NSLog(@"%s start acs login", __PRETTY_FUNCTION__);
        
        [self saveConfiguration];
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
            
            self.acsLoginStatusLabel.stringValue = @"Logging In";
            // Create user in async task
            [[SDKManager getInstance] setupClient];
        });
    } else if (configuration.acsLogin == ACSLoginStatusLoggedIn) {
        
        // Check if ay configuration has changed before applying it
        if ([configuration.acsUsername isEqualToString:self.acsUsername.stringValue] &
            [configuration.acsPassword isEqualToString:self.acsPassword.stringValue] &
            [configuration.acsServerAddress isEqualToString:self.acsServerAddress.stringValue] &
            (configuration.acsPort == self.acsPort.intValue) &
            (configuration.acsConnectionTypeSecure == self.acsConnectionTypeLabel.state)) {
            
            NSLog(@"%s ACS already logged in, do nothing", __PRETTY_FUNCTION__);
        } else {
            
            NSLog(@"%s start new account login for acs", __PRETTY_FUNCTION__);
            
            [self saveConfiguration];
            
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
                
                self.acsLoginStatusLabel.stringValue = @"Logging In";
                // Create user in async task
                [[SDKManager getInstance] setupClient];
            });
        }
    } else {
        
        NSLog(@"%s User login is in progress, wait...", __PRETTY_FUNCTION__);
    }
    
    [self dismissViewController:self];
}

- (IBAction)acsConnectionType:(id)sender {
    
    NSLog(@"%s state=[%ld]", __PRETTY_FUNCTION__, (long)self.acsConnectionTypeLabel.state);
    if (self.acsConnectionTypeLabel.state == NSOffState) {
        
        NSLog(@"%s set connection type to un-secure", __PRETTY_FUNCTION__);
        self.acsConnectionTypeLabel.title = @"NO";
        
    } else if (self.acsConnectionTypeLabel.state == NSOnState) {
        
        NSLog(@"%s set connection type to secure", __PRETTY_FUNCTION__);
        self.acsConnectionTypeLabel.title = @"YES";
    }
}

- (void)saveConfiguration {
    
    ConfigData *configuration = [ConfigData getInstance];
    
    // Save current configuration in NSUserDefaults
    configuration.acsServerAddress = self.acsServerAddress.stringValue;
    configuration.acsPort = self.acsPort.intValue;
    configuration.acsUsername = self.acsUsername.stringValue;
    configuration.acsPassword = self.acsPassword.stringValue;
    configuration.acsConnectionTypeSecure = self.acsConnectionTypeLabel.state;
    
    NSUserDefaults *standardUserDefaults = [NSUserDefaults standardUserDefaults];
    
    if (standardUserDefaults) {
        [standardUserDefaults setObject:self.acsServerAddress.stringValue forKey:@"acsServerAddress"];
        [standardUserDefaults setInteger:self.acsPort.intValue forKey:@"acsPort"];
        [standardUserDefaults setObject:self.acsUsername.stringValue forKey:@"acsUsername"];
        [standardUserDefaults setObject:self.acsPassword.stringValue forKey:@"acsPassword"];
        [standardUserDefaults setBool:configuration.acsConnectionTypeSecure forKey:@"acsConnectionTypeSecure"];
        [standardUserDefaults synchronize];
    }
}

@end
