/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

/**
 * HID button types.
 */
typedef NS_ENUM(NSUInteger, CSHIDButtonType) {
	/**
	 * The end button.
	 */
	CSHIDButtonTypeEnd,

	/**
	 * The flash button.
	 */
	CSHIDButtonTypeFlash,

	/**
	 * The hook-switch button.
	 */
	CSHIDButtonTypeHookSwitch,

	/**
	 * The ignore button.
	 */
	CSHIDButtonTypeIgnore,

	/**
	 * The mute button.
	 */
	CSHIDButtonTypeMute,

	/**
	 * The redial button.
	 */
	CSHIDButtonTypeRedial
};
