/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "CSWhiteboardSurface.h"
#import "CSWhiteboardTool.h"
#import "CSShapePoint.h"
#import "CSBasicShape.h"

/**
 * CSWhiteboardCanvas object provides canvas which can be displayed during
 * whiteboard session. This object allows also user to draw on it. Canvas
 * should have properly set whiteboard surface by client so as to work properly.
 *
 * \attention If you add this view to NSScrollView, remember about setting wantsLayer
 *            property of scroll view to YES since this class is layer-backed. It provides proper
 *            zooming behavior.
 *
 * @see CSWhiteboardCanvas::whiteboardSurface
 */
@interface CSWhiteboardCanvas : NSView

/**
 * Current whiteboard surface of whiteboard.
 */
@property (strong, nonatomic) CSWhiteboardSurface *whiteboardSurface;

/**
 * Current color of whiteboard. Black is set by default.
 */
@property (strong, nonatomic) NSColor *color;

/**
 * Current tool of whiteboard. eMove is set by default.
 */
@property (assign, nonatomic) CSWhiteboardTool tool;

/**
 * Initializes with frame.
 *
 * @param frameRect Rect that CSWhiteboardCanvas is initialized with.
 */
- (instancetype)initWithFrame:(NSRect)frameRect;

/**
 * Initializes with coder.
 *
 * @param coder Coder that CSWhiteboardCanvas is initialized with.
 */
- (instancetype)initWithCoder:(NSCoder *)coder;

/**
 * Clears whiteboard. Operation is completed on whiteboard canvas (drawings are removed) after
 * response from server. There's also corresponding method for CSWhiteboardSurface class but unless
 * you want to create custom whiteboard canvas, use this one.
 *
 * @param handler A block to be called when the operation is completed.
 *        @li @c surface CSWhiteboardSurface object which was cleared.
 *		  @li @c If the operation was successful this parameter is nil. If an error occurred it
 *        contains an object describing the error.
 */
- (void)clearWhiteboardWithCompletionHandler:(void (^)(CSWhiteboardSurface *surface, NSError *error))handler;

@end
