/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "AppDelegate.h"

@interface AppDelegate ()

@end

@implementation AppDelegate

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
    
    [NSApp setAppearance:[NSAppearance appearanceNamed:NSAppearanceNameAqua]];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(showIncomingCallAlert:) name:kIncomingCallNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(dismissIncomingCallAlert:) name:kMissedCallNotification object:nil];
    
    //Set Incoming Call Alert Object
    self.incomingCall = [[IncomingCallAlert alloc] init];
}

- (void) dealloc {
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kIncomingCallNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kMissedCallNotification object:nil];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification {
}

- (void)showIncomingCallAlert:(NSNotification *)notification {
    
    [self.incomingCall ShowIncomingCallAlert:notification];
}

- (void)dismissIncomingCallAlert:(NSNotification *)notification {
    
    [self.incomingCall didReceiveMissedCall:notification];
}

@end
