/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import <Foundation/Foundation.h>
#import <AvayaClientServices/AvayaClientServices.h>
#import "MediaManager.h"
#import "MessagingServiceManager.h"
#import "Constants.h"

@interface SDKManager : NSObject <CSDataRetrievalWatcherDelegate>

@property (nonatomic, strong) CSClient *client;

@property (nonatomic, strong) NSMutableArray *users;
@property (nonatomic, strong) NSMutableDictionary *calls;
@property (nonatomic, strong) NSMutableArray *contacts;
@property (nonatomic, readonly) CSCall *activeCall;
@property (nonatomic, strong) CSDataRetrievalWatcher *contactsRetrievalWatcher;

@property (nonatomic, strong) MediaManager *mediaManager;
@property (nonatomic, strong) MessagingServiceManager *messagingServiceManager;

+ (instancetype)getInstance;
- (void)setupClient;
- (void)addUsersObject:(CSUser *)object;
- (void)removeUsersObject:(CSUser *)object;
- (CSCall *)callForId: (NSUInteger)callId;

+ (NSString *)applicationVersion;
+ (NSString *)applicationBuildDate;
+ (NSString *)applicationBuildNumber;

@end
