/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import <Foundation/Foundation.h>
#import <AvayaClientServices/AvayaClientServices.h>

@interface MediaManager : NSObject<CSAudioFilePlayerListener>

@property (nonatomic, readonly) CSMediaServicesInstance *mediaServicesInstance;
@property (nonatomic, strong) CSVideoRendererOSX *localVideoSink;
@property (nonatomic, strong) CSVideoRendererOSX *remoteVideoSink;
@property (strong, nonatomic) id<CSAudioFilePlayer> audioFilePlayer;

- (instancetype)init __unavailable;
- (id)initWithClient:(CSClient*)client;

- (void)initializeVideoView: (NSViewController *)viewController;
- (void)printCamerasList;
- (CSVideoCaptureDevice*)getFirstCamera;
- (void)startVideoCapture:(CSVideoCaptureDevice*)camera withFormat:(CSVideoCaptureFormat*)format;
- (void)stopVideoCapture;
- (void)setCamera:(CSVideoCaptureDevice*)camera withFormat:(CSVideoCaptureFormat*)format;
- (BOOL)runLocalVideo;
- (void)runRemoteVideo:(CSCall*)call;
- (void)configureVideoForOutgoingCall:(CSCall*) call withVideoMode:(CSVideoMode)videoMode;
- (void)addVideoToCall:(CSCall*)call withVideoMode:(CSVideoMode)videoMode;
- (void)removeVideoFromCall:(CSCall*)call;
- (void)updateVideoOfCall:(CSCall*)call withVideoMode:(CSVideoMode)videoMode;
- (void)acceptVideoForCall:(CSCall*)call withVideoMode:(CSVideoMode)videoMode;

- (void)updateVideoChannels:(NSArray *)videoChannels;
- (void)printMicrophonesList;
- (void)setMicrophone:(CSMicrophoneDevice*)microphone;

- (void)printSpeakersList;
- (void)setSpeaker:(CSSpeakerDevice*)speaker;

- (BOOL)startPlayingTone:(id<CSAudioFilePlayerListener>)audioFilePlayerListener toneToBePlayed: (CSAudioTone)tone playInLoop: (BOOL)loop;
- (BOOL)stopPlayingTone;

@end

