/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

/**
 * HID Device connection status.
 */
typedef NS_ENUM(NSUInteger, CSHIDDeviceConnectionStatus) {
	/**
	 * The HID service is connected to the device.
	 */
	CSHIDDeviceConnectionStatusConnected,

	/**
	 * The HID service failed to connect to the device. This may be due to the device being used by another application.
	 */
	CSHIDDeviceConnectionStatusConnectionFailed,
	
	/**
	 * The HID service is not connected to the device.
	 */
	CSHIDDeviceConnectionStatusDisconnected
};
