/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "MessagingServiceViewController.h"
#import "SDKManager.h"
#import "MessagingServiceConversationViewController.h"

@interface MessagingServiceViewController ()

@end

@implementation MessagingServiceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.createChatLabel.attributedTitle];
    titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.createChatLabel.attributedTitle = formattedTitle;
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshConversationList:) name:kRefreshConversationListNotification object:nil];
}

- (void) dealloc {
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kRefreshConversationListNotification object:nil];
}

- (void)viewWillAppear {
    
    [super viewWillAppear];
    [self.conversationList reloadData];
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    
    return [SDKManager getInstance].messagingServiceManager.conversationsWatcher.snapshot.count;
}

- (NSView*)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    
    NSArray *logItems = [SDKManager getInstance].messagingServiceManager.conversationsWatcher.snapshot;
    
    CSMessagingConversation *item = logItems[row];
    
    NSTableCellView *cellView = [tableView makeViewWithIdentifier:tableColumn.identifier owner:self];
    if (item.isActive) {
        
        if ([tableColumn.identifier isEqualToString:@"conversationList"]) {
            
            NSLog(@"%s item: [%@]", __PRETTY_FUNCTION__, item);
            
            NSString *list = @"";
            for (CSParticipant* participant in item.allParticipants) {
                
                if ([participant.address isEqualToString:[[[SDKManager getInstance] users].firstObject messagingService].selfAddress]) {
                    
                    continue;
                } else {
                    
                    NSLog(@"%s participant: [%@]", __PRETTY_FUNCTION__, participant.displayName);
                    list = [list stringByAppendingString: [NSString stringWithFormat:@"%@ ", participant.displayName]];
                }
            }
            
            if (item.unreadMessageCount > 0) {
                
                list = [list stringByAppendingString:[NSString stringWithFormat:@"[%lu unread text]", (unsigned long)item.unreadMessageCount]];
            }
            if (item.unreadAttachmentCount > 0) {
                
                list = [list stringByAppendingString:[NSString stringWithFormat:@"[%lu unread media]", (unsigned long)item.unreadAttachmentCount]];
            }
            cellView.textField.stringValue = list;
        }
    }
    return cellView;
}

- (void)tableViewSelectionDidChange:(NSNotification *)notification {
    
    NSTableView *tb = notification.object;
    
    if (tb.selectedRow >= 0) {
        
        NSLog(@"%s selected row: [%lu]", __PRETTY_FUNCTION__, (long)tb.selectedRow + 1);
        self.selectedConversation = [SDKManager getInstance].messagingServiceManager.conversationsWatcher.snapshot[tb.selectedRow];
        NSLog(@"%s conversation:[%@]", __PRETTY_FUNCTION__, self.selectedConversation);
        [self performSegueWithIdentifier:@"openConversationDetails" sender:self];
    }
}

- (void)prepareForSegue:(NSStoryboardSegue *)segue sender:(id)sender {
    
    MessagingServiceConversationViewController *vc = (MessagingServiceConversationViewController *)segue.destinationController;
    if([segue.identifier isEqualToString:@"openConversationDetails"]) {
        
        NSLog(@"%s Perform Open Conversation Screen segue", __PRETTY_FUNCTION__);
        NSLog(@"%s selected Conversation = [%@]", __PRETTY_FUNCTION__, self.selectedConversation);
        vc.selectedConversation = self.selectedConversation;
    }
}

- (void)refreshConversationList:(NSNotification *)notification {
    
    NSLog(@"%s", __PRETTY_FUNCTION__);
    [self.conversationList reloadData];
    [self.conversationList deselectAll:self.conversationList];
}

@end
